/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractNpmAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.SearchException;
import org.owasp.dependencycheck.data.nsp.Advisory;
import org.owasp.dependencycheck.data.nsp.NspSearch;
import org.owasp.dependencycheck.data.nsp.SanitizePackage;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NspAnalyzer
extends AbstractNpmAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NspAnalyzer.class);
    public static final String DEFAULT_URL = "https://api.nodesecurity.io/check";
    public static final String DEPENDENCY_ECOSYSTEM = "npm";
    private static final String PACKAGE_JSON = "package.json";
    private static final FileFilter PACKAGE_JSON_FILTER = FileFilterBuilder.newInstance().addFilenames("package.json").build();
    private NspSearch searcher;

    @Override
    protected FileFilter getFileFilter() {
        return PACKAGE_JSON_FILTER;
    }

    @Override
    public void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        LOGGER.debug("Initializing {}", (Object)this.getName());
        try {
            this.searcher = new NspSearch(this.getSettings());
        }
        catch (MalformedURLException ex) {
            this.setEnabled(false);
            throw new InitializationException("The configured URL to Node Security Platform is malformed", ex);
        }
        try {
            Settings settings = engine.getSettings();
            boolean nodeEnabled = settings.getBoolean("analyzer.node.package.enabled");
            if (!nodeEnabled) {
                LOGGER.warn("The Node Package Analyzer has been disabled; the resulting report will only  contain the known vulnerable dependency - not a bill of materials for the node project.");
            }
        }
        catch (InvalidSettingException ex) {
            throw new InitializationException("Unable to read configuration settings", ex);
        }
    }

    @Override
    public String getName() {
        return "Node Security Platform Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINDING_ANALYSIS;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.nsp.package.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        engine.removeDependency(dependency);
        File file = dependency.getActualFile();
        if (!file.isFile() || file.length() == 0L || !this.shouldProcess(file)) {
            return;
        }
        try (JsonReader jsonReader = Json.createReader((InputStream)FileUtils.openInputStream((File)file));){
            JsonObject packageJson = jsonReader.readObject();
            JsonObject sanitizedJson = SanitizePackage.sanitize(packageJson);
            JsonObjectBuilder builder = Json.createObjectBuilder();
            JsonObject nspPayload = builder.add("package", (JsonValue)sanitizedJson).build();
            List<Advisory> advisories = this.searcher.submitPackage(nspPayload);
            for (Advisory advisory : advisories) {
                Vulnerability vuln = new Vulnerability();
                vuln.setCvssScore(advisory.getCvssScore());
                vuln.setDescription(advisory.getOverview());
                vuln.setName(String.valueOf(advisory.getId()));
                vuln.setSource(Vulnerability.Source.NSP);
                vuln.addReference("NSP", "Advisory " + advisory.getId() + ": " + advisory.getTitle(), advisory.getAdvisory());
                VulnerableSoftware vs = new VulnerableSoftware();
                vs.setName(advisory.getModule() + ":" + advisory.getVulnerableVersions());
                vuln.setVulnerableSoftware(new HashSet<VulnerableSoftware>(Arrays.asList(vs)));
                Dependency existing = this.findDependency(engine, advisory.getModule(), advisory.getVersion());
                if (existing == null) {
                    Dependency nodeModule = this.createDependency(dependency, advisory.getModule(), advisory.getVersion(), "transitive");
                    nodeModule.addVulnerability(vuln);
                    engine.addDependency(nodeModule);
                    continue;
                }
                existing.addVulnerability(vuln);
            }
        }
        catch (URLConnectionFailureException e) {
            this.setEnabled(false);
            throw new AnalysisException("Failed to connect to the Node Security Project (NspAnalyzer); the analyzer is being disabled and may result in false negatives.", e);
        }
        catch (IOException e) {
            LOGGER.debug("Error reading dependency or connecting to Node Security Platform - check API", (Throwable)e);
            this.setEnabled(false);
            throw new AnalysisException("Failed to read results from the Node Security Project (NspAnalyzer); the analyzer is being disabled and may result in false negatives.", e);
        }
        catch (JsonException e) {
            throw new AnalysisException(String.format("Failed to parse %s file from the Node Security Platform (NspAnalyzer).", file.getPath()), e);
        }
        catch (SearchException ex) {
            LOGGER.error("NspAnalyzer failed on {}", (Object)dependency.getActualFilePath());
            throw ex;
        }
    }
}

