/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.lucene;

import java.io.Reader;
import java.util.Collection;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.util.Version;
import org.owasp.dependencycheck.data.lucene.AlphaNumericTokenizer;
import org.owasp.dependencycheck.data.lucene.LuceneUtils;
import org.owasp.dependencycheck.data.lucene.TokenPairConcatenatingFilter;
import org.owasp.dependencycheck.data.lucene.UrlTokenizingFilter;

public class SearchFieldAnalyzer
extends Analyzer {
    private final Version version;
    private static final String[] ADDITIONAL_STOP_WORDS = new String[]{"software", "framework", "inc", "com", "org", "net", "www", "consulting", "ltd", "foundation", "project"};
    private final CharArraySet stopWords;

    public static CharArraySet getStopWords() {
        CharArraySet words = StopFilter.makeStopSet((Version)LuceneUtils.CURRENT_VERSION, (String[])ADDITIONAL_STOP_WORDS, (boolean)true);
        words.addAll((Collection)StopAnalyzer.ENGLISH_STOP_WORDS_SET);
        return words;
    }

    public SearchFieldAnalyzer(Version version) {
        this.version = version;
        this.stopWords = SearchFieldAnalyzer.getStopWords();
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        AlphaNumericTokenizer source;
        Object stream = source = new AlphaNumericTokenizer(this.version, reader);
        stream = new WordDelimiterFilter((TokenStream)stream, 483, null);
        stream = new LowerCaseFilter(this.version, (TokenStream)stream);
        stream = new UrlTokenizingFilter((TokenStream)stream);
        stream = new StopFilter(this.version, (TokenStream)stream, this.stopWords);
        stream = new TokenPairConcatenatingFilter((TokenStream)stream);
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)stream);
    }
}

