/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.data.update.nvd.NvdCveInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DatabaseProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseProperties.class);
    public static final String MODIFIED = "Modified";
    public static final String LAST_CHECKED = "NVD CVE Checked";
    public static final String LAST_UPDATED = "NVD CVE Modified";
    public static final String LAST_UPDATED_BASE = "NVD CVE ";
    public static final String LAST_CPE_UPDATE = "LAST_CPE_UPDATE";
    public static final String VERSION = "version";
    private final Properties properties;
    private final CveDB cveDB;

    DatabaseProperties(CveDB cveDB) {
        this.cveDB = cveDB;
        this.properties = cveDB.getProperties();
    }

    public synchronized boolean isEmpty() {
        return this.properties == null || this.properties.isEmpty();
    }

    public synchronized void save(NvdCveInfo updatedValue) throws UpdateException {
        if (updatedValue == null) {
            return;
        }
        this.save(LAST_UPDATED_BASE + updatedValue.getId(), String.valueOf(updatedValue.getTimestamp()));
    }

    public synchronized void save(String key, String value) throws UpdateException {
        this.properties.put(key, value);
        this.cveDB.saveProperty(key, value);
    }

    public synchronized String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public synchronized String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public synchronized Properties getProperties() {
        return this.properties;
    }

    public synchronized Map<String, String> getMetaData() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key = (String)entry.getKey();
            if (VERSION.equals(key)) continue;
            if (key.startsWith(LAST_UPDATED_BASE)) {
                try {
                    long epoch = Long.parseLong((String)entry.getValue());
                    DateTime date = new DateTime(epoch);
                    DateTimeFormatter format = DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm:ss");
                    String formatted = format.print((ReadableInstant)date);
                    map.put(key, formatted);
                }
                catch (Throwable ex) {
                    LOGGER.debug("Unable to parse timestamp from DB", ex);
                    map.put(key, (String)entry.getValue());
                }
                continue;
            }
            map.put(key, (String)entry.getValue());
        }
        return map;
    }
}

