/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nsp.Advisory;
import org.owasp.dependencycheck.data.nsp.NspSearch;
import org.owasp.dependencycheck.data.nsp.SanitizePackage;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NspAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NspAnalyzer.class);
    public static final String DEFAULT_URL = "https://api.nodesecurity.io/check";
    private static final String PACKAGE_JSON = "package.json";
    private static final FileFilter PACKAGE_JSON_FILTER = FileFilterBuilder.newInstance().addFilenames("package.json").build();
    private NspSearch searcher;

    @Override
    protected FileFilter getFileFilter() {
        return PACKAGE_JSON_FILTER;
    }

    @Override
    public void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        LOGGER.debug("Initializing {}", (Object)this.getName());
        try {
            this.searcher = new NspSearch(this.getSettings());
        }
        catch (MalformedURLException ex) {
            this.setEnabled(false);
            throw new InitializationException("The configured URL to Node Security Platform is malformed", ex);
        }
    }

    @Override
    public String getName() {
        return "Node Security Platform Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINDING_ANALYSIS;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.nsp.package.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        File file = dependency.getActualFile();
        if (!file.isFile() || file.length() == 0L) {
            return;
        }
        try (JsonReader jsonReader = Json.createReader((InputStream)FileUtils.openInputStream((File)file));){
            JsonObject dependencies;
            Object value;
            if (file.getCanonicalPath().contains(File.separator + "node_modules" + File.separator)) {
                LOGGER.debug("Skipping analysis of node module: " + file.getCanonicalPath());
                return;
            }
            JsonObject packageJson = jsonReader.readObject();
            JsonObject sanitizedJson = SanitizePackage.sanitize(packageJson);
            JsonObjectBuilder builder = Json.createObjectBuilder();
            JsonObject nspPayload = builder.add("package", (JsonValue)sanitizedJson).build();
            List<Advisory> advisories = this.searcher.submitPackage(nspPayload);
            for (Advisory advisory : advisories) {
                Vulnerability vuln = new Vulnerability();
                vuln.setCvssScore(advisory.getCvssScore());
                vuln.setDescription(advisory.getOverview());
                vuln.setName(String.valueOf(advisory.getId()));
                vuln.setSource(Vulnerability.Source.NSP);
                vuln.addReference("NSP", "Advisory " + advisory.getId() + ": " + advisory.getTitle(), advisory.getAdvisory());
                VulnerableSoftware vs = new VulnerableSoftware();
                vs.setUpdate(advisory.getPatchedVersions());
                vs.setName(advisory.getModule() + ":" + advisory.getVulnerableVersions());
                vuln.setVulnerableSoftware(new HashSet<VulnerableSoftware>(Arrays.asList(vs)));
                dependency.addVulnerability(vuln);
            }
            if (packageJson.containsKey((Object)"name")) {
                value = packageJson.get((Object)"name");
                if (value instanceof JsonString) {
                    String valueString = ((JsonString)value).getString();
                    dependency.addEvidence(EvidenceType.PRODUCT, PACKAGE_JSON, "name", valueString, Confidence.HIGHEST);
                    dependency.addEvidence(EvidenceType.VENDOR, PACKAGE_JSON, "name_project", String.format("%s_project", valueString), Confidence.LOW);
                } else {
                    LOGGER.warn("JSON value not string as expected: {}", value);
                }
            }
            if (packageJson.containsKey((Object)"dependencies")) {
                dependencies = packageJson.getJsonObject("dependencies");
                this.processPackage(dependency, dependencies, "dependencies");
            }
            if (packageJson.containsKey((Object)"devDependencies")) {
                dependencies = packageJson.getJsonObject("devDependencies");
                this.processPackage(dependency, dependencies, "devDependencies");
            }
            if (packageJson.containsKey((Object)"optionalDependencies")) {
                dependencies = packageJson.getJsonObject("optionalDependencies");
                this.processPackage(dependency, dependencies, "optionalDependencies");
            }
            if (packageJson.containsKey((Object)"peerDependencies")) {
                dependencies = packageJson.getJsonObject("peerDependencies");
                this.processPackage(dependency, dependencies, "peerDependencies");
            }
            if (packageJson.containsKey((Object)"bundleDependencies")) {
                dependencies = packageJson.getJsonArray("bundleDependencies");
                this.processPackage(dependency, (JsonArray)dependencies, "bundleDependencies");
            }
            if (packageJson.containsKey((Object)"bundledDependencies")) {
                dependencies = packageJson.getJsonArray("bundledDependencies");
                this.processPackage(dependency, (JsonArray)dependencies, "bundledDependencies");
            }
            if (packageJson.containsKey((Object)"license")) {
                value = packageJson.get((Object)"license");
                if (value instanceof JsonString) {
                    dependency.setLicense(packageJson.getString("license"));
                } else {
                    dependency.setLicense(packageJson.getJsonObject("license").getString("type"));
                }
            }
            this.addToEvidence(dependency, EvidenceType.PRODUCT, packageJson, "description");
            this.addToEvidence(dependency, EvidenceType.VENDOR, packageJson, "author");
            this.addToEvidence(dependency, EvidenceType.VERSION, packageJson, "version");
            dependency.setDisplayFileName(String.format("%s/%s", file.getParentFile().getName(), file.getName()));
        }
        catch (URLConnectionFailureException e) {
            this.setEnabled(false);
            throw new AnalysisException(e.getMessage(), e);
        }
        catch (IOException e) {
            LOGGER.debug("Error reading dependency or connecting to Node Security Platform - check API", (Throwable)e);
            this.setEnabled(false);
            throw new AnalysisException(e.getMessage(), e);
        }
        catch (JsonException e) {
            throw new AnalysisException(String.format("Failed to parse %s file.", file.getPath()), e);
        }
    }

    private void processPackage(Dependency dependency, JsonArray jsonArray, String depType) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (JsonString str : jsonArray.getValuesAs(JsonString.class)) {
            builder.add(str.toString(), "");
        }
        JsonObject jsonObject = builder.build();
        this.processPackage(dependency, jsonObject, depType);
    }

    private void processPackage(Dependency dependency, JsonObject jsonObject, String depType) {
        for (int i = 0; i < jsonObject.size(); ++i) {
            for (Map.Entry entry : jsonObject.entrySet()) {
                Identifier moduleName = new Identifier("npm", "Module", null, (String)entry.getKey());
                moduleName.setConfidence(Confidence.HIGHEST);
                String version = "";
                if (entry.getValue() != null && ((JsonValue)entry.getValue()).getValueType() == JsonValue.ValueType.STRING) {
                    version = ((JsonString)entry.getValue()).getString();
                }
                Identifier moduleVersion = new Identifier("npm", "Version", null, version);
                moduleVersion.setConfidence(Confidence.HIGHEST);
                Identifier moduleDepType = new Identifier("npm", "Scope", null, depType);
                moduleVersion.setConfidence(Confidence.HIGHEST);
                Dependency nodeModule = new Dependency(new File(dependency.getActualFile() + "#" + (String)entry.getKey()), true);
                nodeModule.setDisplayFileName((String)entry.getKey());
                nodeModule.addIdentifier(moduleName);
                nodeModule.addIdentifier(moduleVersion);
                nodeModule.addIdentifier(moduleDepType);
                dependency.addRelatedDependency(nodeModule);
            }
        }
    }

    private void addToEvidence(Dependency dep, EvidenceType type, JsonObject json, String key) {
        if (json.containsKey((Object)key)) {
            JsonValue value = (JsonValue)json.get((Object)key);
            if (value instanceof JsonString) {
                dep.addEvidence(type, PACKAGE_JSON, key, ((JsonString)value).getString(), Confidence.HIGHEST);
            } else if (value instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)value;
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String property = (String)entry.getKey();
                    JsonValue subValue = (JsonValue)entry.getValue();
                    if (subValue instanceof JsonString) {
                        dep.addEvidence(type, PACKAGE_JSON, String.format("%s.%s", key, property), ((JsonString)subValue).getString(), Confidence.HIGHEST);
                        continue;
                    }
                    LOGGER.warn("JSON sub-value not string as expected: {}", (Object)subValue);
                }
            } else {
                LOGGER.warn("JSON value not string or JSON object as expected: {}", (Object)value);
            }
        }
    }
}

