/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractAnalyzer
implements Analyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAnalyzer.class);
    private volatile boolean enabled = true;
    private Settings settings;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected Settings getSettings() {
        return this.settings;
    }

    @Override
    public void initialize(Settings settings) {
        this.settings = settings;
    }

    @Override
    public final void prepare(Engine engine) throws InitializationException {
        String key = this.getAnalyzerEnabledSettingKey();
        try {
            this.setEnabled(this.settings.getBoolean(key, true));
        }
        catch (InvalidSettingException ex) {
            String msg = String.format("Invalid setting for property '%s'", key);
            LOGGER.warn(msg);
            LOGGER.debug(msg, (Throwable)ex);
        }
        if (this.isEnabled()) {
            this.prepareAnalyzer(engine);
        } else {
            LOGGER.debug("{} has been disabled", (Object)this.getName());
        }
    }

    protected void prepareAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    public final void analyze(Dependency dependency, Engine engine) throws AnalysisException {
        if (this.isEnabled()) {
            this.analyzeDependency(dependency, engine);
        }
    }

    protected abstract void analyzeDependency(Dependency var1, Engine var2) throws AnalysisException;

    @Override
    public final void close() throws Exception {
        if (this.isEnabled()) {
            this.closeAnalyzer();
        }
    }

    protected void closeAnalyzer() throws Exception {
    }

    @Override
    public boolean supportsParallelProcessing() {
        return true;
    }

    protected abstract String getAnalyzerEnabledSettingKey();
}

