/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.utils.DateUtil;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineVersionCheck
implements CachedWebDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineVersionCheck.class);
    public static final String ENGINE_VERSION_CHECKED_ON = "VersionCheckOn";
    public static final String CURRENT_ENGINE_RELEASE = "CurrentEngineRelease";
    private String updateToVersion;

    protected String getUpdateToVersion() {
        return this.updateToVersion;
    }

    protected void setUpdateToVersion(String version) {
        this.updateToVersion = version;
    }

    @Override
    public void update() throws UpdateException {
        try (CveDB db = CveDB.getInstance();){
            boolean autoupdate = Settings.getBoolean((String)"autoupdate", (boolean)true);
            boolean enabled = Settings.getBoolean((String)"updater.versioncheck.enabled", (boolean)true);
            String original = Settings.getString((String)"cve.url-2.0.original");
            String current = Settings.getString((String)"cve.url-2.0.modified");
            if (enabled && autoupdate && original != null && original.equals(current)) {
                LOGGER.debug("Begin Engine Version Check");
                DatabaseProperties properties = db.getDatabaseProperties();
                long lastChecked = Long.parseLong(properties.getProperty(ENGINE_VERSION_CHECKED_ON, "0"));
                long now = System.currentTimeMillis();
                this.updateToVersion = properties.getProperty(CURRENT_ENGINE_RELEASE, "");
                String currentVersion = Settings.getString((String)"application.version", (String)"0.0.0");
                LOGGER.debug("Last checked: {}", (Object)lastChecked);
                LOGGER.debug("Now: {}", (Object)now);
                LOGGER.debug("Current version: {}", (Object)currentVersion);
                boolean updateNeeded = this.shouldUpdate(lastChecked, now, properties, currentVersion);
                if (updateNeeded) {
                    LOGGER.warn("A new version of dependency-check is available. Consider updating to version {}.", (Object)this.updateToVersion);
                }
            }
        }
        catch (DatabaseException ex) {
            LOGGER.debug("Database Exception opening databases to retrieve properties", (Throwable)ex);
            throw new UpdateException("Error occurred updating database properties.");
        }
        catch (InvalidSettingException ex) {
            LOGGER.debug("Unable to determine if autoupdate is enabled", (Throwable)ex);
        }
    }

    protected boolean shouldUpdate(long lastChecked, long now, DatabaseProperties properties, String currentVersion) throws UpdateException {
        int checkRange = 30;
        if (!DateUtil.withinDateRange(lastChecked, now, 30)) {
            DependencyVersion v;
            LOGGER.debug("Checking web for new version.");
            String currentRelease = this.getCurrentReleaseVersion();
            if (currentRelease != null && (v = new DependencyVersion(currentRelease)).getVersionParts() != null && v.getVersionParts().size() >= 3) {
                this.updateToVersion = v.toString();
                if (!currentRelease.equals(this.updateToVersion)) {
                    properties.save(CURRENT_ENGINE_RELEASE, this.updateToVersion);
                }
                properties.save(ENGINE_VERSION_CHECKED_ON, Long.toString(now));
            }
            LOGGER.debug("Current Release: {}", (Object)this.updateToVersion);
        }
        if (this.updateToVersion == null) {
            LOGGER.debug("Unable to obtain current release");
            return false;
        }
        DependencyVersion running = new DependencyVersion(currentVersion);
        DependencyVersion released = new DependencyVersion(this.updateToVersion);
        if (running.compareTo(released) < 0) {
            LOGGER.debug("Upgrade recommended");
            return true;
        }
        LOGGER.debug("Upgrade not needed");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCurrentReleaseVersion() {
        HttpURLConnection conn = null;
        try {
            String str = Settings.getString((String)"engine.version.url", (String)"http://jeremylong.github.io/DependencyCheck/current.txt");
            URL url = new URL(str);
            conn = URLConnectionFactory.createHttpURLConnection((URL)url);
            conn.connect();
            if (conn.getResponseCode() != 200) {
                String string = null;
                return string;
            }
            String releaseVersion = IOUtils.toString((InputStream)conn.getInputStream(), (String)"UTF-8");
            if (releaseVersion != null) {
                String string = releaseVersion.trim();
                return string;
            }
        }
        catch (MalformedURLException ex) {
            LOGGER.debug("Unable to retrieve current release version of dependency-check - malformed url?");
        }
        catch (URLConnectionFailureException ex) {
            LOGGER.debug("Unable to retrieve current release version of dependency-check - connection failed");
        }
        catch (IOException ex) {
            LOGGER.debug("Unable to retrieve current release version of dependency-check - i/o exception");
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }
}

