/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.FileFilter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FalsePositiveAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FalsePositiveAnalyzer.class);
    private static final FileFilter DLL_EXE_FILTER = FileFilterBuilder.newInstance().addExtensions("dll", "exe").build();
    public static final Pattern CORE_JAVA = Pattern.compile("^cpe:/a:(sun|oracle|ibm):(j2[ems]e|java(_platform_micro_edition|_runtime_environment|_se|virtual_machine|se_development_kit|fx)?|jdk|jre|jsse)($|:.*)");
    public static final Pattern CORE_JAVA_JSF = Pattern.compile("^cpe:/a:(sun|oracle|ibm):jsf($|:.*)");
    public static final Pattern CORE_FILES = Pattern.compile("(^|/)((alt[-])?rt|jsse|jfxrt|jfr|jce|javaws|deploy|charsets)\\.jar$");
    public static final Pattern CORE_JSF_FILES = Pattern.compile("(^|/)jsf[-][^/]*\\.jar$");
    private static final String ANALYZER_NAME = "False Positive Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.POST_IDENTIFIER_ANALYSIS;

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.falsepositive.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        this.removeJreEntries(dependency);
        this.removeBadMatches(dependency);
        this.removeBadSpringMatches(dependency);
        this.removeWrongVersionMatches(dependency);
        this.removeSpuriousCPE(dependency);
        this.removeDuplicativeEntriesFromJar(dependency, engine);
        this.addFalseNegativeCPEs(dependency);
    }

    private void removeBadSpringMatches(Dependency dependency) {
        String mustContain = null;
        for (Identifier i : dependency.getIdentifiers()) {
            int endPoint;
            if (!"maven".contains(i.getType()) || i.getValue() == null || !i.getValue().startsWith("org.springframework.") || (endPoint = i.getValue().indexOf(58, 19)) < 0) continue;
            mustContain = i.getValue().substring(19, endPoint).toLowerCase();
            break;
        }
        if (mustContain != null) {
            Iterator<Identifier> itr = dependency.getIdentifiers().iterator();
            while (itr.hasNext()) {
                Identifier i;
                i = itr.next();
                if (!"cpe".contains(i.getType()) || i.getValue() == null || !i.getValue().startsWith("cpe:/a:springsource:") || i.getValue().toLowerCase().contains(mustContain)) continue;
                itr.remove();
            }
        }
    }

    private void removeSpuriousCPE(Dependency dependency) {
        ArrayList<Identifier> ids = new ArrayList<Identifier>(dependency.getIdentifiers());
        Collections.sort(ids);
        ListIterator mainItr = ids.listIterator();
        while (mainItr.hasNext()) {
            Identifier currentId = (Identifier)mainItr.next();
            VulnerableSoftware currentCpe = this.parseCpe(currentId.getType(), currentId.getValue());
            if (currentCpe == null) continue;
            ListIterator subItr = ids.listIterator(mainItr.nextIndex());
            while (subItr.hasNext()) {
                Identifier nextId = (Identifier)subItr.next();
                VulnerableSoftware nextCpe = this.parseCpe(nextId.getType(), nextId.getValue());
                if (nextCpe == null || !currentCpe.getVendor().equals(nextCpe.getVendor()) || !currentCpe.getProduct().equals(nextCpe.getProduct())) continue;
                String currentVersion = currentCpe.getVersion();
                String nextVersion = nextCpe.getVersion();
                if (currentVersion == null && nextVersion == null) {
                    LOGGER.debug("currentVersion and nextVersion are both null?");
                    continue;
                }
                if (currentVersion == null && nextVersion != null) {
                    dependency.getIdentifiers().remove(currentId);
                    continue;
                }
                if (nextVersion == null && currentVersion != null) {
                    dependency.getIdentifiers().remove(nextId);
                    continue;
                }
                if (currentVersion.length() < nextVersion.length()) {
                    if (!nextVersion.startsWith(currentVersion) && !"-".equals(currentVersion)) continue;
                    dependency.getIdentifiers().remove(currentId);
                    continue;
                }
                if (!currentVersion.startsWith(nextVersion) && !"-".equals(nextVersion)) continue;
                dependency.getIdentifiers().remove(nextId);
            }
        }
    }

    private void removeJreEntries(Dependency dependency) {
        Set<Identifier> identifiers = dependency.getIdentifiers();
        Iterator<Identifier> itr = identifiers.iterator();
        while (itr.hasNext()) {
            Identifier i = itr.next();
            Matcher coreCPE = CORE_JAVA.matcher(i.getValue());
            Matcher coreFiles = CORE_FILES.matcher(dependency.getFileName());
            if (coreCPE.matches() && !coreFiles.matches()) {
                itr.remove();
            }
            Matcher coreJsfCPE = CORE_JAVA_JSF.matcher(i.getValue());
            Matcher coreJsfFiles = CORE_JSF_FILES.matcher(dependency.getFileName());
            if (!coreJsfCPE.matches() || coreJsfFiles.matches()) continue;
            itr.remove();
        }
    }

    private VulnerableSoftware parseCpe(String type, String value) {
        if (!"cpe".equals(type)) {
            return null;
        }
        VulnerableSoftware cpe = new VulnerableSoftware();
        try {
            cpe.parseName(value);
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.trace("", (Throwable)ex);
            return null;
        }
        return cpe;
    }

    private void removeBadMatches(Dependency dependency) {
        Set<Identifier> identifiers = dependency.getIdentifiers();
        Iterator<Identifier> itr = identifiers.iterator();
        while (itr.hasNext()) {
            Identifier i = itr.next();
            if (!"cpe".equals(i.getType())) continue;
            if ((i.getValue().matches(".*c\\+\\+.*") || i.getValue().startsWith("cpe:/a:file:file") || i.getValue().startsWith("cpe:/a:mozilla:mozilla") || i.getValue().startsWith("cpe:/a:cvs:cvs") || i.getValue().startsWith("cpe:/a:ftp:ftp") || i.getValue().startsWith("cpe:/a:tcp:tcp") || i.getValue().startsWith("cpe:/a:ssh:ssh") || i.getValue().startsWith("cpe:/a:lookup:lookup")) && (dependency.getFileName().toLowerCase().endsWith(".jar") || dependency.getFileName().toLowerCase().endsWith("pom.xml") || dependency.getFileName().toLowerCase().endsWith(".dll") || dependency.getFileName().toLowerCase().endsWith(".exe") || dependency.getFileName().toLowerCase().endsWith(".nuspec") || dependency.getFileName().toLowerCase().endsWith(".zip") || dependency.getFileName().toLowerCase().endsWith(".sar") || dependency.getFileName().toLowerCase().endsWith(".apk") || dependency.getFileName().toLowerCase().endsWith(".tar") || dependency.getFileName().toLowerCase().endsWith(".gz") || dependency.getFileName().toLowerCase().endsWith(".tgz") || dependency.getFileName().toLowerCase().endsWith(".ear") || dependency.getFileName().toLowerCase().endsWith(".war"))) {
                itr.remove();
                continue;
            }
            if ((i.getValue().startsWith("cpe:/a:jquery:jquery") || i.getValue().startsWith("cpe:/a:prototypejs:prototype") || i.getValue().startsWith("cpe:/a:yahoo:yui")) && (dependency.getFileName().toLowerCase().endsWith(".jar") || dependency.getFileName().toLowerCase().endsWith("pom.xml") || dependency.getFileName().toLowerCase().endsWith(".dll") || dependency.getFileName().toLowerCase().endsWith(".exe"))) {
                itr.remove();
                continue;
            }
            if ((i.getValue().startsWith("cpe:/a:microsoft:excel") || i.getValue().startsWith("cpe:/a:microsoft:word") || i.getValue().startsWith("cpe:/a:microsoft:visio") || i.getValue().startsWith("cpe:/a:microsoft:powerpoint") || i.getValue().startsWith("cpe:/a:microsoft:office") || i.getValue().startsWith("cpe:/a:core_ftp:core_ftp")) && (dependency.getFileName().toLowerCase().endsWith(".jar") || dependency.getFileName().toLowerCase().endsWith(".ear") || dependency.getFileName().toLowerCase().endsWith(".war") || dependency.getFileName().toLowerCase().endsWith("pom.xml"))) {
                itr.remove();
                continue;
            }
            if (i.getValue().startsWith("cpe:/a:apache:maven") && !dependency.getFileName().toLowerCase().matches("maven-core-[\\d\\.]+\\.jar")) {
                itr.remove();
                continue;
            }
            if (i.getValue().startsWith("cpe:/a:m-core:m-core") && !dependency.getEvidenceUsed().containsUsedString("m-core")) {
                itr.remove();
                continue;
            }
            if (!i.getValue().startsWith("cpe:/a:jboss:jboss") || dependency.getFileName().toLowerCase().matches("jboss-?[\\d\\.-]+(GA)?\\.jar")) continue;
            itr.remove();
        }
    }

    private void removeWrongVersionMatches(Dependency dependency) {
        block3: {
            String fileName;
            Iterator<Identifier> itr;
            block2: {
                Set<Identifier> identifiers = dependency.getIdentifiers();
                itr = identifiers.iterator();
                fileName = dependency.getFileName();
                if (fileName == null || !fileName.contains("axis2")) break block2;
                while (itr.hasNext()) {
                    String cpe;
                    Identifier i = itr.next();
                    if (!"cpe".equals(i.getType()) || (cpe = i.getValue()) == null || !cpe.startsWith("cpe:/a:apache:axis:") && !"cpe:/a:apache:axis".equals(cpe)) continue;
                    itr.remove();
                }
                break block3;
            }
            if (fileName == null || !fileName.contains("axis")) break block3;
            while (itr.hasNext()) {
                String cpe;
                Identifier i = itr.next();
                if (!"cpe".equals(i.getType()) || (cpe = i.getValue()) == null || !cpe.startsWith("cpe:/a:apache:axis2:") && !"cpe:/a:apache:axis2".equals(cpe)) continue;
                itr.remove();
            }
        }
    }

    private void addFalseNegativeCPEs(Dependency dependency) {
        for (Identifier identifier : dependency.getIdentifiers()) {
            if (!"cpe".equals(identifier.getType()) || identifier.getValue() == null || !identifier.getValue().startsWith("cpe:/a:oracle:opensso:") && !identifier.getValue().startsWith("cpe:/a:oracle:opensso_enterprise:") && !identifier.getValue().startsWith("cpe:/a:sun:opensso_enterprise:") && !identifier.getValue().startsWith("cpe:/a:sun:opensso:")) continue;
            String newCpe = String.format("cpe:/a:sun:opensso_enterprise:%s", identifier.getValue().substring(22));
            String newCpe2 = String.format("cpe:/a:oracle:opensso_enterprise:%s", identifier.getValue().substring(22));
            String newCpe3 = String.format("cpe:/a:sun:opensso:%s", identifier.getValue().substring(22));
            String newCpe4 = String.format("cpe:/a:oracle:opensso:%s", identifier.getValue().substring(22));
            try {
                dependency.addIdentifier("cpe", newCpe, String.format("https://web.nvd.nist.gov/view/vuln/search-results?adv_search=true&cves=on&cpe_version=%s", URLEncoder.encode(newCpe, "UTF-8")));
                dependency.addIdentifier("cpe", newCpe2, String.format("https://web.nvd.nist.gov/view/vuln/search-results?adv_search=true&cves=on&cpe_version=%s", URLEncoder.encode(newCpe2, "UTF-8")));
                dependency.addIdentifier("cpe", newCpe3, String.format("https://web.nvd.nist.gov/view/vuln/search-results?adv_search=true&cves=on&cpe_version=%s", URLEncoder.encode(newCpe3, "UTF-8")));
                dependency.addIdentifier("cpe", newCpe4, String.format("https://web.nvd.nist.gov/view/vuln/search-results?adv_search=true&cves=on&cpe_version=%s", URLEncoder.encode(newCpe4, "UTF-8")));
            }
            catch (UnsupportedEncodingException ex) {
                LOGGER.debug("", (Throwable)ex);
            }
        }
    }

    private synchronized void removeDuplicativeEntriesFromJar(Dependency dependency, Engine engine) {
        List<Dependency> dependencies;
        Dependency parent;
        String parentPath;
        if ((dependency.getFileName().toLowerCase().endsWith("pom.xml") || DLL_EXE_FILTER.accept(dependency.getActualFile())) && (parentPath = dependency.getFilePath().toLowerCase()).contains(".jar") && (parent = this.findDependency(parentPath = parentPath.substring(0, parentPath.indexOf(".jar") + 4), dependencies = engine.getDependencies())) != null) {
            boolean remove = false;
            for (Identifier i : dependency.getIdentifiers()) {
                if ("cpe".equals(i.getType())) {
                    String trimmedCPE = this.trimCpeToVendor(i.getValue());
                    for (Identifier parentId : parent.getIdentifiers()) {
                        if (!"cpe".equals(parentId.getType()) || !parentId.getValue().startsWith(trimmedCPE)) continue;
                        remove |= true;
                    }
                }
                if (remove) continue;
                return;
            }
            if (remove) {
                dependencies.remove(dependency);
            }
        }
    }

    private Dependency findDependency(String dependencyPath, List<Dependency> dependencies) {
        for (Dependency d : dependencies) {
            if (!d.getFilePath().equalsIgnoreCase(dependencyPath)) continue;
            return d;
        }
        return null;
    }

    private String trimCpeToVendor(String value) {
        int pos1 = value.indexOf(58, 7);
        int pos2 = value.indexOf(58, pos1 + 1);
        if (pos2 < 0) {
            return value;
        }
        return value.substring(0, pos2);
    }
}

