/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.suppression;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.exception.ParseException;
import org.owasp.dependencycheck.utils.DateUtil;
import org.owasp.dependencycheck.xml.suppression.PropertyType;
import org.owasp.dependencycheck.xml.suppression.SuppressionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@NotThreadSafe
public class SuppressionHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuppressionHandler.class);
    public static final String SUPPRESSION_GROUP = "suppressionGroup";
    public static final String SUPPRESS = "suppress";
    public static final String FILE_PATH = "filePath";
    public static final String SHA1 = "sha1";
    public static final String CVE = "cve";
    public static final String VULNERABILITY_NAME = "vulnerabilityName";
    public static final String NOTES = "notes";
    public static final String CPE = "cpe";
    public static final String CWE = "cwe";
    public static final String GAV = "gav";
    public static final String PACKAGE_URL = "packageUrl";
    public static final String CVSS_BELOW = "cvssBelow";
    public static final String CVSS_V2_BELOW = "cvssV2Below";
    public static final String CVSS_V3_BELOW = "cvssV3Below";
    public static final String CVSS_V4_BELOW = "cvssV4Below";
    private final List<SuppressionRule> suppressionRules = new ArrayList<SuppressionRule>();
    private SuppressionRule rule;
    private Attributes currentAttributes;
    private StringBuilder currentText;
    private Boolean groupBase = null;
    private Calendar groupUntil = null;

    public List<SuppressionRule> getSuppressionRules() {
        return this.suppressionRules;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentAttributes = attributes;
        this.currentText = new StringBuilder();
        if (SUPPRESSION_GROUP.equals(qName)) {
            this.groupBase = attributes.getValue("base") != null ? Boolean.valueOf(Boolean.parseBoolean(attributes.getValue("base"))) : null;
            this.groupUntil = SuppressionHandler.parseUntilAttribute(attributes).orElse(null);
        }
        if (SUPPRESS.equals(qName)) {
            Boolean base = attributes.getValue("base") != null ? Boolean.valueOf(Boolean.parseBoolean(attributes.getValue("base"))) : null;
            Calendar until = SuppressionHandler.parseUntilAttribute(attributes).orElse(null);
            this.rule = new SuppressionRule();
            this.rule.setBase(base != null ? base : this.groupBase);
            this.rule.setUntil(until != null ? until : this.groupUntil);
        }
    }

    private static Optional<Calendar> parseUntilAttribute(Attributes attributes) throws SAXException {
        String untilStr = attributes.getValue("until");
        if (untilStr != null) {
            try {
                return Optional.of(DateUtil.parseXmlDate(untilStr));
            }
            catch (ParseException ex) {
                throw new SAXException("Unable to parse attribute 'until': " + untilStr, ex);
            }
        }
        return Optional.empty();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (null != qName) {
            switch (qName) {
                case "suppress": {
                    if (this.rule.getUntil() != null && this.rule.getUntil().before(Calendar.getInstance())) {
                        LOGGER.info("Suppression is expired for rule: {}", (Object)this.rule);
                    } else {
                        this.suppressionRules.add(this.rule);
                    }
                    this.rule = null;
                    break;
                }
                case "suppressionGroup": {
                    this.groupBase = null;
                    this.groupUntil = null;
                    break;
                }
                case "filePath": {
                    this.rule.setFilePath(this.processPropertyType());
                    break;
                }
                case "sha1": {
                    this.rule.setSha1(this.currentText.toString().trim());
                    break;
                }
                case "gav": {
                    this.rule.setGav(this.processPropertyType());
                    break;
                }
                case "packageUrl": {
                    this.rule.setPackageUrl(this.processPropertyType());
                    break;
                }
                case "cpe": {
                    this.rule.addCpe(this.processPropertyType());
                    break;
                }
                case "cwe": {
                    this.rule.addCwe(this.currentText.toString().trim());
                    break;
                }
                case "cve": {
                    this.rule.addCve(this.currentText.toString().trim());
                    break;
                }
                case "vulnerabilityName": {
                    this.rule.addVulnerabilityName(this.processPropertyType());
                    break;
                }
                case "notes": {
                    if (this.rule == null) break;
                    this.rule.setNotes(this.currentText.toString().trim());
                    break;
                }
                case "cvssBelow": {
                    Double cvss = Double.valueOf(this.currentText.toString().trim());
                    this.rule.addCvssBelow(cvss);
                    break;
                }
                case "cvssV2Below": {
                    Double cvssV2 = Double.valueOf(this.currentText.toString().trim());
                    this.rule.addCvssV2Below(cvssV2);
                    break;
                }
                case "cvssV3Below": {
                    Double cvssV3 = Double.valueOf(this.currentText.toString().trim());
                    this.rule.addCvssV3Below(cvssV3);
                    break;
                }
                case "cvssV4Below": {
                    Double cvssV4 = Double.valueOf(this.currentText.toString().trim());
                    this.rule.addCvssV4Below(cvssV4);
                    break;
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentText.append(ch, start, length);
    }

    private PropertyType processPropertyType() {
        PropertyType pt = new PropertyType();
        pt.setValue(this.currentText.toString().trim());
        if (this.currentAttributes != null && this.currentAttributes.getLength() > 0) {
            String caseSensitive;
            String regex = this.currentAttributes.getValue("regex");
            if (regex != null) {
                pt.setRegex(Boolean.parseBoolean(regex));
            }
            if ((caseSensitive = this.currentAttributes.getValue("caseSensitive")) != null) {
                pt.setCaseSensitive(Boolean.parseBoolean(caseSensitive));
            }
        }
        return pt;
    }
}

