/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractNpmAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.SearchException;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.data.nodeaudit.Advisory;
import org.owasp.dependencycheck.data.nodeaudit.NpmAuditParser;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.processing.ProcessReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.exceptions.CpeValidationException;

@ThreadSafe
public class PnpmAuditAnalyzer
extends AbstractNpmAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PnpmAuditAnalyzer.class);
    public static final String PNPM_PACKAGE_LOCK = "pnpm-lock.yaml";
    public static final String DEFAULT_REGISTRY = "https://registry.npmjs.org/";
    private static final FileFilter LOCK_FILE_FILTER = FileFilterBuilder.newInstance().addFilenames("pnpm-lock.yaml").build();
    private String pnpmPath;

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        File packageLock;
        if (dependency.getDisplayFileName().equals(dependency.getFileName())) {
            engine.removeDependency(dependency);
        }
        if (!(packageLock = dependency.getActualFile()).isFile() || packageLock.length() == 0L || !PnpmAuditAnalyzer.shouldProcess(packageLock)) {
            return;
        }
        HashSetValuedHashMap dependencyMap = new HashSetValuedHashMap();
        List<Advisory> advisories = this.analyzePackage(packageLock, dependency);
        try {
            this.processResults(advisories, engine, dependency, (MultiValuedMap<String, String>)dependencyMap);
        }
        catch (CpeValidationException ex) {
            throw new UnexpectedAnalysisException(ex);
        }
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.pnpm.audit.enabled";
    }

    @Override
    protected FileFilter getFileFilter() {
        return LOCK_FILE_FILTER;
    }

    @Override
    public String getName() {
        return "Pnpm Audit Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINDING_ANALYSIS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        super.prepareFileTypeAnalyzer(engine);
        if (!this.isEnabled()) {
            LOGGER.debug("{} Analyzer is disabled skipping pnpm executable check", (Object)this.getName());
            return;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getPnpm());
        args.add("--help");
        ProcessBuilder builder = new ProcessBuilder(args);
        LOGGER.debug("Launching: {}", args);
        try {
            Process process = builder.start();
            try (ProcessReader processReader = new ProcessReader(process);){
                processReader.readAll();
                int exitValue = process.waitFor();
                boolean expectedExitValue = false;
                int executableNotFoundExitValue = 127;
                switch (exitValue) {
                    case 0: {
                        LOGGER.debug("{} is enabled.", (Object)this.getName());
                        return;
                    }
                    default: {
                        this.setEnabled(false);
                        LOGGER.warn("The {} has been disabled. Pnpm executable was not found.", (Object)this.getName());
                        return;
                    }
                }
            }
        }
        catch (Exception ex) {
            this.setEnabled(false);
            LOGGER.warn("The {} has been disabled. Pnpm executable was not found.", (Object)this.getName());
            throw new InitializationException("Unable to read pnpm audit output.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPnpm() {
        String value;
        PnpmAuditAnalyzer pnpmAuditAnalyzer = this;
        synchronized (pnpmAuditAnalyzer) {
            if (this.pnpmPath == null) {
                String path = this.getSettings().getString("analyzer.pnpm.path");
                if (path == null) {
                    this.pnpmPath = "pnpm";
                } else {
                    File pnpmFile = new File(path);
                    if (pnpmFile.isFile()) {
                        this.pnpmPath = pnpmFile.getAbsolutePath();
                    } else {
                        LOGGER.warn("Provided path to `pnpm` executable is invalid.");
                        this.pnpmPath = "pnpm";
                    }
                }
            }
            value = this.pnpmPath;
        }
        return value;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private JSONObject fetchPnpmAuditJson(Dependency dependency, boolean skipDevDependencies) throws AnalysisException {
        File folder = dependency.getActualFile().getParentFile();
        if (!folder.isDirectory()) {
            throw new AnalysisException(String.format("%s should have been a directory.", folder.getAbsolutePath()));
        }
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.getPnpm());
            args.add("audit");
            if (skipDevDependencies) {
                args.add("--prod");
            }
            args.add("--json");
            args.add("--registry");
            args.add(this.getSettings().getString("analyzer.pnpm.audit.registry", DEFAULT_REGISTRY));
            ProcessBuilder builder = new ProcessBuilder(args);
            builder.directory(folder);
            File tmpFile = File.createTempFile("pnpm_audit", null);
            builder.redirectOutput(tmpFile);
            LOGGER.debug("Launching: {}", args);
            Process process = builder.start();
            try {
                JSONObject jSONObject;
                ProcessReader processReader = new ProcessReader(process);
                try {
                    String verboseJson;
                    processReader.readAll();
                    String errOutput = processReader.getError();
                    if (!StringUtils.isBlank((CharSequence)errOutput)) {
                        LOGGER.error("Process error output: {}", (Object)errOutput);
                    }
                    if ((verboseJson = new String(Files.readAllBytes(tmpFile.toPath()), StandardCharsets.UTF_8)).contains("EACCES: permission denied, open 'node_modules/.pnpm-debug.log'")) {
                        verboseJson = verboseJson.substring(0, verboseJson.indexOf("EACCES: permission denied, open 'node_modules/.pnpm-debug.log'"));
                    }
                    LOGGER.debug("Audit report: {}", (Object)verboseJson);
                    jSONObject = new JSONObject(verboseJson);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            processReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new AnalysisException("Pnpm audit process was interrupted.", ex);
                    }
                    catch (JSONException e) {
                        Thread.currentThread().interrupt();
                        throw new AnalysisException("Pnpm audit returned an invalid response.", e);
                    }
                }
                processReader.close();
                return jSONObject;
            }
            finally {
                if (!tmpFile.delete()) {
                    LOGGER.debug("Unable to delete temp file: {}", (Object)tmpFile);
                }
            }
        }
        catch (IOException ioe) {
            throw new AnalysisException("pnpm audit failure; this error can be ignored if you are not analyzing projects with a pnpm lockfile.", ioe);
        }
    }

    private List<Advisory> analyzePackage(File lockFile, Dependency dependency) throws AnalysisException {
        try {
            boolean skipDevDependencies = this.getSettings().getBoolean("analyzer.node.audit.skipdev", false);
            JSONObject auditJson = this.fetchPnpmAuditJson(dependency, skipDevDependencies);
            return this.getAuditParser().parse(auditJson);
        }
        catch (JSONException e) {
            throw new AnalysisException(String.format("Failed to parse %s file from the NPM Audit API (PnpmAuditAnalyzer).", lockFile.getPath()), e);
        }
        catch (SearchException ex) {
            LOGGER.error("PnpmAuditAnalyzer failed on {}", (Object)dependency.getActualFilePath());
            throw ex;
        }
    }

    @NotNull
    private NpmAuditParser getAuditParser() {
        return new NpmAuditParser();
    }
}

