/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.elixir;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.stream.JsonParsingException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.elixir.MixAuditResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MixAuditJsonParser {
    static final String PASS_FAIL_KEY = "pass";
    static final String RESULTS_KEY = "vulnerabilities";
    static final String ADVISORY_KEY = "advisory";
    static final String DEPENDENCY_KEY = "dependency";
    private final JsonReader jsonReader;
    private final List<MixAuditResult> mixAuditResults;
    private boolean mixAuditPass;
    private static final Logger LOGGER = LoggerFactory.getLogger(MixAuditJsonParser.class);

    public MixAuditJsonParser(Reader reader) {
        LOGGER.debug("Creating a MixAuditJsonParser");
        this.jsonReader = Json.createReader((Reader)reader);
        this.mixAuditResults = new ArrayList<MixAuditResult>();
        this.mixAuditPass = false;
    }

    public void process() throws AnalysisException {
        LOGGER.debug("Beginning mix_audit json output processing");
        try {
            JsonObject output = this.jsonReader.readObject();
            if (output.containsKey((Object)PASS_FAIL_KEY)) {
                this.mixAuditPass = output.getBoolean(PASS_FAIL_KEY);
            }
            if (output.containsKey((Object)RESULTS_KEY) && output.isNull(RESULTS_KEY)) {
                LOGGER.debug("Found vulnerabilities");
            }
            JsonArray results = output.getJsonArray(RESULTS_KEY);
            for (JsonObject result : results.getValuesAs(JsonObject.class)) {
                JsonObject advisory = result.getJsonObject(ADVISORY_KEY);
                JsonObject dependency = result.getJsonObject(DEPENDENCY_KEY);
                ArrayList<String> patchedVersions = new ArrayList<String>();
                for (JsonString patchedVersion : advisory.getJsonArray("patched_versions").getValuesAs(JsonString.class)) {
                    patchedVersions.add(patchedVersion.getString());
                }
                MixAuditResult r = new MixAuditResult(advisory.getString("id"), advisory.getString("cve"), advisory.getString("title"), advisory.getString("description"), advisory.getString("disclosure_date"), advisory.getString("url"), patchedVersions, dependency.getString("lockfile"), dependency.getString("package"), dependency.getString("version"));
                this.mixAuditResults.add(r);
            }
        }
        catch (JsonParsingException jsonpe) {
            throw new AnalysisException("Error parsing stream", jsonpe);
        }
        catch (JsonException jsone) {
            throw new AnalysisException("Error reading stream", jsone);
        }
        catch (IllegalStateException ise) {
            throw new AnalysisException("Illegal state while parsing mix_audit output", ise);
        }
        catch (ClassCastException cce) {
            throw new AnalysisException("JSON not exactly matching output of `mix_audit --format json`", cce);
        }
    }

    public List<MixAuditResult> getResults() {
        return this.mixAuditResults;
    }
}

