/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.DependencyBundlingAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.data.nodeaudit.Advisory;
import org.owasp.dependencycheck.data.nodeaudit.NodeAuditSearch;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.dependency.VulnerableSoftwareBuilder;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.semver4j.Semver;
import org.semver4j.SemverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.values.Part;

@ThreadSafe
public abstract class AbstractNpmAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNpmAnalyzer.class);
    public static final String NPM_DEPENDENCY_ECOSYSTEM = "nodejs";
    private static final String PACKAGE_JSON = "package.json";
    private NodeAuditSearch searcher;

    @Override
    public boolean accept(File pathname) {
        boolean accept = super.accept(pathname);
        if (accept) {
            try {
                accept = AbstractNpmAnalyzer.shouldProcess(pathname);
            }
            catch (AnalysisException ex) {
                throw new UnexpectedAnalysisException(ex.getMessage(), ex.getCause());
            }
        }
        return accept;
    }

    public static boolean shouldProcess(File pathname) throws AnalysisException {
        try {
            String canonicalPath = pathname.getCanonicalPath();
            if (canonicalPath.contains(File.separator + "node_modules" + File.separator) || canonicalPath.contains(File.separator + "bower_components" + File.separator)) {
                LOGGER.debug("Skipping analysis of node/bower module: {}", (Object)canonicalPath);
                return false;
            }
        }
        catch (IOException ex) {
            throw new AnalysisException("Unable to process dependency", ex);
        }
        return true;
    }

    protected Dependency createDependency(Dependency dependency, String name, String version, String scope) {
        Identifier id;
        Dependency nodeModule = new Dependency(new File(String.valueOf(dependency.getActualFile()) + "?" + name), true);
        nodeModule.setEcosystem(NPM_DEPENDENCY_ECOSYSTEM);
        nodeModule.setSha1sum(Checksum.getSHA1Checksum((String)String.format("%s:%s", name, version)));
        nodeModule.setSha256sum(Checksum.getSHA256Checksum((String)String.format("%s:%s", name, version)));
        nodeModule.setMd5sum(Checksum.getMD5Checksum((String)String.format("%s:%s", name, version)));
        nodeModule.addEvidence(EvidenceType.PRODUCT, PACKAGE_JSON, "name", name, Confidence.HIGHEST);
        nodeModule.addEvidence(EvidenceType.VENDOR, PACKAGE_JSON, "name", name, Confidence.HIGH);
        if (!StringUtils.isBlank((CharSequence)version)) {
            nodeModule.addEvidence(EvidenceType.VERSION, PACKAGE_JSON, "version", version, Confidence.HIGHEST);
            nodeModule.setVersion(version);
        }
        if (dependency.getName() != null) {
            nodeModule.addProjectReference(dependency.getName() + ": " + scope);
        } else {
            nodeModule.addProjectReference(dependency.getDisplayFileName() + ": " + scope);
        }
        nodeModule.setName(name);
        try {
            PackageURL purl = PackageURLBuilder.aPackageURL().withType("npm").withName(name).withVersion(version).build();
            id = new PurlIdentifier(purl, Confidence.HIGHEST);
        }
        catch (MalformedPackageURLException ex) {
            LOGGER.debug("Unable to generate Purl - using a generic identifier instead " + ex.getMessage());
            id = new GenericIdentifier(String.format("npm:%s@%s", dependency.getName(), version), Confidence.HIGHEST);
        }
        nodeModule.addSoftwareIdentifier(id);
        return nodeModule;
    }

    protected void processPackage(Engine engine, Dependency dependency, JsonArray jsonArray, String depType) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        jsonArray.getValuesAs(JsonString.class).forEach(str -> builder.add(str.toString(), ""));
        JsonObject jsonObject = builder.build();
        this.processPackage(engine, dependency, jsonObject, depType);
    }

    protected void processPackage(Engine engine, Dependency dependency, JsonObject jsonObject, String depType) {
        for (int i = 0; i < jsonObject.size(); ++i) {
            jsonObject.forEach((name, value) -> {
                Dependency existing;
                String version = "";
                if (value != null && value.getValueType() == JsonValue.ValueType.STRING) {
                    version = ((JsonString)value).getString();
                }
                if ((existing = this.findDependency(engine, (String)name, version)) == null) {
                    Dependency nodeModule = this.createDependency(dependency, (String)name, version, depType);
                    engine.addDependency(nodeModule);
                } else {
                    existing.addProjectReference(dependency.getName() + ": " + depType);
                }
            });
        }
    }

    private static String addToEvidence(Dependency dep, EvidenceType t, JsonObject json, String key) {
        String evidenceStr = null;
        if (json.containsKey((Object)key)) {
            JsonValue value = (JsonValue)json.get((Object)key);
            if (value instanceof JsonString) {
                evidenceStr = ((JsonString)value).getString();
                dep.addEvidence(t, PACKAGE_JSON, key, evidenceStr, Confidence.HIGHEST);
            } else if (value instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)value;
                for (Map.Entry entry2 : jsonObject.entrySet()) {
                    String property = (String)entry2.getKey();
                    JsonValue subValue = (JsonValue)entry2.getValue();
                    if (subValue instanceof JsonString) {
                        evidenceStr = ((JsonString)subValue).getString();
                        dep.addEvidence(t, PACKAGE_JSON, String.format("%s.%s", key, property), evidenceStr, Confidence.HIGHEST);
                        continue;
                    }
                    LOGGER.warn("JSON sub-value not string as expected: {}", (Object)subValue);
                }
            } else if (value instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)value;
                jsonArray.forEach(entry -> {
                    if (entry instanceof JsonObject) {
                        ((JsonObject)entry).keySet().forEach(item -> {
                            JsonValue v = (JsonValue)((JsonObject)entry).get(item);
                            if (v instanceof JsonString) {
                                String eStr = ((JsonString)v).getString();
                                dep.addEvidence(t, PACKAGE_JSON, String.format("%s.%s", key, item), eStr, Confidence.HIGHEST);
                            }
                        });
                    }
                });
            } else {
                LOGGER.warn("JSON value not string or JSON object as expected: {}", (Object)value);
            }
        }
        return evidenceStr;
    }

    protected Dependency findDependency(Engine engine, String name, String version) {
        for (Dependency d : engine.getDependencies()) {
            String dependencyVersion;
            if (!NPM_DEPENDENCY_ECOSYSTEM.equals(d.getEcosystem()) || !name.equals(d.getName()) || version == null || d.getVersion() == null || !DependencyBundlingAnalyzer.npmVersionsMatch(version, dependencyVersion = d.getVersion())) continue;
            return d;
        }
        return null;
    }

    public void gatherEvidence(JsonObject json, Dependency dependency) {
        String displayName = null;
        if (json.containsKey((Object)"name")) {
            Object value = json.get((Object)"name");
            if (value instanceof JsonString) {
                String valueString;
                displayName = valueString = ((JsonString)value).getString();
                dependency.setName(valueString);
                dependency.setPackagePath(valueString);
                dependency.addEvidence(EvidenceType.PRODUCT, PACKAGE_JSON, "name", valueString, Confidence.HIGHEST);
                dependency.addEvidence(EvidenceType.VENDOR, PACKAGE_JSON, "name", valueString, Confidence.HIGHEST);
                dependency.addEvidence(EvidenceType.VENDOR, PACKAGE_JSON, "name", valueString + "_project", Confidence.HIGHEST);
            } else {
                LOGGER.warn("JSON value not string as expected: {}", value);
            }
        }
        String desc = AbstractNpmAnalyzer.addToEvidence(dependency, EvidenceType.VENDOR, json, "description");
        dependency.setDescription(desc);
        String vendor = AbstractNpmAnalyzer.addToEvidence(dependency, EvidenceType.VENDOR, json, "author");
        if (vendor == null) {
            vendor = AbstractNpmAnalyzer.addToEvidence(dependency, EvidenceType.VENDOR, json, "maintainers");
        } else {
            AbstractNpmAnalyzer.addToEvidence(dependency, EvidenceType.VENDOR, json, "maintainers");
        }
        AbstractNpmAnalyzer.addToEvidence(dependency, EvidenceType.VENDOR, json, "homepage");
        AbstractNpmAnalyzer.addToEvidence(dependency, EvidenceType.VENDOR, json, "bugs");
        String version = AbstractNpmAnalyzer.addToEvidence(dependency, EvidenceType.VERSION, json, "version");
        if (version != null) {
            Identifier id;
            displayName = String.format("%s:%s", displayName, version);
            dependency.setVersion(version);
            dependency.setPackagePath(displayName);
            try {
                PackageURL purl = PackageURLBuilder.aPackageURL().withType("npm").withName(dependency.getName()).withVersion(version).build();
                id = new PurlIdentifier(purl, Confidence.HIGHEST);
            }
            catch (MalformedPackageURLException ex) {
                LOGGER.debug("Unable to generate Purl - using a generic identifier instead " + ex.getMessage());
                id = new GenericIdentifier(String.format("npm:%s:%s", dependency.getName(), version), Confidence.HIGHEST);
            }
            dependency.addSoftwareIdentifier(id);
        }
        if (displayName != null) {
            dependency.setDisplayFileName(displayName);
            dependency.setPackagePath(displayName);
        } else {
            LOGGER.warn("Unable to determine package name or version for {}", (Object)dependency.getActualFilePath());
            if (vendor != null && !vendor.isEmpty()) {
                dependency.setDisplayFileName(String.format("%s package.json", vendor));
            }
        }
        if (json.containsKey((Object)"license")) {
            JsonObject object;
            Object value = json.get((Object)"license");
            if (value instanceof JsonString) {
                dependency.setLicense(json.getString("license"));
            } else if (value instanceof JsonArray) {
                JsonArray array = (JsonArray)value;
                StringBuilder sb = new StringBuilder();
                boolean addComma = false;
                for (int x = 0; x < array.size(); ++x) {
                    if (array.isNull(x)) continue;
                    if (addComma) {
                        sb.append(", ");
                    } else {
                        addComma = true;
                    }
                    if (JsonValue.ValueType.STRING == ((JsonValue)array.get(x)).getValueType()) {
                        sb.append(array.getString(x));
                        continue;
                    }
                    JsonObject lo = array.getJsonObject(x);
                    if (lo.containsKey((Object)"type") && !lo.isNull("type") && lo.containsKey((Object)"url") && !lo.isNull("url")) {
                        String license = String.format("%s (%s)", lo.getString("type"), lo.getString("url"));
                        sb.append(license);
                        continue;
                    }
                    if (lo.containsKey((Object)"type") && !lo.isNull("type")) {
                        sb.append(lo.getString("type"));
                        continue;
                    }
                    if (!lo.containsKey((Object)"url") || lo.isNull("url")) continue;
                    sb.append(lo.getString("url"));
                }
                dependency.setLicense(sb.toString());
            } else if (value instanceof JsonObject && (object = (JsonObject)value).containsKey((Object)"type") && !object.isNull("type")) {
                dependency.setLicense(object.getString("type"));
            }
        }
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        if (!this.isEnabled() || !this.getFilesMatched()) {
            this.setEnabled(false);
            return;
        }
        if (this.searcher == null) {
            LOGGER.debug("Initializing {}", (Object)this.getName());
            try {
                this.searcher = new NodeAuditSearch(this.getSettings());
            }
            catch (MalformedURLException ex) {
                this.setEnabled(false);
                throw new InitializationException("The configured URL to NPM Audit API is malformed", ex);
            }
            try {
                Settings settings = engine.getSettings();
                boolean nodeEnabled = settings.getBoolean("analyzer.node.package.enabled");
                if (!nodeEnabled) {
                    LOGGER.warn("The Node Package Analyzer has been disabled; the resulting report will only contain the known vulnerable dependency - not a bill of materials for the node project.");
                }
            }
            catch (InvalidSettingException ex) {
                throw new InitializationException("Unable to read configuration settings", ex);
            }
        }
    }

    protected void processResults(List<Advisory> advisories, Engine engine, Dependency dependency, MultiValuedMap<String, String> dependencyMap) throws CpeValidationException {
        for (Advisory advisory : advisories) {
            Dependency existing;
            Vulnerability vuln = new Vulnerability();
            vuln.setDescription(advisory.getOverview());
            vuln.setName(String.valueOf(advisory.getGhsaId()));
            vuln.setUnscoredSeverity(advisory.getSeverity());
            vuln.setCvssV3(advisory.getCvssV3());
            vuln.setSource(Vulnerability.Source.NPM);
            for (String string : advisory.getCwes()) {
                vuln.addCwe(string);
            }
            if (advisory.getReferences() != null) {
                String[] references;
                for (String reference : references = advisory.getReferences().split("\\n")) {
                    if (reference.length() <= 3) continue;
                    String url = reference.substring(2);
                    try {
                        new URL(url);
                    }
                    catch (MalformedURLException ignored) {
                        url = null;
                    }
                    vuln.addReference("NPM Advisory reference: ", url == null ? reference : url, url);
                }
            }
            VulnerableSoftwareBuilder builder = new VulnerableSoftwareBuilder();
            builder.part(Part.APPLICATION).product(advisory.getModuleName().replace(" ", "_")).version(advisory.getVulnerableVersions().replace(" ", ""));
            VulnerableSoftware vulnerableSoftware = builder.build();
            vuln.addVulnerableSoftware(vulnerableSoftware);
            String version = advisory.getVersion();
            if (version == null && dependencyMap.containsKey((Object)advisory.getModuleName())) {
                version = AbstractNpmAnalyzer.determineVersionFromMap(advisory.getVulnerableVersions(), dependencyMap.get((Object)advisory.getModuleName()));
            }
            if ((existing = this.findDependency(engine, advisory.getModuleName(), version)) == null) {
                Dependency nodeModule = this.createDependency(dependency, advisory.getModuleName(), version, "transitive");
                nodeModule.addVulnerability(vuln);
                engine.addDependency(nodeModule);
                continue;
            }
            this.replaceOrAddVulnerability(existing, vuln);
        }
    }

    protected void replaceOrAddVulnerability(Dependency dependency, Vulnerability vuln) {
        boolean found;
        boolean bl = found = vuln.getSource() == Vulnerability.Source.NPM && dependency.getVulnerabilities().stream().anyMatch(existing -> existing.getReferences().stream().anyMatch(ref -> ref.getName() != null && ref.getName().equals("https://nodesecurity.io/advisories/" + vuln.getName())));
        if (!found) {
            dependency.addVulnerability(vuln);
        }
    }

    protected NodeAuditSearch getSearcher() {
        return this.searcher;
    }

    public static String determineVersionFromMap(String versionRange, Collection<String> availableVersions) {
        if (availableVersions.size() == 1) {
            return availableVersions.iterator().next();
        }
        for (String v : availableVersions) {
            try {
                Semver version = new Semver(v);
                if (!version.satisfies(versionRange)) continue;
                return v;
            }
            catch (SemverException ex) {
                LOGGER.debug("invalid semver: " + v);
            }
        }
        return availableVersions.iterator().next();
    }
}

