/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nexus;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nexus.NexusSearch;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NexusV3Search
implements NexusSearch {
    private final Set<String> acceptedClassifiers = new HashSet<String>();
    private final URL rootURL;
    private final boolean useProxy;
    private final Settings settings;
    private static final Logger LOGGER = LoggerFactory.getLogger(NexusV3Search.class);

    public NexusV3Search(Settings settings, boolean useProxy) throws MalformedURLException {
        this.settings = settings;
        this.useProxy = useProxy;
        this.acceptedClassifiers.add(null);
        String searchUrl = settings.getString("analyzer.nexus.url");
        LOGGER.debug("Nexus Search URL: {}", (Object)searchUrl);
        this.rootURL = new URL(searchUrl);
    }

    @Override
    public MavenArtifact searchSha1(String sha1) throws IOException {
        if (null == sha1 || !sha1.matches("^[0-9A-Fa-f]{40}$")) {
            throw new IllegalArgumentException("Invalid SHA1 format");
        }
        ArrayList<MavenArtifact> collectedMatchingArtifacts = new ArrayList<MavenArtifact>(1);
        String continuationToken = this.retrievePageAndAddMatchingArtifact(collectedMatchingArtifacts, sha1, null);
        while (continuationToken != null && collectedMatchingArtifacts.isEmpty()) {
            continuationToken = this.retrievePageAndAddMatchingArtifact(collectedMatchingArtifacts, sha1, continuationToken);
        }
        if (collectedMatchingArtifacts.isEmpty()) {
            throw new FileNotFoundException("Artifact not found in Nexus");
        }
        return (MavenArtifact)collectedMatchingArtifacts.get(0);
    }

    private String retrievePageAndAddMatchingArtifact(List<MavenArtifact> collectedMatchingArtifacts, String sha1, String continuationToken) throws IOException {
        LOGGER.debug("Search with continuation token {}", (Object)continuationToken);
        URL url = continuationToken == null ? new URL(this.rootURL, String.format("v1/search/?sha1=%s", sha1.toLowerCase())) : new URL(this.rootURL, String.format("v1/search/?sha1=%s&continuationToken=%s", sha1.toLowerCase(), continuationToken));
        LOGGER.debug("Searching Nexus url {}", (Object)url);
        URLConnectionFactory factory = new URLConnectionFactory(this.settings);
        HttpURLConnection conn = factory.createHttpURLConnection(url, this.useProxy);
        conn.setDoOutput(true);
        String authHeader = this.buildHttpAuthHeaderValue();
        if (!authHeader.isEmpty()) {
            conn.addRequestProperty("Authorization", authHeader);
        }
        conn.addRequestProperty("Accept", "application/json");
        conn.connect();
        if (conn.getResponseCode() != 200) {
            LOGGER.debug("Could not connect to Nexus received response code: {} {}", (Object)conn.getResponseCode(), (Object)conn.getResponseMessage());
            throw new IOException(String.format("Could not connect to Nexus, HTTP response code %d", conn.getResponseCode()));
        }
        String nextContinuationToken = this.parseResponse(conn, sha1, collectedMatchingArtifacts);
        return nextContinuationToken;
    }

    private String parseResponse(HttpURLConnection conn, String sha1, List<MavenArtifact> matchingArtifacts) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());){
            String string;
            block17: {
                JsonReader jsonReader = Json.createReader((InputStream)in);
                try {
                    JsonObject jsonResponse = jsonReader.readObject();
                    String continuationToken = jsonResponse.getString("continuationToken", null);
                    JsonArray components = jsonResponse.getJsonArray("items");
                    boolean found = false;
                    for (int i = 0; i < components.size() && !found; ++i) {
                        boolean jarFound = false;
                        boolean pomFound = false;
                        String downloadUrl = null;
                        String groupId = null;
                        String artifactId = null;
                        String version = null;
                        String pomUrl = null;
                        JsonObject component = components.getJsonObject(i);
                        String format = components.getJsonObject(0).getString("format", "unknown");
                        if (!"maven2".equals(format)) continue;
                        JsonArray assets = component.getJsonArray("assets");
                        for (int j = 0; !found && j < assets.size(); ++j) {
                            JsonObject asset = assets.getJsonObject(j);
                            JsonObject checksums = asset.getJsonObject("checksum");
                            JsonObject maven2 = asset.getJsonObject("maven2");
                            if (maven2 != null && "jar".equals(maven2.getString("extension", null)) && this.acceptedClassifiers.contains(maven2.getString("classifier", null)) && checksums != null && sha1.equals(checksums.getString("sha1", null))) {
                                downloadUrl = asset.getString("downloadUrl");
                                groupId = maven2.getString("groupId");
                                artifactId = maven2.getString("artifactId");
                                version = maven2.getString("version");
                                jarFound = true;
                            } else if (maven2 != null && "pom".equals(maven2.getString("extension"))) {
                                pomFound = true;
                                pomUrl = asset.getString("downloadUrl");
                            }
                            if (!pomFound || !jarFound) continue;
                            found = true;
                        }
                        if (found) {
                            matchingArtifacts.add(new MavenArtifact(groupId, artifactId, version, downloadUrl, pomUrl));
                            continue;
                        }
                        if (!jarFound) continue;
                        MavenArtifact ma = new MavenArtifact(groupId, artifactId, version, downloadUrl);
                        ma.setPomUrl(MavenArtifact.derivePomUrl(artifactId, version, downloadUrl));
                        matchingArtifacts.add(ma);
                        found = true;
                    }
                    string = continuationToken;
                    if (jsonReader == null) break block17;
                }
                catch (Throwable throwable) {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonReader.close();
            }
            return string;
        }
    }

    @Override
    public boolean preflightRequest() {
        try {
            URL url = new URL(this.rootURL, "v1/status");
            URLConnectionFactory factory = new URLConnectionFactory(this.settings);
            HttpURLConnection conn = factory.createHttpURLConnection(url, this.useProxy);
            conn.addRequestProperty("Accept", "application/json");
            String authHeader = this.buildHttpAuthHeaderValue();
            if (!authHeader.isEmpty()) {
                conn.addRequestProperty("Authorization", authHeader);
            }
            conn.connect();
            if (conn.getResponseCode() != 200) {
                LOGGER.warn("Expected 200 result from Nexus, got {}", (Object)conn.getResponseCode());
                return false;
            }
            if (conn.getContentLength() != 0) {
                LOGGER.warn("Expected empty OK response (content-length 0), got content-length {}", (Object)conn.getContentLength());
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Pre-flight request to Nexus failed: ", (Throwable)e);
            return false;
        }
        return true;
    }

    private String buildHttpAuthHeaderValue() {
        String user = this.settings.getString("analyzer.nexus.username", "");
        String pass = this.settings.getString("analyzer.nexus.password", "");
        Object result = "";
        if (user.isEmpty() || pass.isEmpty()) {
            LOGGER.debug("Skip authentication as user and/or password for nexus is empty");
        } else {
            String auth = user + ":" + pass;
            String base64Auth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
            result = "Basic " + base64Auth;
        }
        return result;
    }
}

