/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.suppression;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.owasp.dependencycheck.xml.suppression.SuppressionErrorHandler;
import org.owasp.dependencycheck.xml.suppression.SuppressionHandler;
import org.owasp.dependencycheck.xml.suppression.SuppressionParseException;
import org.owasp.dependencycheck.xml.suppression.SuppressionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SuppressionParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuppressionParser.class);
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String SUPPRESSION_SCHEMA = "schema/dependency-suppression.1.1.xsd";
    private static final String OLD_SUPPRESSION_SCHEMA = "schema/suppression.xsd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SuppressionRule> parseSuppressionRules(File file) throws SuppressionParseException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            List<SuppressionRule> list = this.parseSuppressionRules(fis);
            return list;
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new SuppressionParseException(ex);
        }
        catch (SAXException ex) {
            try {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ex1) {
                        LOGGER.debug("Unable to close stream", (Throwable)ex1);
                    }
                }
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException ex1) {
                throw new SuppressionParseException(ex);
            }
            List<SuppressionRule> list = this.parseOldSuppressionRules(fis);
            return list;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    LOGGER.debug("Unable to close stream", (Throwable)ex);
                }
            }
        }
    }

    public List<SuppressionRule> parseSuppressionRules(InputStream inputStream) throws SuppressionParseException, SAXException {
        InputStream schemaStream = null;
        try {
            schemaStream = this.getClass().getClassLoader().getResourceAsStream(SUPPRESSION_SCHEMA);
            SuppressionHandler handler = new SuppressionHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            saxParser.setProperty(JAXP_SCHEMA_SOURCE, new InputSource(schemaStream));
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setErrorHandler(new SuppressionErrorHandler());
            xmlReader.setContentHandler(handler);
            InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
            InputSource in = new InputSource(reader);
            xmlReader.parse(in);
            List<SuppressionRule> list = handler.getSuppressionRules();
            return list;
        }
        catch (ParserConfigurationException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new SuppressionParseException(ex);
        }
        catch (SAXException ex) {
            if (ex.getMessage().contains("Cannot find the declaration of element 'suppressions'.")) {
                throw ex;
            }
            LOGGER.debug("", (Throwable)ex);
            throw new SuppressionParseException(ex);
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new SuppressionParseException(ex);
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new SuppressionParseException(ex);
        }
        finally {
            if (schemaStream != null) {
                try {
                    schemaStream.close();
                }
                catch (IOException ex) {
                    LOGGER.debug("Error closing suppression file stream", (Throwable)ex);
                }
            }
        }
    }

    private List<SuppressionRule> parseOldSuppressionRules(InputStream inputStream) throws SuppressionParseException {
        InputStream schemaStream = null;
        try {
            schemaStream = this.getClass().getClassLoader().getResourceAsStream(OLD_SUPPRESSION_SCHEMA);
            SuppressionHandler handler = new SuppressionHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            saxParser.setProperty(JAXP_SCHEMA_SOURCE, new InputSource(schemaStream));
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setErrorHandler(new SuppressionErrorHandler());
            xmlReader.setContentHandler(handler);
            InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
            InputSource in = new InputSource(reader);
            xmlReader.parse(in);
            List<SuppressionRule> list = handler.getSuppressionRules();
            return list;
        }
        catch (ParserConfigurationException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new SuppressionParseException(ex);
        }
        catch (SAXException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new SuppressionParseException(ex);
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new SuppressionParseException(ex);
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new SuppressionParseException(ex);
        }
        finally {
            if (schemaStream != null) {
                try {
                    schemaStream.close();
                }
                catch (IOException ex) {
                    LOGGER.debug("Error closing old suppression file stream", (Throwable)ex);
                }
            }
        }
    }
}

