/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.net.MalformedURLException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.update.BaseUpdater;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.exception.InvalidDataException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.data.update.nvd.DownloadTask;
import org.owasp.dependencycheck.data.update.nvd.NvdCveInfo;
import org.owasp.dependencycheck.data.update.nvd.ProcessTask;
import org.owasp.dependencycheck.data.update.nvd.UpdateableNvdCve;
import org.owasp.dependencycheck.utils.DateUtil;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvdCveUpdater
extends BaseUpdater
implements CachedWebDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(NvdCveUpdater.class);
    public static final int MAX_THREAD_POOL_SIZE = Settings.getInt((String)"max.download.threads", (int)3);

    @Override
    public void update() throws UpdateException {
        try {
            this.openDataStores();
            boolean autoUpdate = true;
            try {
                autoUpdate = Settings.getBoolean((String)"autoupdate");
            }
            catch (InvalidSettingException ex) {
                LOGGER.debug("Invalid setting for auto-update; using true.");
            }
            if (autoUpdate && this.checkUpdate()) {
                UpdateableNvdCve updateable = this.getUpdatesNeeded();
                if (updateable.isUpdateNeeded()) {
                    this.performUpdate(updateable);
                }
                this.getProperties().save("NVD CVE Checked", Long.toString(System.currentTimeMillis()));
            }
        }
        catch (MalformedURLException ex) {
            throw new UpdateException("NVD CVE properties files contain an invalid URL, unable to update the data to use the most current data.", ex);
        }
        catch (DownloadFailedException ex) {
            LOGGER.warn("Unable to download the NVD CVE data; the results may not include the most recent CPE/CVEs from the NVD.");
            if (Settings.getString((String)"proxy.server") == null) {
                LOGGER.info("If you are behind a proxy you may need to configure dependency-check to use the proxy.");
            }
            throw new UpdateException("Unable to download the NVD CVE data.", ex);
        }
        finally {
            this.closeDataStores();
        }
    }

    private boolean checkUpdate() throws UpdateException {
        boolean proceed = true;
        int validForHours = Settings.getInt((String)"cve.check.validforhours", (int)0);
        if (this.dataExists() && 0 < validForHours) {
            long msValid = (long)validForHours * 60L * 60L * 1000L;
            long lastChecked = Long.parseLong(this.getProperties().getProperty("NVD CVE Checked", "0"));
            long now = System.currentTimeMillis();
            boolean bl = proceed = now - lastChecked > msValid;
            if (!proceed) {
                LOGGER.info("Skipping NVD check since last check was within {} hours.", (Object)validForHours);
                LOGGER.debug("Last NVD was at {}, and now {} is within {} ms.", new Object[]{lastChecked, now, msValid});
            }
        }
        return proceed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dataExists() {
        CveDB cve = null;
        try {
            cve = new CveDB();
            cve.open();
            boolean bl = cve.dataExists();
            return bl;
        }
        catch (DatabaseException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (cve != null) {
                cve.close();
            }
        }
    }

    private void performUpdate(UpdateableNvdCve updateable) throws UpdateException {
        Object task;
        int maxUpdates = 0;
        for (NvdCveInfo cve : updateable) {
            if (!cve.getNeedsUpdate()) continue;
            ++maxUpdates;
        }
        if (maxUpdates <= 0) {
            return;
        }
        if (maxUpdates > 3) {
            LOGGER.info("NVD CVE requires several updates; this could take a couple of minutes.");
        }
        int poolSize = MAX_THREAD_POOL_SIZE < maxUpdates ? MAX_THREAD_POOL_SIZE : maxUpdates;
        ExecutorService downloadExecutors = Executors.newFixedThreadPool(poolSize);
        ExecutorService processExecutor = Executors.newSingleThreadExecutor();
        HashSet<Future<Future<ProcessTask>>> downloadFutures = new HashSet<Future<Future<ProcessTask>>>(maxUpdates);
        for (NvdCveInfo cve : updateable) {
            if (!cve.getNeedsUpdate()) continue;
            DownloadTask downloadTask = new DownloadTask(cve, processExecutor, this.getCveDB(), Settings.getInstance());
            downloadFutures.add(downloadExecutors.submit(downloadTask));
        }
        downloadExecutors.shutdown();
        HashSet<Object> processFutures = new HashSet<Object>(maxUpdates);
        for (Future future : downloadFutures) {
            task = null;
            try {
                task = (Future)future.get();
            }
            catch (InterruptedException ex) {
                downloadExecutors.shutdownNow();
                processExecutor.shutdownNow();
                LOGGER.debug("Thread was interrupted during download", (Throwable)ex);
                throw new UpdateException("The download was interrupted", ex);
            }
            catch (ExecutionException ex) {
                downloadExecutors.shutdownNow();
                processExecutor.shutdownNow();
                LOGGER.debug("Thread was interrupted during download execution", (Throwable)ex);
                throw new UpdateException("The execution of the download was interrupted", ex);
            }
            if (task == null) {
                downloadExecutors.shutdownNow();
                processExecutor.shutdownNow();
                LOGGER.debug("Thread was interrupted during download");
                throw new UpdateException("The download was interrupted; unable to complete the update");
            }
            processFutures.add(task);
        }
        for (Future future : processFutures) {
            try {
                task = (ProcessTask)future.get();
                if (((ProcessTask)task).getException() == null) continue;
                throw ((ProcessTask)task).getException();
            }
            catch (InterruptedException ex) {
                processExecutor.shutdownNow();
                LOGGER.debug("Thread was interrupted during processing", (Throwable)ex);
                throw new UpdateException(ex);
            }
            catch (ExecutionException ex) {
                processExecutor.shutdownNow();
                LOGGER.debug("Execution Exception during process", (Throwable)ex);
                throw new UpdateException(ex);
            }
            finally {
                processExecutor.shutdown();
            }
        }
        if (maxUpdates >= 1) {
            this.getProperties().save(updateable.get("Modified"));
            LOGGER.info("Begin database maintenance.");
            this.getCveDB().cleanupDatabase();
            LOGGER.info("End database maintenance.");
        }
    }

    protected final UpdateableNvdCve getUpdatesNeeded() throws MalformedURLException, DownloadFailedException, UpdateException {
        UpdateableNvdCve updates;
        block15: {
            updates = null;
            try {
                updates = this.retrieveCurrentTimestampsFromWeb();
            }
            catch (InvalidDataException ex) {
                String msg = "Unable to retrieve valid timestamp from nvd cve downloads page";
                LOGGER.debug("Unable to retrieve valid timestamp from nvd cve downloads page", (Throwable)ex);
                throw new DownloadFailedException("Unable to retrieve valid timestamp from nvd cve downloads page", (Throwable)ex);
            }
            catch (InvalidSettingException ex) {
                LOGGER.debug("Invalid setting found when retrieving timestamps", (Throwable)ex);
                throw new DownloadFailedException("Invalid settings", (Throwable)ex);
            }
            if (updates == null) {
                throw new DownloadFailedException("Unable to retrieve the timestamps of the currently published NVD CVE data");
            }
            if (!this.getProperties().isEmpty()) {
                try {
                    long lastUpdated = Long.parseLong(this.getProperties().getProperty("NVD CVE Modified", "0"));
                    long now = System.currentTimeMillis();
                    int days = Settings.getInt((String)"cve.url.modified.validfordays", (int)7);
                    if (lastUpdated == updates.getTimeStamp("Modified")) {
                        updates.clear();
                        break block15;
                    }
                    if (DateUtil.withinDateRange(lastUpdated, now, days)) {
                        for (NvdCveInfo entry : updates) {
                            if ("Modified".equals(entry.getId())) {
                                entry.setNeedsUpdate(true);
                                continue;
                            }
                            entry.setNeedsUpdate(false);
                        }
                        break block15;
                    }
                    for (NvdCveInfo entry : updates) {
                        if ("Modified".equals(entry.getId())) {
                            entry.setNeedsUpdate(true);
                            continue;
                        }
                        long currentTimestamp = 0L;
                        try {
                            currentTimestamp = Long.parseLong(this.getProperties().getProperty("NVD CVE " + entry.getId(), "0"));
                        }
                        catch (NumberFormatException ex) {
                            LOGGER.debug("Error parsing '{}' '{}' from nvdcve.lastupdated", new Object[]{"NVD CVE ", entry.getId(), ex});
                        }
                        if (currentTimestamp != entry.getTimestamp()) continue;
                        entry.setNeedsUpdate(false);
                    }
                }
                catch (NumberFormatException ex) {
                    LOGGER.warn("An invalid schema version or timestamp exists in the data.properties file.");
                    LOGGER.debug("", (Throwable)ex);
                }
            }
        }
        return updates;
    }

    private UpdateableNvdCve retrieveCurrentTimestampsFromWeb() throws MalformedURLException, DownloadFailedException, InvalidDataException, InvalidSettingException {
        UpdateableNvdCve updates = new UpdateableNvdCve();
        updates.add("Modified", Settings.getString((String)"cve.url-2.0.modified"), Settings.getString((String)"cve.url-1.2.modified"), false);
        int start = Settings.getInt((String)"cve.startyear");
        int end = Calendar.getInstance().get(1);
        String baseUrl20 = Settings.getString((String)"cve.url-2.0.base");
        String baseUrl12 = Settings.getString((String)"cve.url-1.2.base");
        for (int i = start; i <= end; ++i) {
            updates.add(Integer.toString(i), String.format(baseUrl20, i), String.format(baseUrl12, i), true);
        }
        return updates;
    }
}

