/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.central;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class CentralSearch {
    private final URL rootURL;
    private final boolean useProxy;
    private static final Logger LOGGER = LoggerFactory.getLogger(CentralSearch.class);

    public CentralSearch(URL rootURL) {
        this.rootURL = rootURL;
        if (null != Settings.getString((String)"proxy.server")) {
            this.useProxy = true;
            LOGGER.debug("Using proxy");
        } else {
            this.useProxy = false;
            LOGGER.debug("Not using proxy");
        }
    }

    public List<MavenArtifact> searchSha1(String sha1) throws IOException {
        if (null == sha1 || !sha1.matches("^[0-9A-Fa-f]{40}$")) {
            throw new IllegalArgumentException("Invalid SHA1 format");
        }
        ArrayList<MavenArtifact> result = null;
        URL url = new URL(this.rootURL + String.format("?q=1:\"%s\"&wt=xml", sha1));
        LOGGER.debug("Searching Central url {}", (Object)url);
        HttpURLConnection conn = URLConnectionFactory.createHttpURLConnection((URL)url, (boolean)this.useProxy);
        conn.setDoOutput(true);
        conn.addRequestProperty("Accept", "application/xml");
        conn.connect();
        if (conn.getResponseCode() == 200) {
            boolean missing = false;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(conn.getInputStream());
                XPath xpath = XPathFactory.newInstance().newXPath();
                String numFound = xpath.evaluate("/response/result/@numFound", doc);
                if ("0".equals(numFound)) {
                    missing = true;
                } else {
                    result = new ArrayList<MavenArtifact>();
                    NodeList docs = (NodeList)xpath.evaluate("/response/result/doc", doc, XPathConstants.NODESET);
                    for (int i = 0; i < docs.getLength(); ++i) {
                        String g = xpath.evaluate("./str[@name='g']", docs.item(i));
                        LOGGER.trace("GroupId: {}", (Object)g);
                        String a = xpath.evaluate("./str[@name='a']", docs.item(i));
                        LOGGER.trace("ArtifactId: {}", (Object)a);
                        String v = xpath.evaluate("./str[@name='v']", docs.item(i));
                        NodeList atts = (NodeList)xpath.evaluate("./arr[@name='ec']/str", docs.item(i), XPathConstants.NODESET);
                        boolean pomAvailable = false;
                        boolean jarAvailable = false;
                        for (int x = 0; x < atts.getLength(); ++x) {
                            String tmp = xpath.evaluate(".", atts.item(x));
                            if (".pom".equals(tmp)) {
                                pomAvailable = true;
                                continue;
                            }
                            if (!".jar".equals(tmp)) continue;
                            jarAvailable = true;
                        }
                        atts = (NodeList)xpath.evaluate("./arr[@name='tags']/str", docs.item(i), XPathConstants.NODESET);
                        boolean useHTTPS = false;
                        for (int x = 0; x < atts.getLength(); ++x) {
                            String tmp = xpath.evaluate(".", atts.item(x));
                            if (!"https".equals(tmp)) continue;
                            useHTTPS = true;
                        }
                        LOGGER.trace("Version: {}", (Object)v);
                        result.add(new MavenArtifact(g, a, v, jarAvailable, pomAvailable, useHTTPS));
                    }
                }
            }
            catch (Throwable e) {
                throw new IOException(e.getMessage(), e);
            }
            if (missing) {
                throw new FileNotFoundException("Artifact not found in Central");
            }
        } else {
            LOGGER.debug("Could not connect to Central received response code: {} {}", (Object)conn.getResponseCode(), (Object)conn.getResponseMessage());
            throw new IOException("Could not connect to Central");
        }
        return result;
    }
}

