/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceCollection;
import org.owasp.dependencycheck.utils.FileFilterBuilder;

@Experimental
public class CocoaPodsAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final String ANALYZER_NAME = "CocoaPods Package Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    public static final String PODSPEC = "podspec";
    private static final FileFilter PODSPEC_FILTER = FileFilterBuilder.newInstance().addExtensions("podspec").build();
    private static final Pattern PODSPEC_BLOCK_PATTERN = Pattern.compile("Pod::Spec\\.new\\s+?do\\s+?\\|(.+?)\\|");

    @Override
    protected FileFilter getFileFilter() {
        return PODSPEC_FILTER;
    }

    @Override
    protected void initializeFileTypeAnalyzer() {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.cocoapods.enabled";
    }

    @Override
    protected void analyzeFileType(Dependency dependency, Engine engine) throws AnalysisException {
        String contents;
        try {
            contents = FileUtils.readFileToString((File)dependency.getActualFile(), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        Matcher matcher = PODSPEC_BLOCK_PATTERN.matcher(contents);
        if (matcher.find()) {
            contents = contents.substring(matcher.end());
            String blockVariable = matcher.group(1);
            EvidenceCollection vendor = dependency.getVendorEvidence();
            EvidenceCollection product = dependency.getProductEvidence();
            EvidenceCollection version = dependency.getVersionEvidence();
            String name = this.addStringEvidence(product, contents, blockVariable, "name", "name", Confidence.HIGHEST);
            if (!name.isEmpty()) {
                vendor.addEvidence(PODSPEC, "name_project", name, Confidence.HIGHEST);
            }
            this.addStringEvidence(product, contents, blockVariable, "summary", "summary", Confidence.HIGHEST);
            this.addStringEvidence(vendor, contents, blockVariable, "author", "authors?", Confidence.HIGHEST);
            this.addStringEvidence(vendor, contents, blockVariable, "homepage", "homepage", Confidence.HIGHEST);
            this.addStringEvidence(vendor, contents, blockVariable, "license", "licen[cs]es?", Confidence.HIGHEST);
            this.addStringEvidence(version, contents, blockVariable, "version", "version", Confidence.HIGHEST);
        }
        this.setPackagePath(dependency);
    }

    private String addStringEvidence(EvidenceCollection evidences, String contents, String blockVariable, String field, String fieldPattern, Confidence confidence) {
        String value = "";
        Matcher arrayMatcher = Pattern.compile(String.format("\\s*?%s\\.%s\\s*?=\\s*?\\{\\s*?(.*?)\\s*?\\}", blockVariable, fieldPattern), 2).matcher(contents);
        if (arrayMatcher.find()) {
            value = arrayMatcher.group(1);
        } else {
            Matcher matcher = Pattern.compile(String.format("\\s*?%s\\.%s\\s*?=\\s*?(['\"])(.*?)\\1", blockVariable, fieldPattern), 2).matcher(contents);
            if (matcher.find()) {
                value = matcher.group(2);
            }
        }
        if (value.length() > 0) {
            evidences.addEvidence(PODSPEC, field, value, confidence);
        }
        return value;
    }

    private void setPackagePath(Dependency dep) {
        File file = new File(dep.getFilePath());
        String parent = file.getParent();
        if (parent != null) {
            dep.setPackagePath(parent);
        }
    }
}

