/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.hints;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.owasp.dependencycheck.xml.hints.HintErrorHandler;
import org.owasp.dependencycheck.xml.hints.HintHandler;
import org.owasp.dependencycheck.xml.hints.HintParseException;
import org.owasp.dependencycheck.xml.hints.Hints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class HintParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(HintParser.class);
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String HINT_SCHEMA = "schema/dependency-hint.1.0.xsd";

    public Hints parseHints(File file) throws HintParseException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            Hints hints = this.parseHints(fis);
            return hints;
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new HintParseException(ex);
        }
        catch (SAXException ex) {
            throw new HintParseException(ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    LOGGER.debug("Unable to close stream", (Throwable)ex);
                }
            }
        }
    }

    public Hints parseHints(InputStream inputStream) throws HintParseException, SAXException {
        try {
            InputStream schemaStream = this.getClass().getClassLoader().getResourceAsStream(HINT_SCHEMA);
            HintHandler handler = new HintHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            saxParser.setProperty(JAXP_SCHEMA_SOURCE, new InputSource(schemaStream));
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setErrorHandler(new HintErrorHandler());
            xmlReader.setContentHandler(handler);
            InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
            InputSource in = new InputSource(reader);
            xmlReader.parse(in);
            Hints hints = new Hints();
            hints.setHintRules(handler.getHintRules());
            hints.setVendorDuplicatingHintRules(handler.getVendorDuplicatingHintRules());
            return hints;
        }
        catch (ParserConfigurationException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new HintParseException(ex);
        }
        catch (SAXException ex) {
            if (ex.getMessage().contains("Cannot find the declaration of element 'hints'.")) {
                throw ex;
            }
            LOGGER.debug("", (Throwable)ex);
            throw new HintParseException(ex);
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new HintParseException(ex);
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new HintParseException(ex);
        }
    }
}

