/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceCollection;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class NodePackageAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodePackageAnalyzer.class);
    private static final String ANALYZER_NAME = "Node.js Package Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    public static final String PACKAGE_JSON = "package.json";
    private static final FileFilter PACKAGE_JSON_FILTER = FileFilterBuilder.newInstance().addFilenames("package.json").build();

    @Override
    protected FileFilter getFileFilter() {
        return PACKAGE_JSON_FILTER;
    }

    @Override
    protected void initializeFileTypeAnalyzer() throws Exception {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.node.package.enabled";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void analyzeFileType(Dependency dependency, Engine engine) throws AnalysisException {
        JsonReader jsonReader;
        File file = dependency.getActualFile();
        try {
            jsonReader = Json.createReader((InputStream)FileUtils.openInputStream((File)file));
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        try {
            JsonObject json = jsonReader.readObject();
            EvidenceCollection productEvidence = dependency.getProductEvidence();
            EvidenceCollection vendorEvidence = dependency.getVendorEvidence();
            if (json.containsKey((Object)"name")) {
                Object value = json.get((Object)"name");
                if (value instanceof JsonString) {
                    String valueString = ((JsonString)value).getString();
                    productEvidence.addEvidence(PACKAGE_JSON, "name", valueString, Confidence.HIGHEST);
                    vendorEvidence.addEvidence(PACKAGE_JSON, "name_project", String.format("%s_project", valueString), Confidence.LOW);
                } else {
                    LOGGER.warn("JSON value not string as expected: {}", value);
                }
            }
            this.addToEvidence(json, productEvidence, "description");
            this.addToEvidence(json, vendorEvidence, "author");
            this.addToEvidence(json, dependency.getVersionEvidence(), "version");
            dependency.setDisplayFileName(String.format("%s/%s", file.getParentFile().getName(), file.getName()));
        }
        catch (JsonException e) {
            LOGGER.warn("Failed to parse package.json file.", (Throwable)e);
        }
        finally {
            jsonReader.close();
        }
    }

    private void addToEvidence(JsonObject json, EvidenceCollection collection, String key) {
        if (json.containsKey((Object)key)) {
            JsonValue value = (JsonValue)json.get((Object)key);
            if (value instanceof JsonString) {
                collection.addEvidence(PACKAGE_JSON, key, ((JsonString)value).getString(), Confidence.HIGHEST);
            } else if (value instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)value;
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String property = (String)entry.getKey();
                    JsonValue subValue = (JsonValue)entry.getValue();
                    if (subValue instanceof JsonString) {
                        collection.addEvidence(PACKAGE_JSON, String.format("%s.%s", key, property), ((JsonString)subValue).getString(), Confidence.HIGHEST);
                        continue;
                    }
                    LOGGER.warn("JSON sub-value not string as expected: {}", (Object)subValue);
                }
            } else {
                LOGGER.warn("JSON value not string or JSON object as expected: {}", (Object)value);
            }
        }
    }
}

