/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.AnalyzerService;
import org.owasp.dependencycheck.analyzer.FileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nvdcve.ConnectionFactory;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.UpdateService;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.NoDataException;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engine
implements FileFilter {
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private Map<AnalysisPhase, List<Analyzer>> analyzers = new EnumMap<AnalysisPhase, List<Analyzer>>(AnalysisPhase.class);
    private Set<FileTypeAnalyzer> fileTypeAnalyzers = new HashSet<FileTypeAnalyzer>();
    private ClassLoader serviceClassLoader = Thread.currentThread().getContextClassLoader();
    private static final Logger LOGGER = LoggerFactory.getLogger(Engine.class);

    public Engine() throws DatabaseException {
        this.initializeEngine();
    }

    public Engine(ClassLoader serviceClassLoader) throws DatabaseException {
        this.serviceClassLoader = serviceClassLoader;
        this.initializeEngine();
    }

    protected final void initializeEngine() throws DatabaseException {
        ConnectionFactory.initialize();
        this.loadAnalyzers();
    }

    public void cleanup() {
        ConnectionFactory.cleanup();
    }

    private void loadAnalyzers() {
        if (!this.analyzers.isEmpty()) {
            return;
        }
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            this.analyzers.put(phase, new ArrayList());
        }
        AnalyzerService service = new AnalyzerService(this.serviceClassLoader);
        List<Analyzer> iterator = service.getAnalyzers();
        for (Analyzer a : iterator) {
            this.analyzers.get((Object)a.getAnalysisPhase()).add(a);
            if (!(a instanceof FileTypeAnalyzer)) continue;
            this.fileTypeAnalyzers.add((FileTypeAnalyzer)a);
        }
    }

    public List<Analyzer> getAnalyzers(AnalysisPhase phase) {
        return this.analyzers.get((Object)phase);
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public List<Dependency> scan(String[] paths) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        for (String path : paths) {
            List<Dependency> d = this.scan(path);
            if (d == null) continue;
            deps.addAll(d);
        }
        return deps;
    }

    public List<Dependency> scan(String path) {
        File file = new File(path);
        return this.scan(file);
    }

    public List<Dependency> scan(File[] files) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        for (File file : files) {
            List<Dependency> d = this.scan(file);
            if (d == null) continue;
            deps.addAll(d);
        }
        return deps;
    }

    public List<Dependency> scan(Collection<File> files) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        for (File file : files) {
            List<Dependency> d = this.scan(file);
            if (d == null) continue;
            deps.addAll(d);
        }
        return deps;
    }

    public List<Dependency> scan(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                return this.scanDirectory(file);
            }
            Dependency d = this.scanFile(file);
            if (d != null) {
                ArrayList<Dependency> deps = new ArrayList<Dependency>();
                deps.add(d);
                return deps;
            }
        }
        return null;
    }

    protected List<Dependency> scanDirectory(File dir) {
        File[] files = dir.listFiles();
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        if (files != null) {
            for (File f : files) {
                List<Dependency> d;
                if (f.isDirectory()) {
                    d = this.scanDirectory(f);
                    if (d == null) continue;
                    deps.addAll((Collection<Dependency>)d);
                    continue;
                }
                d = this.scanFile(f);
                deps.add((Dependency)((Object)d));
            }
        }
        return deps;
    }

    protected Dependency scanFile(File file) {
        Dependency dependency = null;
        if (file.isFile()) {
            if (this.accept(file)) {
                dependency = new Dependency(file);
                this.dependencies.add(dependency);
            }
        } else {
            LOGGER.debug("Path passed to scanFile(File) is not a file: {}. Skipping the file.", (Object)file);
        }
        return dependency;
    }

    public void analyzeDependencies() {
        List<Analyzer> analyzerList;
        boolean autoUpdate = true;
        try {
            autoUpdate = Settings.getBoolean((String)"autoupdate");
        }
        catch (InvalidSettingException ex) {
            LOGGER.debug("Invalid setting for auto-update; using true.");
        }
        if (autoUpdate) {
            this.doUpdates();
        }
        try {
            this.ensureDataExists();
        }
        catch (NoDataException ex) {
            LOGGER.error("{}\n\nUnable to continue dependency-check analysis.", (Object)ex.getMessage());
            LOGGER.debug("", (Throwable)ex);
            return;
        }
        catch (DatabaseException ex) {
            LOGGER.error("{}\n\nUnable to continue dependency-check analysis.", (Object)ex.getMessage());
            LOGGER.debug("", (Throwable)ex);
            return;
        }
        LOGGER.debug("\n----------------------------------------------------\nBEGIN ANALYSIS\n----------------------------------------------------");
        LOGGER.info("Analysis Starting");
        long analysisStart = System.currentTimeMillis();
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            analyzerList = this.analyzers.get((Object)phase);
            for (Analyzer a : analyzerList) {
                a = this.initializeAnalyzer(a);
                LOGGER.debug("Begin Analyzer '{}'", (Object)a.getName());
                HashSet<Dependency> dependencySet = new HashSet<Dependency>(this.dependencies);
                for (Dependency d : dependencySet) {
                    boolean shouldAnalyze = true;
                    if (a instanceof FileTypeAnalyzer) {
                        FileTypeAnalyzer fAnalyzer = (FileTypeAnalyzer)a;
                        shouldAnalyze = fAnalyzer.accept(d.getActualFile());
                    }
                    if (!shouldAnalyze) continue;
                    LOGGER.debug("Begin Analysis of '{}'", (Object)d.getActualFilePath());
                    try {
                        a.analyze(d, this);
                    }
                    catch (AnalysisException ex) {
                        LOGGER.warn("An error occurred while analyzing '{}'.", (Object)d.getActualFilePath());
                        LOGGER.debug("", (Throwable)ex);
                    }
                    catch (Throwable ex) {
                        LOGGER.warn("An unexpected error occurred during analysis of '{}'", (Object)d.getActualFilePath());
                        LOGGER.debug("", ex);
                    }
                }
            }
        }
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            analyzerList = this.analyzers.get((Object)phase);
            for (Analyzer a : analyzerList) {
                this.closeAnalyzer(a);
            }
        }
        LOGGER.debug("\n----------------------------------------------------\nEND ANALYSIS\n----------------------------------------------------");
        LOGGER.info("Analysis Complete ({} ms)", (Object)(System.currentTimeMillis() - analysisStart));
    }

    protected Analyzer initializeAnalyzer(Analyzer analyzer) {
        try {
            LOGGER.debug("Initializing {}", (Object)analyzer.getName());
            analyzer.initialize();
        }
        catch (Throwable ex) {
            LOGGER.error("Exception occurred initializing {}.", (Object)analyzer.getName());
            LOGGER.debug("", ex);
            try {
                analyzer.close();
            }
            catch (Throwable ex1) {
                LOGGER.trace("", ex1);
            }
        }
        return analyzer;
    }

    protected void closeAnalyzer(Analyzer analyzer) {
        LOGGER.debug("Closing Analyzer '{}'", (Object)analyzer.getName());
        try {
            analyzer.close();
        }
        catch (Throwable ex) {
            LOGGER.trace("", ex);
        }
    }

    public void doUpdates() {
        LOGGER.info("Checking for updates");
        long updateStart = System.currentTimeMillis();
        UpdateService service = new UpdateService(this.serviceClassLoader);
        Iterator<CachedWebDataSource> iterator = service.getDataSources();
        while (iterator.hasNext()) {
            CachedWebDataSource source = iterator.next();
            try {
                source.update();
            }
            catch (UpdateException ex) {
                LOGGER.warn("Unable to update Cached Web DataSource, using local data instead. Results may not include recent vulnerabilities.");
                LOGGER.debug("Unable to update details for {}", (Object)source.getClass().getName(), (Object)ex);
            }
        }
        LOGGER.info("Check for updates complete ({} ms)", (Object)(System.currentTimeMillis() - updateStart));
    }

    public List<Analyzer> getAnalyzers() {
        ArrayList<Analyzer> ret = new ArrayList<Analyzer>();
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            List<Analyzer> analyzerList = this.analyzers.get((Object)phase);
            ret.addAll(analyzerList);
        }
        return ret;
    }

    @Override
    public boolean accept(File file) {
        if (file == null) {
            return false;
        }
        boolean scan = false;
        for (FileTypeAnalyzer a : this.fileTypeAnalyzers) {
            scan |= a.accept(file);
        }
        return scan;
    }

    public Set<FileTypeAnalyzer> getFileTypeAnalyzers() {
        return this.fileTypeAnalyzers;
    }

    private void ensureDataExists() throws NoDataException, DatabaseException {
        CveDB cve = new CveDB();
        try {
            cve.open();
            if (!cve.dataExists()) {
                throw new NoDataException("No documents exist");
            }
        }
        catch (DatabaseException ex) {
            throw new NoDataException(ex.getMessage(), ex);
        }
        finally {
            cve.close();
        }
    }
}

