/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AssemblyAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final String ANALYZER_NAME = "Assembly Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String[] SUPPORTED_EXTENSIONS = new String[]{"dll", "exe"};
    private File grokAssemblyExe = null;
    private DocumentBuilder builder;
    private static final Logger LOGGER = LoggerFactory.getLogger(AssemblyAnalyzer.class);
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions(SUPPORTED_EXTENSIONS).build();

    private List<String> buildArgumentList() {
        ArrayList<String> args = new ArrayList<String>();
        if (!"\\".equals(System.getProperty("file.separator"))) {
            if (Settings.getString((String)"analyzer.assembly.mono.path") != null) {
                args.add(Settings.getString((String)"analyzer.assembly.mono.path"));
            } else {
                args.add("mono");
            }
        }
        args.add(this.grokAssemblyExe.getPath());
        return args;
    }

    @Override
    public void analyzeFileType(Dependency dependency, Engine engine) throws AnalysisException {
        if (this.grokAssemblyExe == null) {
            LOGGER.warn("GrokAssembly didn't get deployed");
            return;
        }
        List<String> args = this.buildArgumentList();
        args.add(dependency.getActualFilePath());
        ProcessBuilder pb = new ProcessBuilder(args);
        Document doc = null;
        try {
            String product;
            String vendor;
            XPath xpath;
            String error;
            Process proc = pb.start();
            doc = this.builder.parse(proc.getInputStream());
            String errorStream = IOUtils.toString((InputStream)proc.getErrorStream(), (String)"UTF-8");
            if (null != errorStream && !errorStream.isEmpty()) {
                LOGGER.warn("Error from GrokAssembly: {}", (Object)errorStream);
            }
            int rc = 0;
            try {
                rc = proc.waitFor();
            }
            catch (InterruptedException ie) {
                return;
            }
            if (rc == 3) {
                LOGGER.debug("{} is not a .NET assembly or executable and as such cannot be analyzed by dependency-check", (Object)dependency.getActualFilePath());
                return;
            }
            if (rc != 0) {
                LOGGER.warn("Return code {} from GrokAssembly", (Object)rc);
            }
            if ((error = (xpath = XPathFactory.newInstance().newXPath()).evaluate("/assembly/error", doc)) != null && !error.isEmpty()) {
                throw new AnalysisException(error);
            }
            String version = xpath.evaluate("/assembly/version", doc);
            if (version != null) {
                dependency.getVersionEvidence().addEvidence(new Evidence("grokassembly", "version", version, Confidence.HIGHEST));
            }
            if ((vendor = xpath.evaluate("/assembly/company", doc)) != null) {
                dependency.getVendorEvidence().addEvidence(new Evidence("grokassembly", "vendor", vendor, Confidence.HIGH));
            }
            if ((product = xpath.evaluate("/assembly/product", doc)) != null) {
                dependency.getProductEvidence().addEvidence(new Evidence("grokassembly", "product", product, Confidence.HIGH));
            }
        }
        catch (IOException ioe) {
            throw new AnalysisException(ioe);
        }
        catch (SAXException saxe) {
            throw new AnalysisException("Couldn't parse GrokAssembly result", saxe);
        }
        catch (XPathExpressionException xpe) {
            throw new AnalysisException(xpe);
        }
    }

    @Override
    public void initializeFileTypeAnalyzer() throws Exception {
        File tempFile = File.createTempFile("GKA", ".exe", Settings.getTempDirectory());
        FileOutputStream fos = null;
        InputStream is = null;
        try {
            fos = new FileOutputStream(tempFile);
            is = AssemblyAnalyzer.class.getClassLoader().getResourceAsStream("GrokAssembly.exe");
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            this.grokAssemblyExe = tempFile;
            this.grokAssemblyExe.deleteOnExit();
            LOGGER.debug("Extracted GrokAssembly.exe to {}", (Object)this.grokAssemblyExe.getPath());
        }
        catch (IOException ioe) {
            this.setEnabled(false);
            LOGGER.warn("Could not extract GrokAssembly.exe: {}", (Object)ioe.getMessage());
            throw new AnalysisException("Could not extract GrokAssembly.exe", ioe);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable e) {
                    LOGGER.debug("Error closing output stream");
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {
                    LOGGER.debug("Error closing input stream");
                }
            }
        }
        List<String> args = this.buildArgumentList();
        try {
            ProcessBuilder pb = new ProcessBuilder(args);
            Process p = pb.start();
            IOUtils.copy((InputStream)p.getErrorStream(), (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(p.getInputStream());
            XPath xpath = XPathFactory.newInstance().newXPath();
            String error = xpath.evaluate("/assembly/error", doc);
            if (p.waitFor() != 1 || error == null || error.isEmpty()) {
                LOGGER.warn("An error occurred with the .NET AssemblyAnalyzer, please see the log for more details.");
                LOGGER.debug("GrokAssembly.exe is not working properly");
                this.grokAssemblyExe = null;
                this.setEnabled(false);
                throw new AnalysisException("Could not execute .NET AssemblyAnalyzer");
            }
        }
        catch (AnalysisException e) {
            throw e;
        }
        catch (Throwable e) {
            LOGGER.warn("An error occurred with the .NET AssemblyAnalyzer;\nthis can be ignored unless you are scanning .NET DLLs. Please see the log for more details.");
            LOGGER.debug("Could not execute GrokAssembly {}", (Object)e.getMessage());
            this.setEnabled(false);
            throw new AnalysisException("An error occurred with the .NET AssemblyAnalyzer", e);
        }
        this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    @Override
    public void close() throws Exception {
        super.close();
        try {
            if (this.grokAssemblyExe != null && !this.grokAssemblyExe.delete()) {
                this.grokAssemblyExe.deleteOnExit();
            }
        }
        catch (SecurityException se) {
            LOGGER.debug("Can't delete temporary GrokAssembly.exe");
        }
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.assembly.enabled";
    }
}

