/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.data.update.nvd.NvdCveInfo;
import org.owasp.dependencycheck.data.update.nvd.ProcessTask;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadTask
implements Callable<Future<ProcessTask>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadTask.class);
    private final CveDB cveDB;
    private final ExecutorService processorService;
    private NvdCveInfo nvdCveInfo;
    private final Settings settings;
    private File first;
    private File second;

    public DownloadTask(NvdCveInfo nvdCveInfo, ExecutorService processor, CveDB cveDB, Settings settings) throws UpdateException {
        File file2;
        File file1;
        this.nvdCveInfo = nvdCveInfo;
        this.processorService = processor;
        this.cveDB = cveDB;
        this.settings = settings;
        try {
            file1 = File.createTempFile("cve" + nvdCveInfo.getId() + '_', ".xml", Settings.getTempDirectory());
            file2 = File.createTempFile("cve_1_2_" + nvdCveInfo.getId() + '_', ".xml", Settings.getTempDirectory());
        }
        catch (IOException ex) {
            throw new UpdateException("Unable to create temporary files", ex);
        }
        this.first = file1;
        this.second = file2;
    }

    public NvdCveInfo getNvdCveInfo() {
        return this.nvdCveInfo;
    }

    public void setNvdCveInfo(NvdCveInfo nvdCveInfo) {
        this.nvdCveInfo = nvdCveInfo;
    }

    public File getFirst() {
        return this.first;
    }

    public void setFirst(File first) {
        this.first = first;
    }

    public File getSecond() {
        return this.second;
    }

    public void setSecond(File second) {
        this.second = second;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<ProcessTask> call() throws Exception {
        try {
            Settings.setInstance((Settings)this.settings);
            URL url1 = new URL(this.nvdCveInfo.getUrl());
            URL url2 = new URL(this.nvdCveInfo.getOldSchemaVersionUrl());
            LOGGER.info("Download Started for NVD CVE - {}", (Object)this.nvdCveInfo.getId());
            long startDownload = System.currentTimeMillis();
            try {
                Downloader.fetchFile((URL)url1, (File)this.first);
                Downloader.fetchFile((URL)url2, (File)this.second);
            }
            catch (DownloadFailedException ex) {
                LOGGER.warn("Download Failed for NVD CVE - {}\nSome CVEs may not be reported.", (Object)this.nvdCveInfo.getId());
                if (Settings.getString((String)"proxy.server") == null) {
                    LOGGER.info("If you are behind a proxy you may need to configure dependency-check to use the proxy.");
                }
                LOGGER.debug("", (Throwable)ex);
                Future<ProcessTask> future = null;
                Settings.cleanup((boolean)false);
                return future;
            }
            if (url1.toExternalForm().endsWith(".xml.gz")) {
                this.extractGzip(this.first);
            }
            if (url2.toExternalForm().endsWith(".xml.gz")) {
                this.extractGzip(this.second);
            }
            LOGGER.info("Download Complete for NVD CVE - {}  ({} ms)", (Object)this.nvdCveInfo.getId(), (Object)(System.currentTimeMillis() - startDownload));
            if (this.processorService == null) {
                Future<ProcessTask> ex = null;
                return ex;
            }
            ProcessTask task = new ProcessTask(this.cveDB, this, this.settings);
            Future<ProcessTask> future = this.processorService.submit(task);
            return future;
        }
        catch (Throwable ex) {
            LOGGER.warn("An exception occurred downloading NVD CVE - {}\nSome CVEs may not be reported.", (Object)this.nvdCveInfo.getId());
            LOGGER.debug("Download Task Failed", ex);
        }
        finally {
            Settings.cleanup((boolean)false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        boolean deleted = false;
        try {
            if (this.first != null && this.first.exists()) {
                deleted = this.first.delete();
            }
        }
        finally {
            if (this.first != null && (this.first.exists() || !deleted)) {
                this.first.deleteOnExit();
            }
        }
        try {
            deleted = false;
            if (this.second != null && this.second.exists()) {
                deleted = this.second.delete();
            }
        }
        finally {
            if (this.second != null && (this.second.exists() || !deleted)) {
                this.second.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractGzip(File file) throws FileNotFoundException, IOException {
        String originalPath = file.getPath();
        File gzip = new File(originalPath + ".gz");
        if (gzip.isFile() && !gzip.delete()) {
            gzip.deleteOnExit();
        }
        if (!file.renameTo(gzip)) {
            throw new IOException("Unable to rename '" + file.getPath() + "'");
        }
        File newfile = new File(originalPath);
        byte[] buffer = new byte[4096];
        GZIPInputStream cin = null;
        FileOutputStream out = null;
        try {
            int len;
            cin = new GZIPInputStream(new FileInputStream(gzip));
            out = new FileOutputStream(newfile);
            while ((len = cin.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            if (cin != null) {
                try {
                    cin.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("ignore", (Throwable)ex);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("ignore", (Throwable)ex);
                }
            }
            if (gzip.isFile()) {
                FileUtils.deleteQuietly((File)gzip);
            }
        }
    }
}

