/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.owasp.dependencycheck.data.cwe.CweDB;
import org.owasp.dependencycheck.data.nvdcve.ConnectionFactory;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.dependency.Reference;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.utils.DBUtils;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.owasp.dependencycheck.utils.Pair;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CveDB {
    private static final Logger LOGGER = LoggerFactory.getLogger(CveDB.class);
    private Connection conn;
    private ResourceBundle statementBundle = null;
    private DatabaseProperties databaseProperties;

    public CveDB() throws DatabaseException {
        this.open();
        try {
            String databaseProductName = this.conn.getMetaData().getDatabaseProductName();
            LOGGER.debug("Database dialect: {}", (Object)databaseProductName);
            Locale dbDialect = new Locale(databaseProductName);
            this.statementBundle = ResourceBundle.getBundle("data/dbStatements", dbDialect);
        }
        catch (SQLException se) {
            LOGGER.warn("Problem loading database specific dialect!", (Throwable)se);
            this.statementBundle = ResourceBundle.getBundle("data/dbStatements");
        }
        this.databaseProperties = new DatabaseProperties(this);
    }

    protected Connection getConnection() {
        return this.conn;
    }

    public final void open() throws DatabaseException {
        if (!this.isOpen()) {
            this.conn = ConnectionFactory.getConnection();
        }
    }

    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException ex) {
                LOGGER.error("There was an error attempting to close the CveDB, see the log for more details.");
                LOGGER.debug("", (Throwable)ex);
            }
            catch (Throwable ex) {
                LOGGER.error("There was an exception attempting to close the CveDB, see the log for more details.");
                LOGGER.debug("", ex);
            }
            this.conn = null;
        }
    }

    public boolean isOpen() {
        return this.conn != null;
    }

    public void commit() throws SQLException {
    }

    protected void finalize() throws Throwable {
        LOGGER.debug("Entering finalize");
        this.close();
        super.finalize();
    }

    public DatabaseProperties getDatabaseProperties() {
        return this.databaseProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<VulnerableSoftware> getCPEs(String vendor, String product) {
        HashSet<VulnerableSoftware> cpe = new HashSet<VulnerableSoftware>();
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = this.getConnection().prepareStatement(this.statementBundle.getString("SELECT_CPE_ENTRIES"));
            ps.setString(1, vendor);
            ps.setString(2, product);
            rs = ps.executeQuery();
            while (rs.next()) {
                VulnerableSoftware vs = new VulnerableSoftware();
                vs.setCpe(rs.getString(1));
                cpe.add(vs);
            }
        }
        catch (SQLException ex) {
            try {
                LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
                LOGGER.debug("", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(ps);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(ps);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(ps);
        return cpe;
    }

    public Set<Pair<String, String>> getVendorProductList() throws DatabaseException {
        HashSet<Pair<String, String>> data = new HashSet<Pair<String, String>>();
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = this.getConnection().prepareStatement(this.statementBundle.getString("SELECT_VENDOR_PRODUCT_LIST"));
            rs = ps.executeQuery();
            while (rs.next()) {
                data.add(new Pair<String, String>(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException ex) {
            try {
                String msg = "An unexpected SQL Exception occurred; please see the verbose log for more details.";
                throw new DatabaseException("An unexpected SQL Exception occurred; please see the verbose log for more details.", ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(ps);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(ps);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getProperties() {
        Properties prop = new Properties();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.getConnection().prepareStatement(this.statementBundle.getString("SELECT_PROPERTIES"));
            rs = ps.executeQuery();
            while (rs.next()) {
                prop.setProperty(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException ex) {
            try {
                LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
                LOGGER.debug("", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(ps);
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
            DBUtils.closeStatement(ps);
            DBUtils.closeResultSet(rs);
        }
        DBUtils.closeStatement(ps);
        DBUtils.closeResultSet(rs);
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveProperty(String key, String value) {
        try {
            try {
                PreparedStatement mergeProperty = this.getConnection().prepareStatement(this.statementBundle.getString("MERGE_PROPERTY"));
                try {
                    mergeProperty.setString(1, key);
                    mergeProperty.setString(2, value);
                    mergeProperty.executeUpdate();
                }
                finally {
                    DBUtils.closeStatement(mergeProperty);
                }
            }
            catch (MissingResourceException mre) {
                PreparedStatement insertProperty;
                PreparedStatement updateProperty;
                block10: {
                    updateProperty = null;
                    insertProperty = null;
                    try {
                        updateProperty = this.getConnection().prepareStatement(this.statementBundle.getString("UPDATE_PROPERTY"));
                        updateProperty.setString(1, value);
                        updateProperty.setString(2, key);
                        if (updateProperty.executeUpdate() != 0) break block10;
                        insertProperty = this.getConnection().prepareStatement(this.statementBundle.getString("INSERT_PROPERTY"));
                        insertProperty.setString(1, key);
                        insertProperty.setString(2, value);
                        insertProperty.executeUpdate();
                    }
                    catch (Throwable throwable) {
                        DBUtils.closeStatement(updateProperty);
                        DBUtils.closeStatement(insertProperty);
                        throw throwable;
                    }
                }
                DBUtils.closeStatement(updateProperty);
                DBUtils.closeStatement(insertProperty);
            }
        }
        catch (SQLException ex) {
            LOGGER.warn("Unable to save property '{}' with a value of '{}' to the database", (Object)key, (Object)value);
            LOGGER.debug("", (Throwable)ex);
        }
    }

    public List<Vulnerability> getVulnerabilities(String cpeStr) throws DatabaseException {
        VulnerableSoftware cpe = new VulnerableSoftware();
        try {
            cpe.parseName(cpeStr);
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.trace("", (Throwable)ex);
        }
        DependencyVersion detectedVersion = this.parseDependencyVersion(cpe);
        ArrayList<Vulnerability> vulnerabilities = new ArrayList<Vulnerability>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.getConnection().prepareStatement(this.statementBundle.getString("SELECT_CVE_FROM_SOFTWARE"));
            ps.setString(1, cpe.getVendor());
            ps.setString(2, cpe.getProduct());
            rs = ps.executeQuery();
            String currentCVE = "";
            HashMap<String, Boolean> vulnSoftware = new HashMap<String, Boolean>();
            while (rs.next()) {
                String cveId = rs.getString(1);
                if (!currentCVE.equals(cveId)) {
                    Map.Entry<String, Boolean> matchedCPE = this.getMatchingSoftware(vulnSoftware, cpe.getVendor(), cpe.getProduct(), detectedVersion);
                    if (matchedCPE != null) {
                        Vulnerability v = this.getVulnerability(currentCVE);
                        v.setMatchedCPE(matchedCPE.getKey(), matchedCPE.getValue() != false ? "Y" : null);
                        vulnerabilities.add(v);
                    }
                    vulnSoftware.clear();
                    currentCVE = cveId;
                }
                String cpeId = rs.getString(2);
                String previous = rs.getString(3);
                Boolean p = previous != null && !previous.isEmpty();
                vulnSoftware.put(cpeId, p);
            }
            Map.Entry<String, Boolean> matchedCPE = this.getMatchingSoftware(vulnSoftware, cpe.getVendor(), cpe.getProduct(), detectedVersion);
            if (matchedCPE != null) {
                Vulnerability v = this.getVulnerability(currentCVE);
                v.setMatchedCPE(matchedCPE.getKey(), matchedCPE.getValue() != false ? "Y" : null);
                vulnerabilities.add(v);
            }
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Exception retrieving vulnerability for " + cpeStr, ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(ps);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(ps);
        return vulnerabilities;
    }

    private Vulnerability getVulnerability(String cve) throws DatabaseException {
        PreparedStatement psV = null;
        PreparedStatement psR = null;
        PreparedStatement psS = null;
        ResultSet rsV = null;
        ResultSet rsR = null;
        ResultSet rsS = null;
        Vulnerability vuln = null;
        try {
            psV = this.getConnection().prepareStatement(this.statementBundle.getString("SELECT_VULNERABILITY"));
            psV.setString(1, cve);
            rsV = psV.executeQuery();
            if (rsV.next()) {
                String name;
                vuln = new Vulnerability();
                vuln.setName(cve);
                vuln.setDescription(rsV.getString(2));
                String cwe = rsV.getString(3);
                if (cwe != null && (name = CweDB.getCweName(cwe)) != null) {
                    cwe = cwe + ' ' + name;
                }
                int cveId = rsV.getInt(1);
                vuln.setCwe(cwe);
                vuln.setCvssScore(rsV.getFloat(4));
                vuln.setCvssAccessVector(rsV.getString(5));
                vuln.setCvssAccessComplexity(rsV.getString(6));
                vuln.setCvssAuthentication(rsV.getString(7));
                vuln.setCvssConfidentialityImpact(rsV.getString(8));
                vuln.setCvssIntegrityImpact(rsV.getString(9));
                vuln.setCvssAvailabilityImpact(rsV.getString(10));
                psR = this.getConnection().prepareStatement(this.statementBundle.getString("SELECT_REFERENCES"));
                psR.setInt(1, cveId);
                rsR = psR.executeQuery();
                while (rsR.next()) {
                    vuln.addReference(rsR.getString(1), rsR.getString(2), rsR.getString(3));
                }
                psS = this.getConnection().prepareStatement(this.statementBundle.getString("SELECT_SOFTWARE"));
                psS.setInt(1, cveId);
                rsS = psS.executeQuery();
                while (rsS.next()) {
                    String cpe = rsS.getString(1);
                    String prevVersion = rsS.getString(2);
                    if (prevVersion == null) {
                        vuln.addVulnerableSoftware(cpe);
                        continue;
                    }
                    vuln.addVulnerableSoftware(cpe, prevVersion);
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Error retrieving " + cve, ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rsV);
                DBUtils.closeResultSet(rsR);
                DBUtils.closeResultSet(rsS);
                DBUtils.closeStatement(psV);
                DBUtils.closeStatement(psR);
                DBUtils.closeStatement(psS);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rsV);
        DBUtils.closeResultSet(rsR);
        DBUtils.closeResultSet(rsS);
        DBUtils.closeStatement(psV);
        DBUtils.closeStatement(psR);
        DBUtils.closeStatement(psS);
        return vuln;
    }

    public void updateVulnerability(Vulnerability vuln) throws DatabaseException {
        PreparedStatement selectVulnerabilityId = null;
        PreparedStatement deleteVulnerability = null;
        PreparedStatement deleteReferences = null;
        PreparedStatement deleteSoftware = null;
        PreparedStatement updateVulnerability = null;
        PreparedStatement insertVulnerability = null;
        PreparedStatement insertReference = null;
        PreparedStatement selectCpeId = null;
        PreparedStatement insertCpe = null;
        PreparedStatement insertSoftware = null;
        try {
            selectVulnerabilityId = this.getConnection().prepareStatement(this.statementBundle.getString("SELECT_VULNERABILITY_ID"));
            deleteVulnerability = this.getConnection().prepareStatement(this.statementBundle.getString("DELETE_VULNERABILITY"));
            deleteReferences = this.getConnection().prepareStatement(this.statementBundle.getString("DELETE_REFERENCE"));
            deleteSoftware = this.getConnection().prepareStatement(this.statementBundle.getString("DELETE_SOFTWARE"));
            updateVulnerability = this.getConnection().prepareStatement(this.statementBundle.getString("UPDATE_VULNERABILITY"));
            String[] ids = new String[]{"id"};
            insertVulnerability = this.getConnection().prepareStatement(this.statementBundle.getString("INSERT_VULNERABILITY"), ids);
            insertReference = this.getConnection().prepareStatement(this.statementBundle.getString("INSERT_REFERENCE"));
            selectCpeId = this.getConnection().prepareStatement(this.statementBundle.getString("SELECT_CPE_ID"));
            insertCpe = this.getConnection().prepareStatement(this.statementBundle.getString("INSERT_CPE"), ids);
            insertSoftware = this.getConnection().prepareStatement(this.statementBundle.getString("INSERT_SOFTWARE"));
            int vulnerabilityId = 0;
            selectVulnerabilityId.setString(1, vuln.getName());
            ResultSet rs = selectVulnerabilityId.executeQuery();
            if (rs.next()) {
                vulnerabilityId = rs.getInt(1);
                deleteReferences.setInt(1, vulnerabilityId);
                deleteReferences.execute();
                deleteSoftware.setInt(1, vulnerabilityId);
                deleteSoftware.execute();
            }
            DBUtils.closeResultSet(rs);
            rs = null;
            if (vulnerabilityId != 0) {
                if (vuln.getDescription().contains("** REJECT **")) {
                    deleteVulnerability.setInt(1, vulnerabilityId);
                    deleteVulnerability.executeUpdate();
                } else {
                    updateVulnerability.setString(1, vuln.getDescription());
                    updateVulnerability.setString(2, vuln.getCwe());
                    updateVulnerability.setFloat(3, vuln.getCvssScore());
                    updateVulnerability.setString(4, vuln.getCvssAccessVector());
                    updateVulnerability.setString(5, vuln.getCvssAccessComplexity());
                    updateVulnerability.setString(6, vuln.getCvssAuthentication());
                    updateVulnerability.setString(7, vuln.getCvssConfidentialityImpact());
                    updateVulnerability.setString(8, vuln.getCvssIntegrityImpact());
                    updateVulnerability.setString(9, vuln.getCvssAvailabilityImpact());
                    updateVulnerability.setInt(10, vulnerabilityId);
                    updateVulnerability.executeUpdate();
                }
            } else {
                insertVulnerability.setString(1, vuln.getName());
                insertVulnerability.setString(2, vuln.getDescription());
                insertVulnerability.setString(3, vuln.getCwe());
                insertVulnerability.setFloat(4, vuln.getCvssScore());
                insertVulnerability.setString(5, vuln.getCvssAccessVector());
                insertVulnerability.setString(6, vuln.getCvssAccessComplexity());
                insertVulnerability.setString(7, vuln.getCvssAuthentication());
                insertVulnerability.setString(8, vuln.getCvssConfidentialityImpact());
                insertVulnerability.setString(9, vuln.getCvssIntegrityImpact());
                insertVulnerability.setString(10, vuln.getCvssAvailabilityImpact());
                insertVulnerability.execute();
                try {
                    rs = insertVulnerability.getGeneratedKeys();
                    rs.next();
                    vulnerabilityId = rs.getInt(1);
                }
                catch (SQLException ex) {
                    String msg = String.format("Unable to retrieve id for new vulnerability for '%s'", vuln.getName());
                    throw new DatabaseException(msg, ex);
                }
                finally {
                    DBUtils.closeResultSet(rs);
                    rs = null;
                }
            }
            insertReference.setInt(1, vulnerabilityId);
            for (Reference r : vuln.getReferences()) {
                insertReference.setString(2, r.getName());
                insertReference.setString(3, r.getUrl());
                insertReference.setString(4, r.getSource());
                insertReference.execute();
            }
            for (VulnerableSoftware s : vuln.getVulnerableSoftware()) {
                int cpeProductId = 0;
                selectCpeId.setString(1, s.getName());
                try {
                    rs = selectCpeId.executeQuery();
                    if (rs.next()) {
                        cpeProductId = rs.getInt(1);
                    }
                }
                catch (SQLException ex) {
                    throw new DatabaseException("Unable to get primary key for new cpe: " + s.getName(), ex);
                }
                finally {
                    DBUtils.closeResultSet(rs);
                    rs = null;
                }
                if (cpeProductId == 0) {
                    insertCpe.setString(1, s.getName());
                    insertCpe.setString(2, s.getVendor());
                    insertCpe.setString(3, s.getProduct());
                    insertCpe.executeUpdate();
                    cpeProductId = DBUtils.getGeneratedKey(insertCpe);
                }
                if (cpeProductId == 0) {
                    throw new DatabaseException("Unable to retrieve cpeProductId - no data returned");
                }
                insertSoftware.setInt(1, vulnerabilityId);
                insertSoftware.setInt(2, cpeProductId);
                if (s.getPreviousVersion() == null) {
                    insertSoftware.setNull(3, 12);
                } else {
                    insertSoftware.setString(3, s.getPreviousVersion());
                }
                insertSoftware.execute();
            }
        }
        catch (SQLException ex) {
            try {
                String msg = String.format("Error updating '%s'", vuln.getName());
                LOGGER.debug("", (Throwable)ex);
                throw new DatabaseException(msg, ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(selectVulnerabilityId);
                DBUtils.closeStatement(deleteReferences);
                DBUtils.closeStatement(deleteSoftware);
                DBUtils.closeStatement(updateVulnerability);
                DBUtils.closeStatement(deleteVulnerability);
                DBUtils.closeStatement(insertVulnerability);
                DBUtils.closeStatement(insertReference);
                DBUtils.closeStatement(selectCpeId);
                DBUtils.closeStatement(insertCpe);
                DBUtils.closeStatement(insertSoftware);
                throw throwable;
            }
        }
        DBUtils.closeStatement(selectVulnerabilityId);
        DBUtils.closeStatement(deleteReferences);
        DBUtils.closeStatement(deleteSoftware);
        DBUtils.closeStatement(updateVulnerability);
        DBUtils.closeStatement(deleteVulnerability);
        DBUtils.closeStatement(insertVulnerability);
        DBUtils.closeStatement(insertReference);
        DBUtils.closeStatement(selectCpeId);
        DBUtils.closeStatement(insertCpe);
        DBUtils.closeStatement(insertSoftware);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dataExists() {
        ResultSet rs;
        Statement cs;
        block6: {
            boolean bl;
            cs = null;
            rs = null;
            try {
                cs = this.conn.createStatement();
                rs = cs.executeQuery("SELECT COUNT(*) records FROM cpeEntry");
                if (!rs.next() || rs.getInt(1) <= 0) break block6;
                bl = true;
            }
            catch (SQLException ex) {
                try {
                    String dd;
                    try {
                        dd = Settings.getDataDirectory().getAbsolutePath();
                    }
                    catch (IOException ex1) {
                        dd = Settings.getString((String)"data.directory");
                    }
                    LOGGER.error("Unable to access the local database.\n\nEnsure that '{}' is a writable directory. If the problem persist try deleting the files in '{}' and running {} again. If the problem continues, please create a log file (see documentation at http://jeremylong.github.io/DependencyCheck/) and open a ticket at https://github.com/jeremylong/DependencyCheck/issues and include the log file.\n\n", new Object[]{dd, dd, Settings.getString((String)"application.name")});
                    LOGGER.debug("", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    DBUtils.closeStatement(cs);
                    throw throwable;
                }
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(cs);
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(cs);
            return bl;
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(cs);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupDatabase() {
        PreparedStatement ps;
        block4: {
            ps = null;
            try {
                ps = this.getConnection().prepareStatement(this.statementBundle.getString("CLEANUP_ORPHANS"));
                if (ps == null) break block4;
                ps.executeUpdate();
            }
            catch (SQLException ex) {
                try {
                    LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
                    LOGGER.debug("", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DBUtils.closeStatement(ps);
                    throw throwable;
                }
                DBUtils.closeStatement(ps);
            }
        }
        DBUtils.closeStatement(ps);
    }

    Map.Entry<String, Boolean> getMatchingSoftware(Map<String, Boolean> vulnerableSoftware, String vendor, String product, DependencyVersion identifiedVersion) {
        DependencyVersion v;
        boolean isVersionTwoADifferentProduct = "apache".equals(vendor) && "struts".equals(product);
        HashSet<String> majorVersionsAffectingAllPrevious = new HashSet<String>();
        boolean matchesAnyPrevious = identifiedVersion == null || "-".equals(identifiedVersion.toString());
        String majorVersionMatch = null;
        for (Map.Entry<String, Boolean> entry : vulnerableSoftware.entrySet()) {
            DependencyVersion v2 = this.parseDependencyVersion(entry.getKey());
            if (v2 == null || "-".equals(v2.toString())) {
                return entry;
            }
            if (!entry.getValue().booleanValue()) continue;
            if (matchesAnyPrevious) {
                return entry;
            }
            if (identifiedVersion != null && identifiedVersion.getVersionParts().get(0).equals(v2.getVersionParts().get(0))) {
                majorVersionMatch = v2.getVersionParts().get(0);
            }
            majorVersionsAffectingAllPrevious.add(v2.getVersionParts().get(0));
        }
        if (matchesAnyPrevious) {
            return null;
        }
        boolean canSkipVersions = majorVersionMatch != null && majorVersionsAffectingAllPrevious.size() > 1;
        for (Map.Entry<String, Boolean> entry : vulnerableSoftware.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            v = this.parseDependencyVersion(entry.getKey());
            if (canSkipVersions && !majorVersionMatch.equals(v.getVersionParts().get(0)) || !identifiedVersion.equals(v)) continue;
            return entry;
        }
        for (Map.Entry<String, Boolean> entry : vulnerableSoftware.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            v = this.parseDependencyVersion(entry.getKey());
            if (canSkipVersions && !majorVersionMatch.equals(v.getVersionParts().get(0)) || !entry.getValue().booleanValue() || identifiedVersion.compareTo(v) > 0 || isVersionTwoADifferentProduct && !identifiedVersion.getVersionParts().get(0).equals(v.getVersionParts().get(0))) continue;
            return entry;
        }
        return null;
    }

    private DependencyVersion parseDependencyVersion(String cpeStr) {
        VulnerableSoftware cpe = new VulnerableSoftware();
        try {
            cpe.parseName(cpeStr);
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.trace("", (Throwable)ex);
        }
        return this.parseDependencyVersion(cpe);
    }

    private DependencyVersion parseDependencyVersion(VulnerableSoftware cpe) {
        DependencyVersion cpeVersion;
        if (cpe.getVersion() != null && !cpe.getVersion().isEmpty()) {
            String versionText = cpe.getUpdate() != null && !cpe.getUpdate().isEmpty() ? String.format("%s.%s", cpe.getVersion(), cpe.getUpdate()) : cpe.getVersion();
            cpeVersion = DependencyVersionUtil.parseVersion(versionText);
        } else {
            cpeVersion = new DependencyVersion("-");
        }
        return cpeVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUnusedCpe() {
        CallableStatement cs = null;
        try {
            cs = this.getConnection().prepareCall(this.statementBundle.getString("DELETE_UNUSED_DICT_CPE"));
            cs.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                LOGGER.error("Unable to delete CPE dictionary entries", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(cs);
                throw throwable;
            }
            DBUtils.closeStatement(cs);
        }
        DBUtils.closeStatement(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCpe(String cpe, String vendor, String product) {
        CallableStatement ps = null;
        try {
            ps = this.getConnection().prepareCall(this.statementBundle.getString("ADD_DICT_CPE"));
            ps.setString(1, cpe);
            ps.setString(2, vendor);
            ps.setString(3, product);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                LOGGER.error("Unable to add CPE dictionary entry", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(ps);
                throw throwable;
            }
            DBUtils.closeStatement(ps);
        }
        DBUtils.closeStatement(ps);
    }
}

