/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.pom;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.owasp.dependencycheck.analyzer.JarAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.xml.pom.Model;
import org.owasp.dependencycheck.xml.pom.PomParseException;
import org.owasp.dependencycheck.xml.pom.PomParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PomUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomUtils.class);

    private PomUtils() {
    }

    public static Model readPom(File file) throws AnalysisException {
        Model model = null;
        try {
            PomParser parser = new PomParser();
            model = parser.parse(file);
        }
        catch (PomParseException ex) {
            LOGGER.warn("Unable to parse pom '{}'", (Object)file.getPath());
            LOGGER.debug("", (Throwable)ex);
            throw new AnalysisException(ex);
        }
        catch (IOException ex) {
            LOGGER.warn("Unable to parse pom '{}'(IO Exception)", (Object)file.getPath());
            LOGGER.debug("", (Throwable)ex);
            throw new AnalysisException(ex);
        }
        catch (Throwable ex) {
            LOGGER.warn("Unexpected error during parsing of the pom '{}'", (Object)file.getPath());
            LOGGER.debug("", ex);
            throw new AnalysisException(ex);
        }
        return model;
    }

    public static Model readPom(String path, JarFile jar) throws AnalysisException {
        ZipEntry entry = jar.getEntry(path);
        Model model = null;
        if (entry != null) {
            try {
                PomParser parser = new PomParser();
                model = parser.parse(jar.getInputStream(entry));
                LOGGER.debug("Read POM {}", (Object)path);
            }
            catch (SecurityException ex) {
                LOGGER.warn("Unable to parse pom '{}' in jar '{}'; invalid signature", (Object)path, (Object)jar.getName());
                LOGGER.debug("", (Throwable)ex);
                throw new AnalysisException(ex);
            }
            catch (IOException ex) {
                LOGGER.warn("Unable to parse pom '{}' in jar '{}' (IO Exception)", (Object)path, (Object)jar.getName());
                LOGGER.debug("", (Throwable)ex);
                throw new AnalysisException(ex);
            }
            catch (Throwable ex) {
                LOGGER.warn("Unexpected error during parsing of the pom '{}' in jar '{}'", (Object)path, (Object)jar.getName());
                LOGGER.debug("", ex);
                throw new AnalysisException(ex);
            }
        }
        return model;
    }

    public static void analyzePOM(Dependency dependency, File pomFile) throws AnalysisException {
        Model pom = PomUtils.readPom(pomFile);
        JarAnalyzer.setPomEvidence(dependency, pom, null);
    }
}

