/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.FileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;

public abstract class AbstractFileTypeAnalyzer
extends AbstractAnalyzer
implements FileTypeAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(AbstractFileTypeAnalyzer.class.getName());
    private boolean filesMatched = false;
    private boolean enabled = true;

    public AbstractFileTypeAnalyzer() {
        String key = this.getAnalyzerEnabledSettingKey();
        try {
            this.enabled = Settings.getBoolean((String)key, (boolean)true);
        }
        catch (InvalidSettingException ex) {
            String msg = String.format("Invalid setting for property '%s'", key);
            LOGGER.log(Level.WARNING, msg);
            LOGGER.log(Level.FINE, "", ex);
            msg = String.format("%s has been disabled", this.getName());
            LOGGER.log(Level.WARNING, msg);
        }
    }

    protected boolean isFilesMatched() {
        return this.filesMatched;
    }

    protected void setFilesMatched(boolean filesMatched) {
        this.filesMatched = filesMatched;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected abstract Set<String> getSupportedExtensions();

    protected abstract void initializeFileTypeAnalyzer() throws Exception;

    protected abstract void analyzeFileType(Dependency var1, Engine var2) throws AnalysisException;

    protected abstract String getAnalyzerEnabledSettingKey();

    @Override
    public final void initialize() throws Exception {
        if (this.filesMatched) {
            this.initializeFileTypeAnalyzer();
        } else {
            this.enabled = false;
        }
    }

    @Override
    public final void analyze(Dependency dependency, Engine engine) throws AnalysisException {
        if (this.enabled) {
            this.analyzeFileType(dependency, engine);
        }
    }

    @Override
    public final boolean supportsExtension(String extension) {
        if (!this.enabled) {
            return false;
        }
        Set<String> ext = this.getSupportedExtensions();
        if (ext == null) {
            String msg = String.format("The '%s' analyzer is misconfigured and does not have any file extensions; it will be disabled", this.getName());
            LOGGER.log(Level.SEVERE, msg);
            return false;
        }
        boolean match = ext.contains(extension);
        if (match) {
            this.filesMatched = match;
        }
        return match;
    }

    protected static Set<String> newHashSet(String ... strings) {
        HashSet<String> set = new HashSet<String>();
        Collections.addAll(set, strings);
        return set;
    }
}

