/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.pom;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.owasp.dependencycheck.analyzer.JarAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.xml.pom.Model;
import org.owasp.dependencycheck.xml.pom.PomParseException;
import org.owasp.dependencycheck.xml.pom.PomParser;

public final class PomUtils {
    private static final Logger LOGGER = Logger.getLogger(PomUtils.class.getName());

    private PomUtils() {
    }

    public static Model readPom(File file) throws AnalysisException {
        Model model = null;
        try {
            PomParser parser = new PomParser();
            model = parser.parse(file);
        }
        catch (PomParseException ex) {
            String msg = String.format("Unable to parse pom '%s'", file.getPath());
            LOGGER.log(Level.WARNING, msg);
            LOGGER.log(Level.FINE, "", ex);
            throw new AnalysisException(ex);
        }
        catch (IOException ex) {
            String msg = String.format("Unable to parse pom '%s'(IO Exception)", file.getPath());
            LOGGER.log(Level.WARNING, msg);
            LOGGER.log(Level.FINE, "", ex);
            throw new AnalysisException(ex);
        }
        catch (Throwable ex) {
            String msg = String.format("Unexpected error during parsing of the pom '%s'", file.getPath());
            LOGGER.log(Level.WARNING, msg);
            LOGGER.log(Level.FINE, "", ex);
            throw new AnalysisException(ex);
        }
        return model;
    }

    public static Model readPom(String path, JarFile jar) throws AnalysisException {
        ZipEntry entry = jar.getEntry(path);
        Model model = null;
        if (entry != null) {
            try {
                PomParser parser = new PomParser();
                model = parser.parse(jar.getInputStream(entry));
                LOGGER.fine(String.format("Read POM %s", path));
            }
            catch (SecurityException ex) {
                String msg = String.format("Unable to parse pom '%s' in jar '%s'; invalid signature", path, jar.getName());
                LOGGER.log(Level.WARNING, msg);
                LOGGER.log(Level.FINE, null, ex);
                throw new AnalysisException(ex);
            }
            catch (IOException ex) {
                String msg = String.format("Unable to parse pom '%s' in jar '%s' (IO Exception)", path, jar.getName());
                LOGGER.log(Level.WARNING, msg);
                LOGGER.log(Level.FINE, "", ex);
                throw new AnalysisException(ex);
            }
            catch (Throwable ex) {
                String msg = String.format("Unexpected error during parsing of the pom '%s' in jar '%s'", path, jar.getName());
                LOGGER.log(Level.WARNING, msg);
                LOGGER.log(Level.FINE, "", ex);
                throw new AnalysisException(ex);
            }
        }
        return model;
    }

    public static void analyzePOM(Dependency dependency, File pomFile) throws AnalysisException {
        String description;
        String pomName;
        String orgName;
        Model pom = PomUtils.readPom(pomFile);
        String groupid = pom.getGroupId();
        String parentGroupId = null;
        if (pom.getParentGroupId() != null) {
            parentGroupId = pom.getParentGroupId();
            if ((groupid == null || groupid.isEmpty()) && parentGroupId != null && !parentGroupId.isEmpty()) {
                groupid = parentGroupId;
            }
        }
        if (groupid != null && !groupid.isEmpty()) {
            dependency.getVendorEvidence().addEvidence("pom", "groupid", groupid, Confidence.HIGHEST);
            dependency.getProductEvidence().addEvidence("pom", "groupid", groupid, Confidence.LOW);
            if (parentGroupId != null && !parentGroupId.isEmpty() && !parentGroupId.equals(groupid)) {
                dependency.getVendorEvidence().addEvidence("pom", "parent-groupid", parentGroupId, Confidence.MEDIUM);
                dependency.getProductEvidence().addEvidence("pom", "parent-groupid", parentGroupId, Confidence.LOW);
            }
        }
        String artifactid = pom.getArtifactId();
        String parentArtifactId = null;
        if (pom.getParentArtifactId() != null) {
            parentArtifactId = pom.getParentArtifactId();
            if ((artifactid == null || artifactid.isEmpty()) && parentArtifactId != null && !parentArtifactId.isEmpty()) {
                artifactid = parentArtifactId;
            }
        }
        if (artifactid != null && !artifactid.isEmpty()) {
            if (artifactid.startsWith("org.") || artifactid.startsWith("com.")) {
                artifactid = artifactid.substring(4);
            }
            dependency.getProductEvidence().addEvidence("pom", "artifactid", artifactid, Confidence.HIGHEST);
            dependency.getVendorEvidence().addEvidence("pom", "artifactid", artifactid, Confidence.LOW);
            if (parentArtifactId != null && !parentArtifactId.isEmpty() && !parentArtifactId.equals(artifactid)) {
                dependency.getProductEvidence().addEvidence("pom", "parent-artifactid", parentArtifactId, Confidence.MEDIUM);
                dependency.getVendorEvidence().addEvidence("pom", "parent-artifactid", parentArtifactId, Confidence.LOW);
            }
        }
        String version = pom.getVersion();
        String parentVersion = null;
        if (pom.getParentVersion() != null) {
            parentVersion = pom.getParentVersion();
            if ((version == null || version.isEmpty()) && parentVersion != null && !parentVersion.isEmpty()) {
                version = parentVersion;
            }
        }
        if (version != null && !version.isEmpty()) {
            dependency.getVersionEvidence().addEvidence("pom", "version", version, Confidence.HIGHEST);
            if (parentVersion != null && !parentVersion.isEmpty() && !parentVersion.equals(version)) {
                dependency.getVersionEvidence().addEvidence("pom", "parent-version", version, Confidence.LOW);
            }
        }
        if ((orgName = pom.getOrganization()) != null && !orgName.isEmpty()) {
            dependency.getVendorEvidence().addEvidence("pom", "organization name", orgName, Confidence.HIGH);
        }
        if ((pomName = pom.getName()) != null && !pomName.isEmpty()) {
            dependency.getProductEvidence().addEvidence("pom", "name", pomName, Confidence.HIGH);
            dependency.getVendorEvidence().addEvidence("pom", "name", pomName, Confidence.HIGH);
        }
        if (pom.getDescription() != null && (description = pom.getDescription()) != null && !description.isEmpty()) {
            JarAnalyzer.addDescription(dependency, description, "pom", "description");
        }
        JarAnalyzer.extractLicense(pom, null, dependency);
    }
}

