/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.owasp.dependencycheck.utils.Filter;
import org.owasp.dependencycheck.utils.UrlStringUtils;

public class EvidenceCollection
implements Serializable,
Iterable<Evidence> {
    private static final Logger LOGGER = Logger.getLogger(EvidenceCollection.class.getName());
    private static final Filter<Evidence> HIGHEST_CONFIDENCE = new Filter<Evidence>(){

        @Override
        public boolean passes(Evidence evidence) {
            return evidence.getConfidence() == Confidence.HIGHEST;
        }
    };
    private static final Filter<Evidence> HIGH_CONFIDENCE = new Filter<Evidence>(){

        @Override
        public boolean passes(Evidence evidence) {
            return evidence.getConfidence() == Confidence.HIGH;
        }
    };
    private static final Filter<Evidence> MEDIUM_CONFIDENCE = new Filter<Evidence>(){

        @Override
        public boolean passes(Evidence evidence) {
            return evidence.getConfidence() == Confidence.MEDIUM;
        }
    };
    private static final Filter<Evidence> LOW_CONFIDENCE = new Filter<Evidence>(){

        @Override
        public boolean passes(Evidence evidence) {
            return evidence.getConfidence() == Confidence.LOW;
        }
    };
    private static final Filter<Evidence> EVIDENCE_USED = new Filter<Evidence>(){

        @Override
        public boolean passes(Evidence evidence) {
            return evidence.isUsed();
        }
    };
    private final Set<Evidence> list = new TreeSet<Evidence>();
    private final Set<String> weightedStrings = new HashSet<String>();

    public final Iterable<Evidence> iterator(Confidence confidence) {
        if (confidence == Confidence.HIGHEST) {
            return HIGHEST_CONFIDENCE.filter(this.list);
        }
        if (confidence == Confidence.HIGH) {
            return HIGH_CONFIDENCE.filter(this.list);
        }
        if (confidence == Confidence.MEDIUM) {
            return MEDIUM_CONFIDENCE.filter(this.list);
        }
        return LOW_CONFIDENCE.filter(this.list);
    }

    public void addEvidence(Evidence e) {
        this.list.add(e);
    }

    public void addEvidence(String source, String name, String value, Confidence confidence) {
        Evidence e = new Evidence(source, name, value, confidence);
        this.addEvidence(e);
    }

    public void addWeighting(String str) {
        this.weightedStrings.add(str);
    }

    public Set<String> getWeighting() {
        return this.weightedStrings;
    }

    public Set<Evidence> getEvidence() {
        return this.list;
    }

    public Set<Evidence> getEvidence(String source) {
        if (source == null) {
            return null;
        }
        HashSet<Evidence> ret = new HashSet<Evidence>();
        for (Evidence e : this.list) {
            if (!source.equals(e.getSource())) continue;
            ret.add(e);
        }
        return ret;
    }

    public Set<Evidence> getEvidence(String source, String name) {
        if (source == null || name == null) {
            return null;
        }
        HashSet<Evidence> ret = new HashSet<Evidence>();
        for (Evidence e : this.list) {
            if (!source.equals(e.getSource()) || !name.equals(e.getName())) continue;
            ret.add(e);
        }
        return ret;
    }

    @Override
    public Iterator<Evidence> iterator() {
        return this.list.iterator();
    }

    public boolean containsUsedString(String text) {
        if (text == null) {
            return false;
        }
        String textToTest = text.toLowerCase();
        for (Evidence e : EVIDENCE_USED.filter(this)) {
            String value = this.urlCorrection(e.getValue().toLowerCase()).replaceAll("[\\s_-]", "");
            if (!value.contains(textToTest)) continue;
            return true;
        }
        return false;
    }

    public boolean containsUsedVersion(DependencyVersion version) {
        if (version == null) {
            return false;
        }
        for (Evidence e : EVIDENCE_USED.filter(this)) {
            DependencyVersion value = DependencyVersionUtil.parseVersion(e.getValue());
            if (value == null || !value.matchesAtLeastThreeLevels(version)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Confidence confidence) {
        for (Evidence e : this.list) {
            if (!e.getConfidence().equals((Object)confidence)) continue;
            return true;
        }
        return false;
    }

    public static EvidenceCollection mergeUsed(EvidenceCollection ... ec) {
        EvidenceCollection ret = new EvidenceCollection();
        for (EvidenceCollection col : ec) {
            for (Evidence e : col.list) {
                if (!e.isUsed()) continue;
                ret.addEvidence(e);
            }
        }
        return ret;
    }

    public static EvidenceCollection merge(EvidenceCollection ... ec) {
        EvidenceCollection ret = new EvidenceCollection();
        for (EvidenceCollection col : ec) {
            ret.list.addAll(col.list);
            ret.weightedStrings.addAll(col.weightedStrings);
        }
        return ret;
    }

    public static Set<Evidence> mergeForDisplay(EvidenceCollection ... ec) {
        TreeSet<Evidence> ret = new TreeSet<Evidence>();
        for (EvidenceCollection col : ec) {
            for (Evidence e : col) {
                if (!e.isUsed()) continue;
                Evidence newEvidence = new Evidence(e.getSource(), e.getName(), e.getValue(), null);
                newEvidence.setUsed(true);
                ret.add(newEvidence);
            }
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Evidence e : this.list) {
            sb.append(e.getValue()).append(' ');
        }
        return sb.toString();
    }

    public int size() {
        return this.list.size();
    }

    private String urlCorrection(String value) {
        String[] parts;
        if (value == null || !UrlStringUtils.containsUrl(value)) {
            return value;
        }
        StringBuilder sb = new StringBuilder(value.length());
        for (String part : parts = value.split("\\s")) {
            if (UrlStringUtils.isUrl(part)) {
                try {
                    List<String> data = UrlStringUtils.extractImportantUrlData(part);
                    sb.append(' ').append(StringUtils.join(data, (char)' '));
                }
                catch (MalformedURLException ex) {
                    LOGGER.log(Level.FINE, "error parsing " + part, ex);
                    sb.append(' ').append(part);
                }
                continue;
            }
            sb.append(' ').append(part);
        }
        return sb.toString().trim();
    }
}

