/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.lucene;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.util.Version;
import org.owasp.dependencycheck.data.lucene.AlphaNumericTokenizer;
import org.owasp.dependencycheck.data.lucene.TokenPairConcatenatingFilter;
import org.owasp.dependencycheck.data.lucene.UrlTokenizingFilter;

public class SearchFieldAnalyzer
extends Analyzer {
    private final Version version;
    private TokenPairConcatenatingFilter concatenatingFilter;

    public SearchFieldAnalyzer(Version version) {
        this.version = version;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        AlphaNumericTokenizer source;
        Object stream = source = new AlphaNumericTokenizer(this.version, reader);
        stream = new WordDelimiterFilter((TokenStream)stream, 483, null);
        stream = new LowerCaseFilter(this.version, (TokenStream)stream);
        stream = new UrlTokenizingFilter((TokenStream)stream);
        this.concatenatingFilter = new TokenPairConcatenatingFilter((TokenStream)stream);
        stream = this.concatenatingFilter;
        stream = new StopFilter(this.version, (TokenStream)stream, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)stream);
    }

    public void clear() {
        if (this.concatenatingFilter != null) {
            this.concatenatingFilter.clear();
        }
    }
}

