/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Checksum {
    private static final String HEXES = "0123456789ABCDEF";

    private Checksum() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getChecksum(String algorithm, File file) throws NoSuchAlgorithmException, IOException {
        FileInputStream fis = null;
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance(algorithm);
        try {
            int numRead;
            fis = new FileInputStream(file);
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Checksum.class.getName()).log(Level.FINEST, "Error closing file '" + file.getName() + "'.", ex);
                }
            }
        }
        return complete.digest();
    }

    public static String getMD5Checksum(File file) throws IOException, NoSuchAlgorithmException {
        byte[] b = Checksum.getChecksum("MD5", file);
        return Checksum.getHex(b);
    }

    public static String getSHA1Checksum(File file) throws IOException, NoSuchAlgorithmException {
        byte[] b = Checksum.getChecksum("SHA1", file);
        return Checksum.getHex(b);
    }

    public static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }
}

