/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

class DriverShim
implements Driver {
    private final Driver driver;

    DriverShim(Driver driver) {
        this.driver = driver;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.driver.acceptsURL(url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.driver.connect(url, info);
    }

    @Override
    public int getMajorVersion() {
        return this.driver.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.driver.getMinorVersion();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        Method m = null;
        try {
            m = this.driver.getClass().getMethod("getParentLogger", new Class[0]);
        }
        catch (Throwable e) {
            throw new SQLFeatureNotSupportedException();
        }
        if (m != null) {
            try {
                return (Logger)m.invoke((Object)m, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(DriverShim.class.getName()).log(Level.FINER, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(DriverShim.class.getName()).log(Level.FINER, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(DriverShim.class.getName()).log(Level.FINER, null, ex);
            }
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.driver.getPropertyInfo(url, info);
    }

    @Override
    public boolean jdbcCompliant() {
        return this.driver.jdbcCompliant();
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.driver != null ? this.driver.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DriverShim other = (DriverShim)obj;
        return this.driver == other.driver || this.driver != null && this.driver.equals(other.driver);
    }

    public String toString() {
        return "DriverShim{driver=" + this.driver + '}';
    }
}

