/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.owasp.dependencycheck.utils.LogUtils;

public class DependencyBundlingAnalyzer
extends AbstractAnalyzer
implements Analyzer {
    private static final Pattern STARTING_TEXT_PATTERN = Pattern.compile("^[a-zA-Z]*");
    private boolean analyzed = false;
    private static final Set<String> EXTENSIONS = null;
    private static final String ANALYZER_NAME = "Dependency Bundling Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.PRE_FINDING_ANALYSIS;

    @Override
    public Set<String> getSupportedExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return true;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    public void analyze(Dependency ignore, Engine engine) throws AnalysisException {
        if (!this.analyzed) {
            this.analyzed = true;
            HashSet<Dependency> dependenciesToRemove = new HashSet<Dependency>();
            ListIterator<Dependency> mainIterator = engine.getDependencies().listIterator();
            while (mainIterator.hasNext()) {
                Dependency dependency = mainIterator.next();
                if (!mainIterator.hasNext()) continue;
                ListIterator<Dependency> subIterator = engine.getDependencies().listIterator(mainIterator.nextIndex());
                while (subIterator.hasNext()) {
                    Dependency nextDependency = subIterator.next();
                    if (this.isShadedJar(dependency, nextDependency)) {
                        if (dependency.getFileName().toLowerCase().endsWith("pom.xml")) {
                            dependenciesToRemove.add(dependency);
                            continue;
                        }
                        dependenciesToRemove.add(nextDependency);
                        continue;
                    }
                    if (this.hashesMatch(dependency, nextDependency)) {
                        if (this.isCore(dependency, nextDependency)) {
                            this.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
                            continue;
                        }
                        this.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
                        continue;
                    }
                    if (!this.cpeIdentifiersMatch(dependency, nextDependency) || !this.hasSameBasePath(dependency, nextDependency) || !this.fileNameMatch(dependency, nextDependency)) continue;
                    if (this.isCore(dependency, nextDependency)) {
                        this.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
                        continue;
                    }
                    this.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
                }
            }
            for (Dependency d : dependenciesToRemove) {
                engine.getDependencies().remove(d);
            }
        }
    }

    private void mergeDependencies(Dependency dependency, Dependency relatedDependency, Set<Dependency> dependenciesToRemove) {
        dependency.addRelatedDependency(relatedDependency);
        Iterator<Dependency> i = relatedDependency.getRelatedDependencies().iterator();
        while (i.hasNext()) {
            dependency.addRelatedDependency(i.next());
            i.remove();
        }
        dependenciesToRemove.add(relatedDependency);
    }

    private String getBaseRepoPath(String path) {
        int pos = path.indexOf("repository" + File.separator) + 11;
        if (pos < 0) {
            return path;
        }
        int tmp = path.indexOf(File.separator, pos);
        if (tmp <= 0) {
            return path;
        }
        if (tmp > 0) {
            pos = tmp + 1;
        }
        if ((tmp = path.indexOf(File.separator, pos)) > 0) {
            pos = tmp + 1;
        }
        return path.substring(0, pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean fileNameMatch(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency1.getFileName() == null || dependency2 == null || dependency2.getFileName() == null) {
            return false;
        }
        String fileName1 = dependency1.getFileName();
        String fileName2 = dependency2.getFileName();
        File one = new File(fileName1);
        File two = new File(fileName2);
        String oneParent = one.getParent();
        String twoParent = two.getParent();
        if (oneParent != null) {
            if (!oneParent.equals(twoParent)) return false;
            fileName1 = one.getName();
            fileName2 = two.getName();
        } else if (twoParent != null) {
            return false;
        }
        DependencyVersion version1 = DependencyVersionUtil.parseVersion(fileName1);
        DependencyVersion version2 = DependencyVersionUtil.parseVersion(fileName2);
        if (version1 != null && version2 != null && !version1.equals(version2)) {
            return false;
        }
        Matcher match1 = STARTING_TEXT_PATTERN.matcher(fileName1);
        Matcher match2 = STARTING_TEXT_PATTERN.matcher(fileName2);
        if (!match1.find() || !match2.find()) return false;
        return match1.group().equals(match2.group());
    }

    private boolean cpeIdentifiersMatch(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency1.getIdentifiers() == null || dependency2 == null || dependency2.getIdentifiers() == null) {
            return false;
        }
        boolean matches = false;
        int cpeCount1 = 0;
        int cpeCount2 = 0;
        for (Identifier i : dependency1.getIdentifiers()) {
            if (!"cpe".equals(i.getType())) continue;
            ++cpeCount1;
        }
        for (Identifier i : dependency2.getIdentifiers()) {
            if (!"cpe".equals(i.getType())) continue;
            ++cpeCount2;
        }
        if (cpeCount1 > 0 && cpeCount1 == cpeCount2) {
            for (Identifier i : dependency1.getIdentifiers()) {
                if (matches |= dependency2.getIdentifiers().contains(i)) continue;
                break;
            }
        }
        if (LogUtils.isVerboseLoggingEnabled()) {
            String msg = String.format("IdentifiersMatch=%s (%s, %s)", matches, dependency1.getFileName(), dependency2.getFileName());
            Logger.getLogger(DependencyBundlingAnalyzer.class.getName()).log(Level.FINE, msg);
        }
        return matches;
    }

    private boolean hasSameBasePath(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency2 == null) {
            return false;
        }
        File lFile = new File(dependency1.getFilePath());
        String left = lFile.getParent();
        File rFile = new File(dependency2.getFilePath());
        String right = rFile.getParent();
        if (left == null) {
            return right == null;
        }
        if (left.equalsIgnoreCase(right)) {
            return true;
        }
        if (left.matches(".*[/\\\\]repository[/\\\\].*") && right.matches(".*[/\\\\]repository[/\\\\].*")) {
            left = this.getBaseRepoPath(left);
            right = this.getBaseRepoPath(right);
        }
        if (left.equalsIgnoreCase(right)) {
            return true;
        }
        for (Dependency child : dependency2.getRelatedDependencies()) {
            if (!this.hasSameBasePath(dependency1, child)) continue;
            return true;
        }
        return false;
    }

    boolean isCore(Dependency left, Dependency right) {
        boolean returnVal;
        String leftName = left.getFileName().toLowerCase();
        String rightName = right.getFileName().toLowerCase();
        if (!rightName.matches(".*\\.(tar|tgz|gz|zip|ear|war).+") && leftName.matches(".*\\.(tar|tgz|gz|zip|ear|war).+") || rightName.contains("core") && !leftName.contains("core") || rightName.contains("kernel") && !leftName.contains("kernel")) {
            returnVal = false;
        } else if (rightName.matches(".*\\.(tar|tgz|gz|zip|ear|war).+") && !leftName.matches(".*\\.(tar|tgz|gz|zip|ear|war).+") || !rightName.contains("core") && leftName.contains("core") || !rightName.contains("kernel") && leftName.contains("kernel")) {
            returnVal = true;
        } else {
            boolean bl = returnVal = leftName.length() <= rightName.length();
        }
        if (LogUtils.isVerboseLoggingEnabled()) {
            String msg = String.format("IsCore=%s (%s, %s)", returnVal, left.getFileName(), right.getFileName());
            Logger.getLogger(DependencyBundlingAnalyzer.class.getName()).log(Level.FINE, msg);
        }
        return returnVal;
    }

    private boolean hashesMatch(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency2 == null || dependency1.getSha1sum() == null || dependency2.getSha1sum() == null) {
            return false;
        }
        return dependency1.getSha1sum().equals(dependency2.getSha1sum());
    }

    private boolean isShadedJar(Dependency dependency, Dependency nextDependency) {
        String mainName = dependency.getFileName().toLowerCase();
        String nextName = nextDependency.getFileName().toLowerCase();
        if (mainName.endsWith(".jar") && nextName.endsWith("pom.xml")) {
            return dependency.getIdentifiers().containsAll(nextDependency.getIdentifiers());
        }
        if (nextName.endsWith(".jar") && mainName.endsWith("pom.xml")) {
            return nextDependency.getIdentifiers().containsAll(dependency.getIdentifiers());
        }
        return false;
    }
}

