/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.suppression.SuppressionParseException;
import org.owasp.dependencycheck.suppression.SuppressionParser;
import org.owasp.dependencycheck.suppression.SuppressionRule;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.Settings;

public abstract class AbstractSuppressionAnalyzer
extends AbstractAnalyzer {
    private List<SuppressionRule> rules;

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return true;
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this.loadSuppressionData();
    }

    public List<SuppressionRule> getRules() {
        return this.rules;
    }

    public void setRules(List<SuppressionRule> rules) {
        this.rules = rules;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadSuppressionData() throws SuppressionParseException {
        String suppressionFilePath = Settings.getString("suppression.file");
        if (suppressionFilePath == null) {
            return;
        }
        File file = null;
        boolean deleteTempFile = false;
        try {
            Pattern uriRx = Pattern.compile("^(https?|file)\\:.*", 2);
            if (uriRx.matcher(suppressionFilePath).matches()) {
                deleteTempFile = true;
                file = FileUtils.getTempFile("suppression", "xml");
                URL url = new URL(suppressionFilePath);
                try {
                    Downloader.fetchFile(url, file, false);
                }
                catch (DownloadFailedException ex) {
                    Downloader.fetchFile(url, file, true);
                }
            }
            if (file != null) {
                SuppressionParser parser = new SuppressionParser();
                try {
                    this.rules = parser.parseSuppressionRules(file);
                }
                catch (SuppressionParseException ex) {
                    String msg = String.format("Unable to parse suppression xml file '%s'", file.getPath());
                    Logger.getLogger(AbstractSuppressionAnalyzer.class.getName()).log(Level.WARNING, msg);
                    Logger.getLogger(AbstractSuppressionAnalyzer.class.getName()).log(Level.WARNING, ex.getMessage());
                    Logger.getLogger(AbstractSuppressionAnalyzer.class.getName()).log(Level.FINE, null, ex);
                    throw ex;
                }
            }
            if (!deleteTempFile) return;
            if (file == null) return;
        }
        catch (DownloadFailedException ex) {
            try {
                Logger.getLogger(AbstractSuppressionAnalyzer.class.getName()).log(Level.WARNING, "Unable to fetch the configured suppression file");
                Logger.getLogger(AbstractSuppressionAnalyzer.class.getName()).log(Level.FINE, "", ex);
                throw new SuppressionParseException("Unable to fetch the configured suppression file", ex);
                catch (MalformedURLException ex2) {
                    Logger.getLogger(AbstractSuppressionAnalyzer.class.getName()).log(Level.WARNING, "Configured suppression file has an invalid URL");
                    Logger.getLogger(AbstractSuppressionAnalyzer.class.getName()).log(Level.FINE, "", ex2);
                    throw new SuppressionParseException("Configured suppression file has an invalid URL", ex2);
                }
                catch (IOException ex3) {
                    Logger.getLogger(AbstractSuppressionAnalyzer.class.getName()).log(Level.WARNING, "Unable to create temp file for suppressions");
                    Logger.getLogger(AbstractSuppressionAnalyzer.class.getName()).log(Level.FINE, "", ex3);
                    throw new SuppressionParseException("Unable to create temp file for suppressions", ex3);
                }
            }
            catch (Throwable throwable) {
                if (!deleteTempFile) throw throwable;
                if (file == null) throw throwable;
                FileUtils.delete(file);
                throw throwable;
            }
        }
        FileUtils.delete(file);
    }
}

