/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.reporting;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.ToolManager;
import org.apache.velocity.tools.config.EasyFactoryConfiguration;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.reporting.VelocityLoggerRedirect;
import org.owasp.dependencycheck.utils.Settings;

public class ReportGenerator {
    private final VelocityEngine engine = this.createVelocityEngine();
    private final Context context = this.createContext();

    public ReportGenerator(String applicationName, List<Dependency> dependencies, List<Analyzer> analyzers, DatabaseProperties properties) {
        this.engine.init();
        this.context.put("applicationName", (Object)applicationName);
        this.context.put("dependencies", dependencies);
        this.context.put("analyzers", analyzers);
        this.context.put("properties", (Object)properties);
        this.context.put("version", (Object)Settings.getString("application.version", "Unknown"));
    }

    private VelocityEngine createVelocityEngine() {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("runtime.log.logsystem.class", (Object)VelocityLoggerRedirect.class.getName());
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        return ve;
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"}, justification="No plan to fix this style issue")
    private Context createContext() {
        ToolManager manager = new ToolManager();
        ToolContext c = manager.createContext();
        EasyFactoryConfiguration config = new EasyFactoryConfiguration();
        config.addDefaultTools();
        config.toolbox("application").tool("esc", "org.apache.velocity.tools.generic.EscapeTool").tool("org.apache.velocity.tools.generic.DateTool");
        manager.configure((FactoryConfiguration)config);
        return c;
    }

    public void generateReports(String outputDir, Format format) throws IOException, Exception {
        if (format == Format.XML || format == Format.ALL) {
            this.generateReport("XmlReport", outputDir + File.separator + "DependencyCheck-Report.xml");
        }
        if (format == Format.HTML || format == Format.ALL) {
            this.generateReport("HtmlReport", outputDir + File.separator + "DependencyCheck-Report.html");
        }
        if (format == Format.VULN || format == Format.ALL) {
            this.generateReport("VulnerabilityReport", outputDir + File.separator + "DependencyCheck-Vulnerability.html");
        }
    }

    public void generateReports(String outputDir, String outputFormat) throws IOException, Exception {
        String format = outputFormat.toUpperCase();
        if (format.matches("^(XML|HTML|VULN|ALL)$")) {
            if ("XML".equalsIgnoreCase(format)) {
                this.generateReports(outputDir, Format.XML);
            }
            if ("HTML".equalsIgnoreCase(format)) {
                this.generateReports(outputDir, Format.HTML);
            }
            if ("VULN".equalsIgnoreCase(format)) {
                this.generateReports(outputDir, Format.VULN);
            }
            if ("ALL".equalsIgnoreCase(format)) {
                this.generateReports(outputDir, Format.ALL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateReport(String templateName, String outFileName) throws IOException, Exception {
        InputStream input = null;
        String templatePath = null;
        File f = new File(templateName);
        if (f.exists() && f.isFile()) {
            try {
                templatePath = templateName;
                input = new FileInputStream(f);
            }
            catch (FileNotFoundException ex) {
                String msg = "Unable to generate the report, the report template file could not be found.";
                Logger.getLogger(ReportGenerator.class.getName()).log(Level.SEVERE, "Unable to generate the report, the report template file could not be found.");
                Logger.getLogger(ReportGenerator.class.getName()).log(Level.FINE, null, ex);
            }
        } else {
            templatePath = "templates/" + templateName + ".vsl";
            input = this.getClass().getClassLoader().getResourceAsStream(templatePath);
        }
        if (input == null) {
            throw new IOException("Template file doesn't exist");
        }
        InputStreamReader reader = new InputStreamReader(input, "UTF-8");
        OutputStreamWriter writer = null;
        OutputStream outputStream = null;
        try {
            boolean created;
            File outDir = new File(outFileName).getParentFile();
            if (!outDir.exists() && !(created = outDir.mkdirs())) {
                throw new Exception("Unable to create directory '" + outDir.getAbsolutePath() + "'.");
            }
            outputStream = new FileOutputStream(outFileName);
            writer = new OutputStreamWriter(outputStream, "UTF-8");
            if (!this.engine.evaluate(this.context, (Writer)writer, templatePath, (Reader)reader)) {
                throw new Exception("Failed to convert the template into html.");
            }
            writer.flush();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ReportGenerator.class.getName()).log(Level.FINEST, null, ex);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ReportGenerator.class.getName()).log(Level.FINEST, null, ex);
                }
            }
            try {
                reader.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ReportGenerator.class.getName()).log(Level.FINEST, null, ex);
            }
        }
    }

    public static enum Format {
        ALL,
        XML,
        HTML,
        VULN;

    }
}

