/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.task;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.StandardUpdate;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.data.update.task.CallableDownloadTask;
import org.owasp.dependencycheck.data.update.xml.NvdCve12Handler;
import org.owasp.dependencycheck.data.update.xml.NvdCve20Handler;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProcessTask
implements Callable<ProcessTask> {
    private UpdateException exception = null;
    private final CveDB cveDB;
    private final CallableDownloadTask filePair;
    private final DatabaseProperties properties;

    public UpdateException getException() {
        return this.exception;
    }

    public void setException(UpdateException exception) {
        this.exception = exception;
    }

    public ProcessTask(CveDB cveDB, CallableDownloadTask filePair) {
        this.cveDB = cveDB;
        this.filePair = filePair;
        this.properties = cveDB.getDatabaseProperties();
    }

    @Override
    public ProcessTask call() throws Exception {
        try {
            this.processFiles();
        }
        catch (UpdateException ex) {
            this.exception = ex;
        }
        return this;
    }

    protected void importXML(File file, File oldVersion) throws ParserConfigurationException, SAXException, IOException, SQLException, DatabaseException, ClassNotFoundException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        NvdCve12Handler cve12Handler = new NvdCve12Handler();
        saxParser.parse(oldVersion, (DefaultHandler)cve12Handler);
        Map<String, List<VulnerableSoftware>> prevVersionVulnMap = cve12Handler.getVulnerabilities();
        NvdCve20Handler cve20Handler = new NvdCve20Handler();
        cve20Handler.setCveDB(this.cveDB);
        cve20Handler.setPrevVersionVulnMap(prevVersionVulnMap);
        saxParser.parse(file, (DefaultHandler)cve20Handler);
    }

    private void processFiles() throws UpdateException {
        String msg = String.format("Processing Started for NVD CVE - %s", this.filePair.getNvdCveInfo().getId());
        Logger.getLogger(StandardUpdate.class.getName()).log(Level.INFO, msg);
        try {
            this.importXML(this.filePair.getFirst(), this.filePair.getSecond());
            this.cveDB.commit();
            this.properties.save(this.filePair.getNvdCveInfo());
        }
        catch (FileNotFoundException ex) {
            throw new UpdateException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new UpdateException(ex);
        }
        catch (SAXException ex) {
            throw new UpdateException(ex);
        }
        catch (IOException ex) {
            throw new UpdateException(ex);
        }
        catch (SQLException ex) {
            throw new UpdateException(ex);
        }
        catch (DatabaseException ex) {
            throw new UpdateException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new UpdateException(ex);
        }
        finally {
            this.filePair.cleanup();
        }
        msg = String.format("Processing Complete for NVD CVE - %s", this.filePair.getNvdCveInfo().getId());
        Logger.getLogger(StandardUpdate.class.getName()).log(Level.INFO, msg);
    }
}

