/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.data.UpdateException;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.InvalidDataException;
import org.owasp.dependencycheck.data.update.CallableDownloadTask;
import org.owasp.dependencycheck.data.update.DataStoreMetaInfo;
import org.owasp.dependencycheck.data.update.NvdCveInfo;
import org.owasp.dependencycheck.data.update.ProcessTask;
import org.owasp.dependencycheck.data.update.Updateable;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;

public class StandardUpdate {
    public static final int MAX_THREAD_POOL_SIZE = Settings.getInt("max.download.threads", 3);
    private DataStoreMetaInfo properties = new DataStoreMetaInfo();
    private Updateable updateable = this.updatesNeeded();
    private boolean deleteAndRecreate = false;
    private CveDB cveDB = null;

    public boolean isUpdateNeeded() {
        return this.updateable.isUpdateNeeded();
    }

    protected void setDeleteAndRecreate(boolean deleteAndRecreate) {
        this.deleteAndRecreate = deleteAndRecreate;
    }

    public boolean shouldDeleteAndRecreate() {
        return this.deleteAndRecreate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws UpdateException {
        int maxUpdates = 0;
        try {
            for (NvdCveInfo cve : this.updateable) {
                if (!cve.getNeedsUpdate()) continue;
                ++maxUpdates;
            }
            if (maxUpdates <= 0) {
                return;
            }
            if (maxUpdates > 3) {
                Logger.getLogger(StandardUpdate.class.getName()).log(Level.INFO, "NVD CVE requires several updates; this could take a couple of minutes.");
            }
            if (maxUpdates > 0) {
                this.openDataStores();
            }
            int poolSize = MAX_THREAD_POOL_SIZE > maxUpdates ? MAX_THREAD_POOL_SIZE : maxUpdates;
            ExecutorService downloadExecutor = Executors.newFixedThreadPool(poolSize);
            ExecutorService processExecutor = Executors.newSingleThreadExecutor();
            HashSet<Future<CallableDownloadTask>> downloadFutures = new HashSet<Future<CallableDownloadTask>>(maxUpdates);
            HashSet<Future<ProcessTask>> processFutures = new HashSet<Future<ProcessTask>>(maxUpdates);
            int ctr = 0;
            for (NvdCveInfo nvdCveInfo : this.updateable) {
                File file2;
                File file1;
                if (!nvdCveInfo.getNeedsUpdate()) continue;
                ++ctr;
                try {
                    file1 = File.createTempFile("cve" + nvdCveInfo.getId() + "_", ".xml");
                    file2 = File.createTempFile("cve_1_2_" + nvdCveInfo.getId() + "_", ".xml");
                }
                catch (IOException ex) {
                    throw new UpdateException(ex);
                }
                CallableDownloadTask call = new CallableDownloadTask(nvdCveInfo, file1, file2);
                downloadFutures.add(downloadExecutor.submit(call));
                boolean waitForFuture = ctr % 2 == 0;
                Iterator itr = downloadFutures.iterator();
                while (itr.hasNext()) {
                    Future future = (Future)itr.next();
                    if (waitForFuture) {
                        this.spinWaitForFuture(future);
                    }
                    if (!future.isDone()) continue;
                    try {
                        CallableDownloadTask filePair = (CallableDownloadTask)future.get();
                        itr.remove();
                        ProcessTask task = new ProcessTask(this.cveDB, this.properties, filePair);
                        processFutures.add(processExecutor.submit(task));
                    }
                    catch (InterruptedException ex) {
                        downloadExecutor.shutdownNow();
                        Logger.getLogger(StandardUpdate.class.getName()).log(Level.FINE, "Thread was interupted", ex);
                        throw new UpdateException(ex);
                    }
                    catch (ExecutionException ex) {
                        downloadExecutor.shutdownNow();
                        Logger.getLogger(StandardUpdate.class.getName()).log(Level.SEVERE, null, ex);
                        throw new UpdateException(ex);
                    }
                }
            }
            try {
                for (Future future : downloadFutures) {
                    CallableDownloadTask filePair = (CallableDownloadTask)future.get();
                    ProcessTask task = new ProcessTask(this.cveDB, this.properties, filePair);
                    processFutures.add(processExecutor.submit(task));
                }
            }
            catch (InterruptedException ex) {
                downloadExecutor.shutdownNow();
                Logger.getLogger(StandardUpdate.class.getName()).log(Level.FINE, "Thread was interupted during download", ex);
                throw new UpdateException(ex);
            }
            catch (ExecutionException ex) {
                downloadExecutor.shutdownNow();
                Logger.getLogger(StandardUpdate.class.getName()).log(Level.FINE, "Execution Exception during download", ex);
                throw new UpdateException(ex);
            }
            finally {
                downloadExecutor.shutdown();
            }
            for (Future future : processFutures) {
                try {
                    ProcessTask task = (ProcessTask)future.get();
                    if (task.getException() == null) continue;
                    throw task.getException();
                }
                catch (InterruptedException ex) {
                    processExecutor.shutdownNow();
                    Logger.getLogger(StandardUpdate.class.getName()).log(Level.FINE, "Thread was interupted during processing", ex);
                    throw new UpdateException(ex);
                }
                catch (ExecutionException ex) {
                    processExecutor.shutdownNow();
                    Logger.getLogger(StandardUpdate.class.getName()).log(Level.FINE, "Execution Exception during process", ex);
                    throw new UpdateException(ex);
                }
                finally {
                    processExecutor.shutdown();
                }
            }
            if (maxUpdates >= 1) {
                this.properties.save(this.updateable.get("modified"));
                this.cveDB.cleanupDatabase();
            }
        }
        finally {
            this.closeDataStores();
        }
    }

    protected final Updateable updatesNeeded() throws MalformedURLException, DownloadFailedException, UpdateException {
        Updateable updates;
        block21: {
            updates = null;
            try {
                updates = this.retrieveCurrentTimestampsFromWeb();
            }
            catch (InvalidDataException ex) {
                String msg = "Unable to retrieve valid timestamp from nvd cve downloads page";
                Logger.getLogger(StandardUpdate.class.getName()).log(Level.FINE, "Unable to retrieve valid timestamp from nvd cve downloads page", ex);
                throw new DownloadFailedException("Unable to retrieve valid timestamp from nvd cve downloads page", ex);
            }
            catch (InvalidSettingException ex) {
                Logger.getLogger(StandardUpdate.class.getName()).log(Level.FINE, "Invalid setting found when retrieving timestamps", ex);
                throw new DownloadFailedException("Invalid settings", ex);
            }
            if (updates == null) {
                throw new DownloadFailedException("Unable to retrieve the timestamps of the currently published NVD CVE data");
            }
            if (!this.properties.isEmpty()) {
                try {
                    if (this.properties.getProperty("version") == null) {
                        this.deleteAndRecreate = true;
                    } else {
                        try {
                            float version = Float.parseFloat(this.properties.getProperty("version"));
                            float currentVersion = Float.parseFloat("2.7");
                            if (currentVersion > version) {
                                this.deleteAndRecreate = true;
                            }
                        }
                        catch (NumberFormatException ex) {
                            this.deleteAndRecreate = true;
                        }
                    }
                    if (this.deleteAndRecreate) {
                        return updates;
                    }
                    long lastUpdated = Long.parseLong(this.properties.getProperty("lastupdated.modified", "0"));
                    Date now = new Date();
                    int days = Settings.getInt("cve.url.modified.validfordays", 7);
                    if (lastUpdated == updates.getTimeStamp("modified")) {
                        updates.clear();
                        break block21;
                    }
                    if (this.withinRange(lastUpdated, now.getTime(), days)) {
                        for (NvdCveInfo entry : updates) {
                            if ("modified".equals(entry.getId())) {
                                entry.setNeedsUpdate(true);
                                continue;
                            }
                            entry.setNeedsUpdate(false);
                        }
                        break block21;
                    }
                    for (NvdCveInfo entry : updates) {
                        if ("modified".equals(entry.getId())) {
                            entry.setNeedsUpdate(true);
                            continue;
                        }
                        long currentTimestamp = 0L;
                        try {
                            currentTimestamp = Long.parseLong(this.properties.getProperty("lastupdated." + entry.getId(), "0"));
                        }
                        catch (NumberFormatException ex) {
                            String msg = String.format("Error parsing '%s' '%s' from nvdcve.lastupdated", "lastupdated.", entry.getId());
                            Logger.getLogger(StandardUpdate.class.getName()).log(Level.FINE, msg, ex);
                        }
                        if (currentTimestamp != entry.getTimestamp()) continue;
                        entry.setNeedsUpdate(false);
                    }
                }
                catch (NumberFormatException ex) {
                    String msg = "An invalid schema version or timestamp exists in the data.properties file.";
                    Logger.getLogger(StandardUpdate.class.getName()).log(Level.WARNING, "An invalid schema version or timestamp exists in the data.properties file.");
                    Logger.getLogger(StandardUpdate.class.getName()).log(Level.FINE, null, ex);
                }
            }
        }
        return updates;
    }

    private Updateable retrieveCurrentTimestampsFromWeb() throws MalformedURLException, DownloadFailedException, InvalidDataException, InvalidSettingException {
        Updateable updates = new Updateable();
        updates.add("modified", Settings.getString("cve.url-2.0.modified"), Settings.getString("cve.url-1.2.modified"), false);
        int start = Settings.getInt("cve.startyear");
        int end = Calendar.getInstance().get(1);
        String baseUrl20 = Settings.getString("cve.url-2.0.base");
        String baseUrl12 = Settings.getString("cve.url-1.2.base");
        for (int i = start; i <= end; ++i) {
            updates.add(Integer.toString(i), String.format(baseUrl20, i), String.format(baseUrl12, i), true);
        }
        return updates;
    }

    protected void deleteExistingData() throws IOException {
        File data = Settings.getDataFile("data.cve");
        if (data.exists()) {
            FileUtils.delete(data);
        }
        if ((data = DataStoreMetaInfo.getPropertiesFile()).exists()) {
            FileUtils.delete(data);
        }
    }

    protected void closeDataStores() {
        if (this.cveDB != null) {
            try {
                this.cveDB.close();
            }
            catch (Exception ignore) {
                Logger.getLogger(StandardUpdate.class.getName()).log(Level.FINEST, "Error closing the cveDB", ignore);
            }
        }
    }

    protected void openDataStores() throws UpdateException {
        try {
            this.cveDB = new CveDB();
            this.cveDB.open();
        }
        catch (IOException ex) {
            this.closeDataStores();
            Logger.getLogger(StandardUpdate.class.getName()).log(Level.FINE, "IO Error opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
        catch (SQLException ex) {
            this.closeDataStores();
            Logger.getLogger(StandardUpdate.class.getName()).log(Level.FINE, "SQL Exception opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
        catch (DatabaseException ex) {
            this.closeDataStores();
            Logger.getLogger(StandardUpdate.class.getName()).log(Level.FINE, "Database Exception opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
        catch (ClassNotFoundException ex) {
            this.closeDataStores();
            Logger.getLogger(StandardUpdate.class.getName()).log(Level.FINE, "Class not found exception opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
    }

    protected boolean withinRange(long date, long compareTo, int range) {
        double differenceInDays = (double)(compareTo - date) / 1000.0 / 60.0 / 60.0 / 24.0;
        return differenceInDays < (double)range;
    }

    private void spinWaitForFuture(Future<CallableDownloadTask> future) {
        while (!future.isDone()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(StandardUpdate.class.getName()).log(Level.FINE, null, ex);
            }
        }
    }
}

