/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.utils.Settings;

public class BaseDB {
    public static final String DB_STRUCTURE_RESOURCE = "data/initialize.sql";
    public static final String DB_SCHEMA_VERSION = "2.7";
    private Connection conn;

    protected Connection getConnection() {
        return this.conn;
    }

    @SuppressWarnings(value={"DMI_EMPTY_DB_PASSWORD"}, justification="Yes, I know... Blank password.")
    public void open() throws IOException, SQLException, DatabaseException, ClassNotFoundException {
        String fileName = CveDB.getDataDirectory().getCanonicalPath();
        File f = new File(fileName, "cve.2.7");
        File check = new File(f.getAbsolutePath() + ".h2.db");
        boolean createTables = !check.exists();
        String connStr = String.format("jdbc:h2:file:%s;AUTO_SERVER=TRUE", f.getAbsolutePath());
        Class.forName("org.h2.Driver");
        this.conn = DriverManager.getConnection(connStr, "sa", "");
        if (createTables) {
            this.createTables();
        }
    }

    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException ex) {
                String msg = "There was an error attempting to close the CveDB, see the log for more details.";
                Logger.getLogger(BaseDB.class.getName()).log(Level.SEVERE, "There was an error attempting to close the CveDB, see the log for more details.", ex);
                Logger.getLogger(BaseDB.class.getName()).log(Level.FINE, null, ex);
            }
            this.conn = null;
        }
    }

    public void commit() throws SQLException {
        if (this.conn != null) {
            this.conn.commit();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTables() throws SQLException, DatabaseException {
        BufferedReader in = null;
        try {
            String tmp;
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(DB_STRUCTURE_RESOURCE);
            InputStreamReader reader = new InputStreamReader(is, "UTF-8");
            in = new BufferedReader(reader);
            StringBuilder sb = new StringBuilder(2110);
            while ((tmp = in.readLine()) != null) {
                sb.append(tmp);
            }
            Statement statement = null;
            try {
                statement = this.conn.createStatement();
                statement.execute(sb.toString());
            }
            finally {
                this.closeStatement(statement);
            }
        }
        catch (IOException ex) {
            throw new DatabaseException("Unable to create database schema", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(CveDB.class.getName()).log(Level.FINEST, null, ex);
                }
            }
        }
    }

    public static File getDataDirectory() throws IOException {
        File path = Settings.getDataFile("data.cve");
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("Unable to create NVD CVE Data directory");
        }
        return path;
    }

    protected int getGeneratedKey(PreparedStatement statement) throws DatabaseException {
        ResultSet rs = null;
        int id = 0;
        try {
            rs = statement.getGeneratedKeys();
            rs.next();
            id = rs.getInt(1);
        }
        catch (SQLException ex) {
            throw new DatabaseException("Unable to get primary key for inserted row");
        }
        finally {
            this.closeResultSet(rs);
        }
        return id;
    }

    public void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(CveDB.class.getName()).log(Level.FINEST, statement.toString(), ex);
            }
        }
    }

    public void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(CveDB.class.getName()).log(Level.FINEST, rs.toString(), ex);
            }
        }
    }
}

