/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.owasp.dependencycheck.data.UpdateException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.InvalidDataException;
import org.owasp.dependencycheck.data.update.AbstractUpdateTask;
import org.owasp.dependencycheck.data.update.CallableDownloadTask;
import org.owasp.dependencycheck.data.update.DataStoreMetaInfo;
import org.owasp.dependencycheck.data.update.NvdCveInfo;
import org.owasp.dependencycheck.data.update.Updateable;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.xml.sax.SAXException;

public class StandardUpdateTask
extends AbstractUpdateTask {
    public static final int MAX_THREAD_POOL_SIZE = Settings.getInt("max.download.threads", 3);

    public StandardUpdateTask(DataStoreMetaInfo properties) throws MalformedURLException, DownloadFailedException, UpdateException {
        super(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws UpdateException {
        int maxUpdates = 0;
        try {
            for (NvdCveInfo cve : this.getUpdateable()) {
                if (!cve.getNeedsUpdate()) continue;
                ++maxUpdates;
            }
            if (maxUpdates <= 0) {
                return;
            }
            if (maxUpdates > 3) {
                Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.INFO, "NVD CVE requires several updates; this could take a couple of minutes.");
            }
            if (maxUpdates > 0) {
                this.openDataStores();
            }
            int poolSize = MAX_THREAD_POOL_SIZE > maxUpdates ? MAX_THREAD_POOL_SIZE : maxUpdates;
            ExecutorService executorService = Executors.newFixedThreadPool(poolSize);
            HashSet<Future<CallableDownloadTask>> futures = new HashSet<Future<CallableDownloadTask>>(maxUpdates);
            for (NvdCveInfo nvdCveInfo : this.getUpdateable()) {
                File file2;
                File file1;
                if (!nvdCveInfo.getNeedsUpdate()) continue;
                try {
                    file1 = File.createTempFile("cve" + nvdCveInfo.getId() + "_", ".xml");
                    file2 = File.createTempFile("cve_1_2_" + nvdCveInfo.getId() + "_", ".xml");
                }
                catch (IOException ex) {
                    throw new UpdateException(ex);
                }
                CallableDownloadTask call = new CallableDownloadTask(nvdCveInfo, file1, file2);
                futures.add(executorService.submit(call));
            }
            try {
                for (Future future : futures) {
                    CallableDownloadTask filePair = (CallableDownloadTask)future.get();
                    String msg = String.format("Processing Started for NVD CVE - %s", filePair.getNvdCveInfo().getId());
                    Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.INFO, msg);
                    try {
                        this.importXML(filePair.getFirst(), filePair.getSecond());
                        this.getCveDB().commit();
                        this.getProperties().save(filePair.getNvdCveInfo());
                    }
                    catch (FileNotFoundException ex) {
                        throw new UpdateException(ex);
                    }
                    catch (ParserConfigurationException ex) {
                        throw new UpdateException(ex);
                    }
                    catch (SAXException ex) {
                        throw new UpdateException(ex);
                    }
                    catch (IOException ex) {
                        throw new UpdateException(ex);
                    }
                    catch (SQLException ex) {
                        throw new UpdateException(ex);
                    }
                    catch (DatabaseException ex) {
                        throw new UpdateException(ex);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new UpdateException(ex);
                    }
                    finally {
                        filePair.cleanup();
                    }
                    msg = String.format("Processing Complete for NVD CVE - %s", filePair.getNvdCveInfo().getId());
                    Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.INFO, msg);
                }
            }
            catch (InterruptedException ex) {
                executorService.shutdownNow();
                Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.FINE, "Thread was interupted", ex);
                throw new UpdateException(ex);
            }
            catch (ExecutionException ex) {
                executorService.shutdownNow();
                Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.SEVERE, null, ex);
                throw new UpdateException(ex);
            }
            finally {
                executorService.shutdown();
            }
            if (maxUpdates >= 1) {
                this.getProperties().save(this.getUpdateable().get("modified"));
                this.getCveDB().cleanupDatabase();
            }
        }
        finally {
            this.closeDataStores();
        }
    }

    @Override
    protected Updateable updatesNeeded() throws MalformedURLException, DownloadFailedException, UpdateException {
        Updateable updates;
        block21: {
            updates = null;
            try {
                updates = this.retrieveCurrentTimestampsFromWeb();
            }
            catch (InvalidDataException ex) {
                String msg = "Unable to retrieve valid timestamp from nvd cve downloads page";
                Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.FINE, "Unable to retrieve valid timestamp from nvd cve downloads page", ex);
                throw new DownloadFailedException("Unable to retrieve valid timestamp from nvd cve downloads page", ex);
            }
            catch (InvalidSettingException ex) {
                Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.FINE, "Invalid setting found when retrieving timestamps", ex);
                throw new DownloadFailedException("Invalid settings", ex);
            }
            if (updates == null) {
                throw new DownloadFailedException("Unable to retrieve the timestamps of the currently published NVD CVE data");
            }
            DataStoreMetaInfo properties = this.getProperties();
            if (!properties.isEmpty()) {
                try {
                    if (properties.getProperty("version") == null) {
                        this.setDeleteAndRecreate(true);
                    } else {
                        try {
                            float version = Float.parseFloat(properties.getProperty("version"));
                            float currentVersion = Float.parseFloat("2.7");
                            if (currentVersion > version) {
                                this.setDeleteAndRecreate(true);
                            }
                        }
                        catch (NumberFormatException ex) {
                            this.setDeleteAndRecreate(true);
                        }
                    }
                    if (this.shouldDeleteAndRecreate()) {
                        return updates;
                    }
                    long lastUpdated = Long.parseLong(properties.getProperty("lastupdated.modified", "0"));
                    Date now = new Date();
                    int days = Settings.getInt("cve.url.modified.validfordays", 7);
                    if (lastUpdated == updates.getTimeStamp("modified")) {
                        updates.clear();
                        break block21;
                    }
                    if (this.withinRange(lastUpdated, now.getTime(), days)) {
                        for (NvdCveInfo entry : updates) {
                            if ("modified".equals(entry.getId())) {
                                entry.setNeedsUpdate(true);
                                continue;
                            }
                            entry.setNeedsUpdate(false);
                        }
                        break block21;
                    }
                    for (NvdCveInfo entry : updates) {
                        if ("modified".equals(entry.getId())) {
                            entry.setNeedsUpdate(true);
                            continue;
                        }
                        long currentTimestamp = 0L;
                        try {
                            currentTimestamp = Long.parseLong(properties.getProperty("lastupdated." + entry.getId(), "0"));
                        }
                        catch (NumberFormatException ex) {
                            String msg = String.format("Error parsing '%s' '%s' from nvdcve.lastupdated", "lastupdated.", entry.getId());
                            Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.FINE, msg, ex);
                        }
                        if (currentTimestamp != entry.getTimestamp()) continue;
                        entry.setNeedsUpdate(false);
                    }
                }
                catch (NumberFormatException ex) {
                    String msg = "An invalid schema version or timestamp exists in the data.properties file.";
                    Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.WARNING, "An invalid schema version or timestamp exists in the data.properties file.");
                    Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.FINE, null, ex);
                }
            }
        }
        return updates;
    }

    private Updateable retrieveCurrentTimestampsFromWeb() throws MalformedURLException, DownloadFailedException, InvalidDataException, InvalidSettingException {
        Updateable updates = new Updateable();
        updates.add("modified", Settings.getString("cve.url-2.0.modified"), Settings.getString("cve.url-1.2.modified"), false);
        int start = Settings.getInt("cve.startyear");
        int end = Calendar.getInstance().get(1);
        String baseUrl20 = Settings.getString("cve.url-2.0.base");
        String baseUrl12 = Settings.getString("cve.url-1.2.base");
        for (int i = start; i <= end; ++i) {
            updates.add(Integer.toString(i), String.format(baseUrl20, i), String.format(baseUrl12, i), true);
        }
        return updates;
    }
}

