/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.lucene;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class TokenPairConcatenatingFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private String previousWord;
    private final LinkedList<String> words = new LinkedList();

    protected String getPreviousWord() {
        return this.previousWord;
    }

    protected LinkedList<String> getWords() {
        return this.words;
    }

    public TokenPairConcatenatingFilter(TokenStream stream) {
        super(stream);
    }

    public boolean incrementToken() throws IOException {
        String word;
        while (this.input.incrementToken()) {
            word = new String(this.termAtt.buffer(), 0, this.termAtt.length());
            this.words.add(word);
        }
        if (this.previousWord != null && this.words.size() > 0) {
            word = this.words.getFirst();
            this.clearAttributes();
            this.termAtt.append(this.previousWord).append(word);
            this.previousWord = null;
            return true;
        }
        if (this.words.size() > 0) {
            word = this.words.removeFirst();
            this.clearAttributes();
            this.termAtt.append(word);
            this.previousWord = word;
            return true;
        }
        return false;
    }

    public void clear() {
        this.previousWord = null;
        this.words.clear();
    }
}

