/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Settings;

public final class Downloader {
    private Downloader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fetchFile(URL url, File outputPath) throws DownloadFailedException {
        HttpURLConnection conn = null;
        try {
            conn = Downloader.getConnection(url);
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
            conn.connect();
        }
        catch (IOException ex) {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            finally {
                conn = null;
            }
            throw new DownloadFailedException("Error downloading file.", ex);
        }
        String encoding = conn.getContentEncoding();
        FilterOutputStream writer = null;
        InputStream reader = null;
        try {
            int bytesRead;
            reader = encoding != null && "gzip".equalsIgnoreCase(encoding) ? new GZIPInputStream(conn.getInputStream()) : (encoding != null && "deflate".equalsIgnoreCase(encoding) ? new InflaterInputStream(conn.getInputStream()) : conn.getInputStream());
            writer = new BufferedOutputStream(new FileOutputStream(outputPath));
            byte[] buffer = new byte[4096];
            while ((bytesRead = reader.read(buffer)) > 0) {
                ((BufferedOutputStream)writer).write(buffer, 0, bytesRead);
            }
        }
        catch (Exception ex) {
            throw new DownloadFailedException("Error saving downloaded file.", ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    Logger.getLogger(Downloader.class.getName()).log(Level.FINEST, "Error closing the writer in Downloader.", ex);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {
                    Logger.getLogger(Downloader.class.getName()).log(Level.FINEST, "Error closing the reader in Downloader.", ex);
                }
            }
            try {
                conn.disconnect();
            }
            finally {
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModified(URL url) throws DownloadFailedException {
        long timestamp = 0L;
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            File lastModifiedFile;
            try {
                lastModifiedFile = new File(url.toURI());
            }
            catch (URISyntaxException ex) {
                String msg = String.format("Unable to locate '%s'; is the cve.url-2.0.modified property set correctly?", url.toString());
                throw new DownloadFailedException(msg);
            }
            timestamp = lastModifiedFile.lastModified();
        } else {
            HttpURLConnection conn = null;
            try {
                conn = Downloader.getConnection(url);
                conn.setRequestMethod("HEAD");
                conn.connect();
                timestamp = conn.getLastModified();
            }
            catch (Exception ex) {
                throw new DownloadFailedException("Error making HTTP HEAD request.", ex);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    finally {
                        conn = null;
                    }
                }
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection getConnection(URL url) throws DownloadFailedException {
        HttpURLConnection conn = null;
        Proxy proxy = null;
        String proxyUrl = Settings.getString("proxy.url");
        try {
            if (proxyUrl != null) {
                int proxyPort = Settings.getInt("proxy.port");
                InetSocketAddress addr = new InetSocketAddress(proxyUrl, proxyPort);
                final String username = Settings.getString("proxy.username");
                final String password = Settings.getString("proxy.password");
                if (username != null && password != null) {
                    Authenticator auth = new Authenticator(){

                        @Override
                        public PasswordAuthentication getPasswordAuthentication() {
                            if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                                return new PasswordAuthentication(username, password.toCharArray());
                            }
                            return super.getPasswordAuthentication();
                        }
                    };
                    Authenticator.setDefault(auth);
                }
                proxy = new Proxy(Proxy.Type.HTTP, addr);
                conn = (HttpURLConnection)url.openConnection(proxy);
            } else {
                conn = (HttpURLConnection)url.openConnection();
            }
            int timeout = Settings.getInt("connection.timeout", 60000);
            conn.setConnectTimeout(timeout);
        }
        catch (IOException ex) {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                finally {
                    conn = null;
                }
            }
            throw new DownloadFailedException("Error getting connection.", ex);
        }
        return conn;
    }
}

