/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

public class Evidence
implements Comparable<Evidence> {
    private String name;
    private String source;
    private String value;
    private boolean used;
    private Confidence confidence;

    public Evidence() {
    }

    public Evidence(String source, String name, String value, Confidence confidence) {
        this.source = source;
        this.name = name;
        this.value = value;
        this.confidence = confidence;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getValue() {
        this.used = true;
        return this.value;
    }

    public String getValue(Boolean setUsed) {
        this.used = this.used || setUsed != false;
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public Confidence getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 67 * hash + (this.source != null ? this.source.hashCode() : 0);
        hash = 67 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 67 * hash + (this.confidence != null ? this.confidence.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Evidence)) {
            return false;
        }
        Evidence e = (Evidence)that;
        return this.testEquality(this.name, e.name) && this.testEquality(this.source, e.source) && this.testEquality(this.value, e.value) && (this.confidence == null ? e.confidence == null : this.confidence == e.confidence);
    }

    private boolean testEquality(String l, String r) {
        return l == null ? r == null : l.equalsIgnoreCase(r);
    }

    @Override
    public int compareTo(Evidence o) {
        if (this.source.equals(o.source)) {
            if (this.name.equals(o.name)) {
                if (this.value.equals(o.value)) {
                    if (this.confidence.equals((Object)o.confidence)) {
                        return 0;
                    }
                    return this.confidence.compareTo(o.confidence);
                }
                return this.value.compareToIgnoreCase(o.value);
            }
            return this.name.compareToIgnoreCase(o.name);
        }
        return this.source.compareToIgnoreCase(o.source);
    }

    public static enum Confidence {
        HIGHEST,
        HIGH,
        MEDIUM,
        LOW;

    }
}

