/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.lucene;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.owasp.dependencycheck.data.lucene.AbstractTokenizingFilter;
import org.owasp.dependencycheck.utils.UrlStringUtils;

public final class UrlTokenizingFilter
extends AbstractTokenizingFilter {
    public UrlTokenizingFilter(TokenStream stream) {
        super(stream);
    }

    public boolean incrementToken() throws IOException {
        LinkedList<String> tokens = this.getTokens();
        CharTermAttribute termAtt = this.getTermAtt();
        if (tokens.size() == 0 && this.input.incrementToken()) {
            String text = new String(termAtt.buffer(), 0, termAtt.length());
            if (UrlStringUtils.containsUrl(text)) {
                String[] parts;
                for (String part : parts = text.split("\\s")) {
                    if (UrlStringUtils.isUrl(part)) {
                        try {
                            List<String> data = UrlStringUtils.extractImportantUrlData(part);
                            tokens.addAll(data);
                        }
                        catch (MalformedURLException ex) {
                            Logger.getLogger(UrlTokenizingFilter.class.getName()).log(Level.INFO, "error parsing " + part, ex);
                            tokens.add(part);
                        }
                        continue;
                    }
                    tokens.add(part);
                }
            } else {
                tokens.add(text);
            }
        }
        return this.addTerm();
    }
}

