/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.concurrency;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.concurrency.DirectoryLockException;
import org.owasp.dependencycheck.concurrency.InvalidDirectoryException;

public class DirectorySpinLock
implements Closeable {
    public static final String LOCK_NAME = "data.lock";
    public static final int MAX_SPIN = 100;
    private FileChannel channel = null;
    private File lockFile = null;
    private FileLock lock = null;
    private long maxWait = 100L;

    public long getMaxWait() {
        return this.maxWait / 2L;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait * 2L;
    }

    public DirectorySpinLock(File directory) throws InvalidDirectoryException, DirectoryLockException {
        this.checkDirectory(directory);
        this.lockFile = new File(directory, LOCK_NAME);
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(this.lockFile, "rw");
        }
        catch (FileNotFoundException ex) {
            throw new DirectoryLockException("Lock file not found", ex);
        }
        this.channel = file.getChannel();
    }

    public void obtainSharedLock() throws DirectoryLockException {
        this.obtainLock(true);
    }

    public void obtainExclusiveLock() throws DirectoryLockException {
        this.obtainLock(false);
    }

    protected void obtainLock(boolean shared, long maxWait) throws DirectoryLockException {
        this.setMaxWait(maxWait);
        this.obtainLock(shared);
    }

    protected void obtainLock(boolean shared) throws DirectoryLockException {
        if (this.lock != null) {
            this.release();
        }
        if (this.channel == null) {
            throw new DirectoryLockException("Unable to create lock, no file channel exists");
        }
        int count = 0;
        Exception lastException = null;
        while (this.lock == null && (long)count++ < this.maxWait) {
            try {
                this.lock = this.channel.lock(0L, Long.MAX_VALUE, shared);
            }
            catch (AsynchronousCloseException ex) {
                lastException = ex;
            }
            catch (ClosedChannelException ex) {
                lastException = ex;
            }
            catch (FileLockInterruptionException ex) {
                lastException = ex;
            }
            catch (OverlappingFileLockException ex) {
                lastException = ex;
            }
            catch (NonWritableChannelException ex) {
                lastException = ex;
            }
            catch (IOException ex) {
                lastException = ex;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.lock == null) {
            if (lastException == null) {
                throw new DirectoryLockException("Unable to obtain lock");
            }
            throw new DirectoryLockException("Unable to obtain lock", lastException);
        }
    }

    private void checkDirectory(File directory) throws InvalidDirectoryException {
        if (directory == null) {
            throw new InvalidDirectoryException("Unable to obtain lock on a null File");
        }
        if (!directory.isDirectory()) {
            String msg = String.format("File, '%s', does not exist or is not a directory", directory.getAbsolutePath());
            throw new InvalidDirectoryException(msg);
        }
    }

    @Override
    public void close() throws IOException {
        this.release();
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException ex) {
                Logger.getLogger(DirectorySpinLock.class.getName()).log(Level.FINEST, "Unable to close the channel for the file lock", ex);
            }
        }
        if (this.lockFile != null && this.lockFile.exists()) {
            this.lockFile.delete();
        }
    }

    public void release() {
        if (this.lock != null) {
            try {
                this.lock.release();
            }
            catch (ClosedChannelException ex) {
                Logger.getLogger(DirectorySpinLock.class.getName()).log(Level.FINEST, "Uable to release file lock", ex);
            }
            catch (IOException ex) {
                Logger.getLogger(DirectorySpinLock.class.getName()).log(Level.FINEST, "Unable to release file lock due to IO Exception", ex);
            }
        }
    }
}

