/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.jsoup.Jsoup;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisException;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceCollection;
import org.owasp.dependencycheck.jaxb.pom.MavenNamespaceFilter;
import org.owasp.dependencycheck.jaxb.pom.generated.License;
import org.owasp.dependencycheck.jaxb.pom.generated.Model;
import org.owasp.dependencycheck.jaxb.pom.generated.Organization;
import org.owasp.dependencycheck.utils.NonClosingStream;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JarAnalyzer
extends AbstractAnalyzer
implements Analyzer {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final Set<String> IGNORE_VALUES = JarAnalyzer.newHashSet("Sun Java System Application Server");
    private static final Set<String> IGNORE_KEYS = JarAnalyzer.newHashSet("built-by", "created-by", "builtby", "createdby", "build-jdk", "buildjdk", "ant-version", "antversion", "import-package", "export-package", "importpackage", "exportpackage", "sealed", "manifest-version", "archiver-version", "manifestversion", "archiverversion", "classpath", "class-path", "tool", "bundle-manifestversion", "bundlemanifestversion", "include-resource");
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String BUNDLE_DESCRIPTION = "Bundle-Description";
    private static final String BUNDLE_NAME = "Bundle-Name";
    private static final String BUNDLE_VENDOR = "Bundle-Vendor";
    private static final Pattern HTML_DETECTION_PATTERN = Pattern.compile("\\<[a-z]+.*/?\\>", 2);
    private Unmarshaller pomUnmarshaller;
    private static final String ANALYZER_NAME = "Jar Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final Set<String> EXTENSIONS = JarAnalyzer.newHashSet("jar", "war");

    public JarAnalyzer() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.owasp.dependencycheck.jaxb.pom.generated");
            this.pomUnmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException ex) {
            Logger.getLogger(JarAnalyzer.class.getName()).log(Level.SEVERE, "Unable to load parser. See the log for more details.");
            Logger.getLogger(JarAnalyzer.class.getName()).log(Level.FINE, null, ex);
        }
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return EXTENSIONS.contains(extension);
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    public void analyze(Dependency dependency, Engine engine) throws AnalysisException {
        try {
            ArrayList<ClassNameInformation> classNames = this.collectClassNames(dependency);
            String fileName = dependency.getFileName().toLowerCase();
            if (classNames.isEmpty() && (fileName.endsWith("-sources.jar") || fileName.endsWith("-javadoc.jar") || fileName.endsWith("-src.jar") || fileName.endsWith("-doc.jar"))) {
                engine.getDependencies().remove(dependency);
            }
            boolean hasManifest = this.parseManifest(dependency, classNames);
            boolean hasPOM = this.analyzePOM(dependency, classNames);
            boolean addPackagesAsEvidence = !hasManifest || !hasPOM;
            this.analyzePackageNames(classNames, dependency, addPackagesAsEvidence);
        }
        catch (IOException ex) {
            throw new AnalysisException("Exception occurred reading the JAR file.", ex);
        }
    }

    protected boolean analyzePOM(Dependency dependency, ArrayList<ClassNameInformation> classes) throws AnalysisException {
        List<String> pomEntries;
        JarFile jar;
        boolean foundSomething = false;
        try {
            jar = new JarFile(dependency.getActualFilePath());
        }
        catch (IOException ex) {
            String msg = String.format("Unable to read JarFile '%s'.", dependency.getActualFilePath());
            AnalysisException ax = new AnalysisException(msg, ex);
            dependency.getAnalysisExceptions().add(ax);
            Logger.getLogger(JarAnalyzer.class.getName()).log(Level.WARNING, msg);
            Logger.getLogger(JarAnalyzer.class.getName()).log(Level.FINE, null, ex);
            return false;
        }
        try {
            pomEntries = this.retrievePomListing(jar);
        }
        catch (IOException ex) {
            String msg = String.format("Unable to read Jar file entries in '%s'.", dependency.getActualFilePath());
            AnalysisException ax = new AnalysisException(msg, ex);
            dependency.getAnalysisExceptions().add(ax);
            Logger.getLogger(JarAnalyzer.class.getName()).log(Level.WARNING, msg);
            Logger.getLogger(JarAnalyzer.class.getName()).log(Level.INFO, msg, ex);
            return false;
        }
        if (pomEntries.isEmpty()) {
            return false;
        }
        if (pomEntries.size() > 1) {
            pomEntries = this.filterPomEntries(pomEntries, classes);
        }
        for (String path : pomEntries) {
            String msg;
            Properties pomProperties = null;
            try {
                pomProperties = this.retrievePomProperties(path, jar);
            }
            catch (IOException ex) {
                Logger.getLogger(JarAnalyzer.class.getName()).log(Level.FINEST, "ignore this, failed reading a non-existent pom.properties", ex);
            }
            Model pom = null;
            try {
                pom = this.retrievePom(path, jar);
            }
            catch (JAXBException ex) {
                msg = String.format("Unable to parse POM '%s' in '%s'", path, dependency.getFilePath());
                AnalysisException ax = new AnalysisException(msg, ex);
                dependency.getAnalysisExceptions().add(ax);
                Logger.getLogger(JarAnalyzer.class.getName()).log(Level.FINE, msg, ax);
            }
            catch (IOException ex) {
                msg = String.format("Unable to retrieve POM '%s' in '%s'", path, dependency.getFilePath());
                Logger.getLogger(JarAnalyzer.class.getName()).log(Level.FINE, msg, ex);
            }
            foundSomething = this.setPomEvidence(dependency, pom, pomProperties, classes) || foundSomething;
        }
        return foundSomething;
    }

    @SuppressWarnings(value={"OS_OPEN_STREAM"}, justification="The reader is closed by closing the zipEntry")
    private Properties retrievePomProperties(String path, JarFile jar) throws IOException {
        Properties pomProperties = null;
        String propPath = path.substring(0, path.length() - 7) + "pom.properies";
        ZipEntry propEntry = jar.getEntry(propPath);
        if (propEntry != null) {
            InputStreamReader reader = new InputStreamReader(jar.getInputStream(propEntry), "UTF-8");
            pomProperties = new Properties();
            pomProperties.load(reader);
        }
        return pomProperties;
    }

    private List<String> retrievePomListing(JarFile jar) throws IOException {
        ArrayList<String> pomEntries = new ArrayList<String>();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = new File(entry.getName()).getName().toLowerCase();
            if (entry.isDirectory() || !"pom.xml".equals(entryName)) continue;
            pomEntries.add(entry.getName());
        }
        return pomEntries;
    }

    private Model retrievePom(String path, JarFile jar) throws JAXBException, IOException {
        ZipEntry entry = jar.getEntry(path);
        if (entry != null) {
            Model m = null;
            try {
                MavenNamespaceFilter filter = new MavenNamespaceFilter();
                SAXParserFactory spf = SAXParserFactory.newInstance();
                SAXParser sp = spf.newSAXParser();
                XMLReader xr = sp.getXMLReader();
                filter.setParent(xr);
                NonClosingStream stream = new NonClosingStream(jar.getInputStream(entry));
                InputStreamReader reader = new InputStreamReader((InputStream)stream, "UTF-8");
                InputSource xml = new InputSource(reader);
                SAXSource source = new SAXSource(filter, xml);
                JAXBElement el = this.pomUnmarshaller.unmarshal((Source)source, Model.class);
                m = (Model)el.getValue();
            }
            catch (ParserConfigurationException ex) {
                String msg = String.format("Unable to parse pom '%s' in jar '%s'", path, jar.getName());
                Logger.getLogger(JarAnalyzer.class.getName()).log(Level.FINE, msg, ex);
            }
            catch (SAXException ex) {
                String msg = String.format("Unable to parse pom '%s' in jar '%s'", path, jar.getName());
                Logger.getLogger(JarAnalyzer.class.getName()).log(Level.FINE, msg, ex);
            }
            return m;
        }
        return null;
    }

    private boolean setPomEvidence(Dependency dependency, Model pom, Properties pomProperties, ArrayList<ClassNameInformation> classes) {
        String pomName;
        Organization org;
        String version;
        String artifactid;
        boolean foundSomething = false;
        if (pom == null) {
            return foundSomething;
        }
        String groupid = this.interpolateString(pom.getGroupId(), pomProperties);
        if (groupid != null && !groupid.isEmpty()) {
            if (groupid.startsWith("org.") || groupid.startsWith("com.")) {
                groupid = groupid.substring(4);
            }
            foundSomething = true;
            dependency.getVendorEvidence().addEvidence("pom", "groupid", groupid, Evidence.Confidence.HIGH);
            dependency.getProductEvidence().addEvidence("pom", "groupid", groupid, Evidence.Confidence.LOW);
            this.addMatchingValues(classes, groupid, dependency.getVendorEvidence());
            this.addMatchingValues(classes, groupid, dependency.getProductEvidence());
        }
        if ((artifactid = this.interpolateString(pom.getArtifactId(), pomProperties)) != null && !artifactid.isEmpty()) {
            if (artifactid.startsWith("org.") || artifactid.startsWith("com.")) {
                artifactid = artifactid.substring(4);
            }
            foundSomething = true;
            dependency.getProductEvidence().addEvidence("pom", "artifactid", artifactid, Evidence.Confidence.HIGH);
            dependency.getVendorEvidence().addEvidence("pom", "artifactid", artifactid, Evidence.Confidence.LOW);
            this.addMatchingValues(classes, artifactid, dependency.getVendorEvidence());
            this.addMatchingValues(classes, artifactid, dependency.getProductEvidence());
        }
        if ((version = this.interpolateString(pom.getVersion(), pomProperties)) != null && !version.isEmpty()) {
            foundSomething = true;
            dependency.getVersionEvidence().addEvidence("pom", "version", version, Evidence.Confidence.HIGHEST);
        }
        if ((org = pom.getOrganization()) != null && org.getName() != null) {
            foundSomething = true;
            String orgName = this.interpolateString(org.getName(), pomProperties);
            if (orgName != null && !orgName.isEmpty()) {
                dependency.getVendorEvidence().addEvidence("pom", "organization name", orgName, Evidence.Confidence.HIGH);
                this.addMatchingValues(classes, orgName, dependency.getVendorEvidence());
            }
        }
        if ((pomName = this.interpolateString(pom.getName(), pomProperties)) != null && !pomName.isEmpty()) {
            foundSomething = true;
            dependency.getProductEvidence().addEvidence("pom", "name", pomName, Evidence.Confidence.HIGH);
            dependency.getVendorEvidence().addEvidence("pom", "name", pomName, Evidence.Confidence.HIGH);
            this.addMatchingValues(classes, pomName, dependency.getVendorEvidence());
            this.addMatchingValues(classes, pomName, dependency.getProductEvidence());
        }
        if (pom.getDescription() != null) {
            foundSomething = true;
            String description = this.interpolateString(pom.getDescription(), pomProperties);
            if (description != null && !description.isEmpty()) {
                this.addDescription(dependency, description, "pom", "description");
                this.addMatchingValues(classes, description, dependency.getVendorEvidence());
                this.addMatchingValues(classes, description, dependency.getProductEvidence());
            }
        }
        if (pom.getLicenses() != null) {
            String license = null;
            for (License lic : pom.getLicenses().getLicense()) {
                String tmp = null;
                if (lic.getName() != null) {
                    tmp = this.interpolateString(lic.getName(), pomProperties);
                }
                if (lic.getUrl() != null) {
                    tmp = tmp == null ? this.interpolateString(lic.getUrl(), pomProperties) : tmp + ": " + this.interpolateString(lic.getUrl(), pomProperties);
                }
                if (tmp == null) continue;
                if (HTML_DETECTION_PATTERN.matcher(tmp).find()) {
                    tmp = Jsoup.parse((String)tmp).text();
                }
                if (license == null) {
                    license = tmp;
                    continue;
                }
                license = license + "\n" + tmp;
            }
            if (license != null) {
                dependency.setLicense(license);
            }
        }
        return foundSomething;
    }

    protected void analyzePackageNames(ArrayList<ClassNameInformation> classNames, Dependency dependency, boolean addPackagesAsEvidence) {
        float ratio;
        HashMap<String, Integer> vendorIdentifiers = new HashMap<String, Integer>();
        HashMap<String, Integer> productIdentifiers = new HashMap<String, Integer>();
        this.analyzeFullyQualifiedClassNames(classNames, vendorIdentifiers, productIdentifiers);
        int classCount = classNames.size();
        EvidenceCollection vendor = dependency.getVendorEvidence();
        EvidenceCollection product = dependency.getProductEvidence();
        for (Map.Entry<String, Integer> entry : vendorIdentifiers.entrySet()) {
            ratio = (float)entry.getValue().intValue() / (float)classCount;
            if (!((double)ratio > 0.5)) continue;
            vendor.addWeighting(entry.getKey());
            if (!addPackagesAsEvidence || entry.getKey().length() <= 1) continue;
            vendor.addEvidence("jar", "package", entry.getKey(), Evidence.Confidence.LOW);
        }
        for (Map.Entry<String, Integer> entry : productIdentifiers.entrySet()) {
            ratio = (float)entry.getValue().intValue() / (float)classCount;
            if (!((double)ratio > 0.5)) continue;
            product.addWeighting(entry.getKey());
            if (!addPackagesAsEvidence || entry.getKey().length() <= 1) continue;
            product.addEvidence("jar", "package", entry.getKey(), Evidence.Confidence.LOW);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean parseManifest(Dependency dependency, ArrayList<ClassNameInformation> classInformation) throws IOException {
        boolean foundSomething = false;
        JarFile jar = null;
        try {
            jar = new JarFile(dependency.getActualFilePath());
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                if (!(dependency.getFileName().toLowerCase().endsWith("-sources.jar") || dependency.getFileName().toLowerCase().endsWith("-javadoc.jar") || dependency.getFileName().toLowerCase().endsWith("-src.jar") || dependency.getFileName().toLowerCase().endsWith("-doc.jar"))) {
                    Logger.getLogger(JarAnalyzer.class.getName()).log(Level.INFO, String.format("Jar file '%s' does not contain a manifest.", dependency.getFileName()));
                }
                boolean bl = false;
                return bl;
            }
            Attributes atts = manifest.getMainAttributes();
            EvidenceCollection vendorEvidence = dependency.getVendorEvidence();
            EvidenceCollection productEvidence = dependency.getProductEvidence();
            EvidenceCollection versionEvidence = dependency.getVersionEvidence();
            String source = "Manifest";
            for (Map.Entry<Object, Object> entry : atts.entrySet()) {
                String key = entry.getKey().toString();
                String value = atts.getValue(key);
                if (HTML_DETECTION_PATTERN.matcher(value).find()) {
                    value = Jsoup.parse((String)value).text();
                }
                if (IGNORE_VALUES.contains(value)) continue;
                if (key.equalsIgnoreCase(Attributes.Name.IMPLEMENTATION_TITLE.toString())) {
                    foundSomething = true;
                    productEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.HIGH);
                    this.addMatchingValues(classInformation, value, productEvidence);
                    continue;
                }
                if (key.equalsIgnoreCase(Attributes.Name.IMPLEMENTATION_VERSION.toString())) {
                    foundSomething = true;
                    versionEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.HIGH);
                    continue;
                }
                if (key.equalsIgnoreCase(Attributes.Name.IMPLEMENTATION_VENDOR.toString())) {
                    foundSomething = true;
                    vendorEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.HIGH);
                    this.addMatchingValues(classInformation, value, vendorEvidence);
                    continue;
                }
                if (key.equalsIgnoreCase(Attributes.Name.IMPLEMENTATION_VENDOR_ID.toString())) {
                    foundSomething = true;
                    vendorEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.MEDIUM);
                    this.addMatchingValues(classInformation, value, vendorEvidence);
                    continue;
                }
                if (key.equalsIgnoreCase(BUNDLE_DESCRIPTION)) {
                    foundSomething = true;
                    this.addDescription(dependency, value, "manifest", key);
                    this.addMatchingValues(classInformation, value, productEvidence);
                    continue;
                }
                if (key.equalsIgnoreCase(BUNDLE_NAME)) {
                    foundSomething = true;
                    productEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.MEDIUM);
                    this.addMatchingValues(classInformation, value, productEvidence);
                    continue;
                }
                if (key.equalsIgnoreCase(BUNDLE_VENDOR)) {
                    foundSomething = true;
                    vendorEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.HIGH);
                    this.addMatchingValues(classInformation, value, vendorEvidence);
                    continue;
                }
                if (key.equalsIgnoreCase(BUNDLE_VERSION)) {
                    foundSomething = true;
                    versionEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.HIGH);
                    continue;
                }
                if (key.equalsIgnoreCase(Attributes.Name.MAIN_CLASS.toString()) || IGNORE_KEYS.contains(key = key.toLowerCase()) || key.endsWith("jdk") || key.contains("lastmodified") || key.endsWith("package") || key.endsWith("classpath") || key.endsWith("class-path") || key.endsWith("-scm") || key.startsWith("scm-") || this.isImportPackage(key, value) || this.isPackage(key, value)) continue;
                foundSomething = true;
                if (key.contains("version")) {
                    if (key.contains("specification")) {
                        versionEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.LOW);
                        continue;
                    }
                    versionEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.MEDIUM);
                    continue;
                }
                if (key.contains("title")) {
                    productEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.MEDIUM);
                    this.addMatchingValues(classInformation, value, productEvidence);
                    continue;
                }
                if (key.contains("vendor")) {
                    if (key.contains("specification")) {
                        vendorEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.LOW);
                        continue;
                    }
                    vendorEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.MEDIUM);
                    this.addMatchingValues(classInformation, value, vendorEvidence);
                    continue;
                }
                if (key.contains("name")) {
                    productEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.MEDIUM);
                    vendorEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.MEDIUM);
                    this.addMatchingValues(classInformation, value, vendorEvidence);
                    this.addMatchingValues(classInformation, value, productEvidence);
                    continue;
                }
                if (key.contains("license")) {
                    this.addLicense(dependency, value);
                    continue;
                }
                if (key.contains("description")) {
                    this.addDescription(dependency, value, "manifest", key);
                    continue;
                }
                productEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.LOW);
                vendorEvidence.addEvidence("Manifest", key, value, Evidence.Confidence.LOW);
                this.addMatchingValues(classInformation, value, vendorEvidence);
                this.addMatchingValues(classInformation, value, productEvidence);
                if (!value.matches(".*\\d.*")) continue;
                StringTokenizer tokenizer = new StringTokenizer(value, " ");
                while (tokenizer.hasMoreElements()) {
                    String s = tokenizer.nextToken();
                    if (!s.matches("^[0-9.]+$")) continue;
                    versionEvidence.addEvidence("Manifest", key, s, Evidence.Confidence.LOW);
                }
            }
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
        return foundSomething;
    }

    private void addDescription(Dependency dependency, String description, String source, String key) {
        if (dependency.getDescription() == null) {
            dependency.setDescription(description);
        }
        String desc = HTML_DETECTION_PATTERN.matcher(description).find() ? Jsoup.parse((String)description).text() : description;
        dependency.setDescription(desc);
        if (desc.length() > 100) {
            int posSuchAs = desc.toLowerCase().indexOf("such as ", 100);
            int posLike = desc.toLowerCase().indexOf("like ", 100);
            int pos = -1;
            if (posLike > 0 && posSuchAs > 0) {
                pos = posLike > posSuchAs ? posLike : posSuchAs;
            } else if (posLike > 0) {
                pos = posLike;
            } else if (posSuchAs > 0) {
                pos = posSuchAs;
            }
            String descToUse = desc;
            if (pos > 0) {
                StringBuilder sb = new StringBuilder(pos + 3);
                sb.append(desc.substring(0, pos));
                sb.append("...");
                descToUse = sb.toString();
            }
            dependency.getProductEvidence().addEvidence(source, key, descToUse, Evidence.Confidence.LOW);
            dependency.getVendorEvidence().addEvidence(source, key, descToUse, Evidence.Confidence.LOW);
        } else {
            dependency.getProductEvidence().addEvidence(source, key, desc, Evidence.Confidence.MEDIUM);
            dependency.getVendorEvidence().addEvidence(source, key, desc, Evidence.Confidence.MEDIUM);
        }
    }

    private void addLicense(Dependency d, String license) {
        if (d.getLicense() == null) {
            d.setLicense(license);
        } else if (!d.getLicense().contains(license)) {
            d.setLicense(d.getLicense() + NEWLINE + license);
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void close() {
    }

    protected String interpolateString(String text, Properties properties) {
        int pos;
        Properties props = properties;
        if (text == null) {
            return text;
        }
        if (props == null) {
            props = new Properties();
        }
        if ((pos = text.indexOf("${")) < 0) {
            return text;
        }
        int end = text.indexOf("}");
        if (end < pos) {
            return text;
        }
        String propName = text.substring(pos + 2, end);
        String propValue = this.interpolateString(props.getProperty(propName), props);
        if (propValue == null) {
            propValue = "";
        }
        StringBuilder sb = new StringBuilder(propValue.length() + text.length());
        sb.append(text.subSequence(0, pos));
        sb.append(propValue);
        sb.append(text.substring(end + 1));
        return this.interpolateString(sb.toString(), props);
    }

    private boolean isImportPackage(String key, String value) {
        Pattern packageRx = Pattern.compile("^((([a-zA-Z_#\\$0-9]\\.)+)\\s*\\;\\s*)+$");
        if (packageRx.matcher(value).matches()) {
            return key.contains("import") || key.contains("include");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ClassNameInformation> collectClassNames(Dependency dependency) {
        ArrayList<ClassNameInformation> classNames = new ArrayList<ClassNameInformation>();
        JarFile jar = null;
        try {
            jar = new JarFile(dependency.getActualFilePath());
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName().toLowerCase();
                if (!name.endsWith(".class") || name.matches("^javax?\\..*$")) continue;
                ClassNameInformation className = new ClassNameInformation(name.substring(0, name.length() - 6));
                classNames.add(className);
            }
        }
        catch (IOException ex) {
            String msg = String.format("Unable to open jar file '%s'.", dependency.getFileName());
            Logger.getLogger(JarAnalyzer.class.getName()).log(Level.WARNING, msg);
            Logger.getLogger(JarAnalyzer.class.getName()).log(Level.FINE, null, ex);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(JarAnalyzer.class.getName()).log(Level.FINEST, null, ex);
                }
            }
        }
        return classNames;
    }

    private void analyzeFullyQualifiedClassNames(ArrayList<ClassNameInformation> classNames, HashMap<String, Integer> vendor, HashMap<String, Integer> product) {
        for (ClassNameInformation entry : classNames) {
            ArrayList<String> list = entry.getPackageStructure();
            this.addEntry(vendor, list.get(0));
            if (list.size() == 2) {
                this.addEntry(product, list.get(1));
            }
            if (list.size() == 3) {
                this.addEntry(vendor, list.get(1));
                this.addEntry(product, list.get(1));
                this.addEntry(product, list.get(2));
            }
            if (list.size() < 4) continue;
            this.addEntry(vendor, list.get(1));
            this.addEntry(vendor, list.get(2));
            this.addEntry(product, list.get(1));
            this.addEntry(product, list.get(2));
            this.addEntry(product, list.get(3));
        }
    }

    private void addEntry(HashMap<String, Integer> collection, String key) {
        if (collection.containsKey(key)) {
            collection.put(key, collection.get(key) + 1);
        } else {
            collection.put(key, 1);
        }
    }

    private void addMatchingValues(ArrayList<ClassNameInformation> classes, String value, EvidenceCollection evidence) {
        if (value == null || value.isEmpty()) {
            return;
        }
        String text = value.toLowerCase();
        for (ClassNameInformation cni : classes) {
            for (String key : cni.getPackageStructure()) {
                if (!text.contains(key)) continue;
                evidence.addEvidence("jar", "package name", key, Evidence.Confidence.HIGHEST);
            }
        }
    }

    private List<String> filterPomEntries(List<String> pomEntries, ArrayList<ClassNameInformation> classes) {
        return pomEntries;
    }

    private boolean isPackage(String key, String value) {
        return !key.matches(".*(version|title|vendor|name|license|description).*") && value.matches("^([a-zA-Z_][a-zA-Z0-9_\\$]*(\\.[a-zA-Z_][a-zA-Z0-9_\\$]*)*)?$");
    }

    protected static class ClassNameInformation {
        private String name;
        private ArrayList<String> packageStructure = new ArrayList();

        ClassNameInformation(String className) {
            this.name = className;
            if (this.name.contains("/")) {
                String[] tmp = className.toLowerCase().split("/");
                int start = 0;
                int end = 3;
                if ("com".equals(tmp[0]) || "org".equals(tmp[0])) {
                    start = 1;
                    end = 4;
                }
                if (tmp.length <= end) {
                    end = tmp.length - 1;
                }
                for (int i = start; i <= end; ++i) {
                    this.packageStructure.add(tmp[i]);
                }
            } else {
                this.packageStructure.add(this.name);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ArrayList<String> getPackageStructure() {
            return this.packageStructure;
        }
    }
}

