/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.owasp.dependencycheck.data.UpdateException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.InvalidDataException;
import org.owasp.dependencycheck.data.update.AbstractUpdateTask;
import org.owasp.dependencycheck.data.update.DataStoreMetaInfo;
import org.owasp.dependencycheck.data.update.NvdCveInfo;
import org.owasp.dependencycheck.data.update.Updateable;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.xml.sax.SAXException;

public class StandardUpdateTask
extends AbstractUpdateTask {
    public StandardUpdateTask(DataStoreMetaInfo properties) throws MalformedURLException, DownloadFailedException, UpdateException {
        super(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws UpdateException {
        try {
            int maxUpdates = 0;
            for (NvdCveInfo cve : this.getUpdateable()) {
                if (!cve.getNeedsUpdate()) continue;
                ++maxUpdates;
            }
            if (maxUpdates > 3) {
                Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.INFO, "NVD CVE requires several updates; this could take a couple of minutes.");
            }
            if (maxUpdates > 0) {
                this.openDataStores();
            }
            int count = 0;
            for (NvdCveInfo cve : this.getUpdateable()) {
                if (!cve.getNeedsUpdate()) continue;
                Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.INFO, "Updating NVD CVE ({0} of {1})", new Object[]{++count, maxUpdates});
                URL url = new URL(cve.getUrl());
                File outputPath = null;
                File outputPath12 = null;
                try {
                    Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.INFO, "Downloading {0}", cve.getUrl());
                    outputPath = File.createTempFile("cve" + cve.getId() + "_", ".xml");
                    Downloader.fetchFile(url, outputPath);
                    url = new URL(cve.getOldSchemaVersionUrl());
                    outputPath12 = File.createTempFile("cve_1_2_" + cve.getId() + "_", ".xml");
                    Downloader.fetchFile(url, outputPath12);
                    Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.INFO, "Processing {0}", cve.getUrl());
                    this.importXML(outputPath, outputPath12);
                    this.getCveDB().commit();
                    this.getCpeIndex().commit();
                    this.getProperties().save(cve);
                    Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.INFO, "Completed update {0} of {1}", new Object[]{count, maxUpdates});
                }
                catch (FileNotFoundException ex) {
                    throw new UpdateException(ex);
                }
                catch (ParserConfigurationException ex) {
                    throw new UpdateException(ex);
                }
                catch (SAXException ex) {
                    throw new UpdateException(ex);
                }
                catch (IOException ex) {
                    throw new UpdateException(ex);
                }
                catch (SQLException ex) {
                    throw new UpdateException(ex);
                }
                catch (DatabaseException ex) {
                    throw new UpdateException(ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new UpdateException(ex);
                }
                finally {
                    boolean deleted = false;
                    try {
                        if (outputPath != null && outputPath.exists()) {
                            deleted = outputPath.delete();
                        }
                    }
                    finally {
                        if (outputPath != null && (outputPath.exists() || !deleted)) {
                            outputPath.deleteOnExit();
                        }
                    }
                    try {
                        deleted = false;
                        if (outputPath12 == null || !outputPath12.exists()) continue;
                        deleted = outputPath12.delete();
                    }
                    finally {
                        if (outputPath12 == null || !outputPath12.exists() && deleted) continue;
                        outputPath12.deleteOnExit();
                    }
                }
            }
            if (maxUpdates >= 1) {
                this.getProperties().save(this.getUpdateable().get("modified"));
                this.getCveDB().cleanupDatabase();
            }
        }
        catch (MalformedURLException ex) {
            throw new UpdateException(ex);
        }
        finally {
            this.closeDataStores();
        }
    }

    @Override
    protected Updateable updatesNeeded() throws MalformedURLException, DownloadFailedException, UpdateException {
        Updateable updates;
        block21: {
            updates = null;
            try {
                updates = this.retrieveCurrentTimestampsFromWeb();
            }
            catch (InvalidDataException ex) {
                String msg = "Unable to retrieve valid timestamp from nvd cve downloads page";
                Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.FINE, "Unable to retrieve valid timestamp from nvd cve downloads page", ex);
                throw new DownloadFailedException("Unable to retrieve valid timestamp from nvd cve downloads page", ex);
            }
            catch (InvalidSettingException ex) {
                Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.FINE, "Invalid setting found when retrieving timestamps", ex);
                throw new DownloadFailedException("Invalid settings", ex);
            }
            if (updates == null) {
                throw new DownloadFailedException("Unable to retrieve the timestamps of the currently published NVD CVE data");
            }
            DataStoreMetaInfo properties = this.getProperties();
            if (!properties.isEmpty()) {
                try {
                    if (properties.getProperty("version") == null) {
                        this.setDeleteAndRecreate(true);
                    } else {
                        try {
                            float version = Float.parseFloat(properties.getProperty("version"));
                            float currentVersion = Float.parseFloat("2.6");
                            if (currentVersion > version) {
                                this.setDeleteAndRecreate(true);
                            }
                        }
                        catch (NumberFormatException ex) {
                            this.setDeleteAndRecreate(true);
                        }
                    }
                    if (this.shouldDeleteAndRecreate()) {
                        return updates;
                    }
                    long lastUpdated = Long.parseLong(properties.getProperty("lastupdated.modified", "0"));
                    Date now = new Date();
                    int days = Settings.getInt("cve.url.modified.validfordays", 7);
                    if (lastUpdated == updates.getTimeStamp("modified")) {
                        updates.clear();
                        break block21;
                    }
                    if (this.withinRange(lastUpdated, now.getTime(), days)) {
                        for (NvdCveInfo entry : updates) {
                            if ("modified".equals(entry.getId())) {
                                entry.setNeedsUpdate(true);
                                continue;
                            }
                            entry.setNeedsUpdate(false);
                        }
                        break block21;
                    }
                    for (NvdCveInfo entry : updates) {
                        if ("modified".equals(entry.getId())) {
                            entry.setNeedsUpdate(true);
                            continue;
                        }
                        long currentTimestamp = 0L;
                        try {
                            currentTimestamp = Long.parseLong(properties.getProperty("lastupdated." + entry.getId(), "0"));
                        }
                        catch (NumberFormatException ex) {
                            String msg = String.format("Error parsing '%s' '%s' from nvdcve.lastupdated", "lastupdated.", entry.getId());
                            Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.FINE, msg, ex);
                        }
                        if (currentTimestamp != entry.getTimestamp()) continue;
                        entry.setNeedsUpdate(false);
                    }
                }
                catch (NumberFormatException ex) {
                    String msg = "An invalid schema version or timestamp exists in the data.properties file.";
                    Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.WARNING, "An invalid schema version or timestamp exists in the data.properties file.");
                    Logger.getLogger(StandardUpdateTask.class.getName()).log(Level.FINE, null, ex);
                }
            }
        }
        return updates;
    }

    private Updateable retrieveCurrentTimestampsFromWeb() throws MalformedURLException, DownloadFailedException, InvalidDataException, InvalidSettingException {
        Updateable updates = new Updateable();
        updates.add("modified", Settings.getString("cve.url-2.0.modified"), Settings.getString("cve.url-1.2.modified"), false);
        int start = Settings.getInt("cve.startyear");
        int end = Calendar.getInstance().get(1);
        String baseUrl20 = Settings.getString("cve.url-2.0.base");
        String baseUrl12 = Settings.getString("cve.url-1.2.base");
        for (int i = start; i <= end; ++i) {
            updates.add(Integer.toString(i), String.format(baseUrl20, i), String.format(baseUrl12, i), true);
        }
        return updates;
    }
}

