/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.owasp.dependencycheck.data.UpdateException;
import org.owasp.dependencycheck.data.cpe.CpeIndexWriter;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.NvdCve12Handler;
import org.owasp.dependencycheck.data.nvdcve.NvdCve20Handler;
import org.owasp.dependencycheck.data.update.DataStoreMetaInfo;
import org.owasp.dependencycheck.data.update.UpdateTask;
import org.owasp.dependencycheck.data.update.Updateable;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.Settings;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractUpdateTask
implements UpdateTask {
    private Updateable updateable;
    private DataStoreMetaInfo properties = null;
    private CveDB cveDB = null;
    private CpeIndexWriter cpeIndex = null;
    private boolean deleteAndRecreate = false;

    public AbstractUpdateTask(DataStoreMetaInfo properties) throws MalformedURLException, DownloadFailedException, UpdateException {
        this.properties = properties;
        this.updateable = this.updatesNeeded();
    }

    protected DataStoreMetaInfo getProperties() {
        return this.properties;
    }

    protected CveDB getCveDB() {
        return this.cveDB;
    }

    protected CpeIndexWriter getCpeIndex() {
        return this.cpeIndex;
    }

    @Override
    public boolean isUpdateNeeded() {
        return this.updateable.isUpdateNeeded();
    }

    protected Updateable getUpdateable() {
        return this.updateable;
    }

    protected abstract Updateable updatesNeeded() throws MalformedURLException, DownloadFailedException, UpdateException;

    @Override
    public abstract void update() throws UpdateException;

    @Override
    public boolean shouldDeleteAndRecreate() {
        return this.deleteAndRecreate;
    }

    protected void setDeleteAndRecreate(boolean deleteAndRecreate) {
        this.deleteAndRecreate = deleteAndRecreate;
    }

    protected void deleteExistingData() throws IOException {
        File data = Settings.getFile("data.cve");
        if (data.exists()) {
            FileUtils.delete(data);
        }
        if ((data = Settings.getFile("data.cpe")).exists()) {
            FileUtils.delete(data);
        }
        if ((data = DataStoreMetaInfo.getPropertiesFile()).exists()) {
            FileUtils.delete(data);
        }
    }

    protected void closeDataStores() {
        if (this.cveDB != null) {
            try {
                this.cveDB.close();
            }
            catch (Exception ignore) {
                Logger.getLogger(AbstractUpdateTask.class.getName()).log(Level.FINEST, "Error closing the cveDB", ignore);
            }
        }
        if (this.cpeIndex != null) {
            try {
                this.cpeIndex.close();
            }
            catch (Exception ignore) {
                Logger.getLogger(AbstractUpdateTask.class.getName()).log(Level.FINEST, "Error closing the cpeIndex", ignore);
            }
        }
    }

    protected void openDataStores() throws UpdateException {
        try {
            this.cveDB = new CveDB();
            this.cveDB.open();
            this.cpeIndex = new CpeIndexWriter();
            this.cpeIndex.open();
        }
        catch (IOException ex) {
            this.closeDataStores();
            Logger.getLogger(AbstractUpdateTask.class.getName()).log(Level.FINE, "IO Error opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
        catch (SQLException ex) {
            this.closeDataStores();
            Logger.getLogger(AbstractUpdateTask.class.getName()).log(Level.FINE, "SQL Exception opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
        catch (DatabaseException ex) {
            this.closeDataStores();
            Logger.getLogger(AbstractUpdateTask.class.getName()).log(Level.FINE, "Database Exception opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
        catch (ClassNotFoundException ex) {
            this.closeDataStores();
            Logger.getLogger(AbstractUpdateTask.class.getName()).log(Level.FINE, "Class not found exception opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
    }

    protected boolean withinRange(long date, long compareTo, int range) {
        double differenceInDays = (double)(compareTo - date) / 1000.0 / 60.0 / 60.0 / 24.0;
        return differenceInDays < (double)range;
    }

    protected void importXML(File file, File oldVersion) throws ParserConfigurationException, SAXException, IOException, SQLException, DatabaseException, ClassNotFoundException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        NvdCve12Handler cve12Handler = new NvdCve12Handler();
        saxParser.parse(oldVersion, (DefaultHandler)cve12Handler);
        Map<String, List<VulnerableSoftware>> prevVersionVulnMap = cve12Handler.getVulnerabilities();
        NvdCve20Handler cve20Handler = new NvdCve20Handler();
        cve20Handler.setCveDB(this.cveDB);
        cve20Handler.setPrevVersionVulnMap(prevVersionVulnMap);
        cve20Handler.setCpeIndex(this.cpeIndex);
        saxParser.parse(file, (DefaultHandler)cve20Handler);
    }
}

