/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.cpe;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.Version;
import org.owasp.dependencycheck.data.cpe.BaseIndex;
import org.owasp.dependencycheck.data.cpe.IndexEntry;
import org.owasp.dependencycheck.data.lucene.FieldAnalyzer;

public class CpeIndexWriter
extends BaseIndex {
    private IndexWriter indexWriter;
    private Analyzer indexingAnalyzer;

    @Override
    public void open() throws IOException {
        super.open();
        this.indexingAnalyzer = this.createIndexingAnalyzer();
        IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_43, this.indexingAnalyzer);
        this.indexWriter = new IndexWriter(this.getDirectory(), conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.indexWriter != null) {
            this.commit();
            try {
                this.indexWriter.close(true);
            }
            catch (CorruptIndexException ex) {
                String msg = "Unable to update database, there is a corrupt index.";
                Logger.getLogger(CpeIndexWriter.class.getName()).log(Level.SEVERE, "Unable to update database, there is a corrupt index.");
                Logger.getLogger(CpeIndexWriter.class.getName()).log(Level.FINE, null, ex);
            }
            catch (IOException ex) {
                String msg = "Unable to update database due to an IO error.";
                Logger.getLogger(CpeIndexWriter.class.getName()).log(Level.SEVERE, "Unable to update database due to an IO error.");
                Logger.getLogger(CpeIndexWriter.class.getName()).log(Level.FINE, null, ex);
            }
            finally {
                this.indexWriter = null;
            }
        }
        if (this.indexingAnalyzer != null) {
            this.indexingAnalyzer.close();
            this.indexingAnalyzer = null;
        }
        super.close();
    }

    public void commit() {
        if (this.indexWriter != null) {
            try {
                this.indexWriter.forceMerge(1);
                this.indexWriter.commit();
            }
            catch (CorruptIndexException ex) {
                String msg = "Unable to update database, there is a corrupt index.";
                Logger.getLogger(CpeIndexWriter.class.getName()).log(Level.SEVERE, "Unable to update database, there is a corrupt index.");
                Logger.getLogger(CpeIndexWriter.class.getName()).log(Level.FINE, null, ex);
            }
            catch (IOException ex) {
                String msg = "Unable to update database due to an IO error.";
                Logger.getLogger(CpeIndexWriter.class.getName()).log(Level.SEVERE, "Unable to update database due to an IO error.");
                Logger.getLogger(CpeIndexWriter.class.getName()).log(Level.FINE, null, ex);
            }
        }
    }

    private Analyzer createIndexingAnalyzer() {
        HashMap<String, KeywordAnalyzer> fieldAnalyzers = new HashMap<String, KeywordAnalyzer>();
        fieldAnalyzers.put("id", new KeywordAnalyzer());
        return new PerFieldAnalyzerWrapper((Analyzer)new FieldAnalyzer(Version.LUCENE_43), fieldAnalyzers);
    }

    public void saveEntry(IndexEntry entry) throws CorruptIndexException, IOException {
        Document doc = new Document();
        StringField documentKey = new StringField("id", entry.getDocumentId(), Field.Store.NO);
        TextField vendor = new TextField("vendor", entry.getVendor(), Field.Store.YES);
        TextField product = new TextField("product", entry.getProduct(), Field.Store.YES);
        doc.add((IndexableField)documentKey);
        doc.add((IndexableField)vendor);
        doc.add((IndexableField)product);
        Term term = new Term("id", entry.getDocumentId());
        this.indexWriter.updateDocument(term, (Iterable)doc);
    }
}

