/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.cpe;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.owasp.dependencycheck.data.cpe.BaseIndex;
import org.owasp.dependencycheck.data.lucene.FieldAnalyzer;
import org.owasp.dependencycheck.data.lucene.SearchFieldAnalyzer;

public class CpeIndexReader
extends BaseIndex {
    private IndexReader indexReader;
    private IndexSearcher indexSearcher;
    private Analyzer searchingAnalyzer;
    private QueryParser queryParser;
    private SearchFieldAnalyzer productSearchFieldAnalyzer;
    private SearchFieldAnalyzer vendorSearchFieldAnalyzer;

    @Override
    public void open() throws IOException {
        super.open();
        this.indexReader = DirectoryReader.open((Directory)this.getDirectory());
        this.indexSearcher = new IndexSearcher(this.indexReader);
        this.searchingAnalyzer = this.createSearchingAnalyzer();
        this.queryParser = new QueryParser(Version.LUCENE_43, "id", this.searchingAnalyzer);
    }

    @Override
    public void close() {
        if (this.searchingAnalyzer != null) {
            this.searchingAnalyzer.close();
            this.searchingAnalyzer = null;
        }
        if (this.indexReader != null) {
            try {
                this.indexReader.close();
            }
            catch (IOException ex) {
                Logger.getLogger(CpeIndexReader.class.getName()).log(Level.FINEST, null, ex);
            }
            this.indexReader = null;
        }
        this.queryParser = null;
        this.indexSearcher = null;
        super.close();
    }

    public TopDocs search(String searchString, int maxQueryResults) throws ParseException, IOException {
        if (searchString == null || searchString.trim().isEmpty()) {
            throw new ParseException("Query is null or empty");
        }
        if (this.queryParser == null) {
            String msg;
            if (this.isOpen()) {
                msg = String.format("QueryParser is null for query: '%s'. Attempting to reopen index.", searchString);
                Logger.getLogger(CpeIndexReader.class.getName()).log(Level.WARNING, msg);
                this.close();
                this.open();
            } else {
                msg = String.format("QueryParser is null, but data source is open, for query: '%s'. Attempting to reopen index.", searchString);
                Logger.getLogger(CpeIndexReader.class.getName()).log(Level.WARNING, msg);
                this.close();
                this.open();
            }
        }
        Query query = this.queryParser.parse(searchString);
        return this.indexSearcher.search(query, maxQueryResults);
    }

    public TopDocs search(Query query, int maxQueryResults) throws CorruptIndexException, IOException {
        this.resetSearchingAnalyzer();
        return this.indexSearcher.search(query, maxQueryResults);
    }

    public Document getDocument(int documentId) throws IOException {
        return this.indexSearcher.doc(documentId);
    }

    private Analyzer createSearchingAnalyzer() {
        HashMap<String, Object> fieldAnalyzers = new HashMap<String, Object>();
        fieldAnalyzers.put("id", new KeywordAnalyzer());
        this.productSearchFieldAnalyzer = new SearchFieldAnalyzer(Version.LUCENE_43);
        this.vendorSearchFieldAnalyzer = new SearchFieldAnalyzer(Version.LUCENE_43);
        fieldAnalyzers.put("product", (Object)this.productSearchFieldAnalyzer);
        fieldAnalyzers.put("vendor", (Object)this.vendorSearchFieldAnalyzer);
        return new PerFieldAnalyzerWrapper((Analyzer)new FieldAnalyzer(Version.LUCENE_43), fieldAnalyzers);
    }

    private void resetSearchingAnalyzer() {
        if (this.productSearchFieldAnalyzer != null) {
            this.productSearchFieldAnalyzer.clear();
        }
        if (this.vendorSearchFieldAnalyzer != null) {
            this.vendorSearchFieldAnalyzer.clear();
        }
    }
}

