/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.data.cwe.CweDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Reference;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.owasp.dependencycheck.utils.Settings;

public class CveDB {
    public static final String DB_STRUCTURE_RESOURCE = "data/initialize.sql";
    public static final String DB_SCHEMA_VERSION = "2.5";
    private Connection conn;
    public static final String DELETE_REFERENCE = "DELETE FROM reference WHERE cveid = ?";
    public static final String DELETE_SOFTWARE = "DELETE FROM software WHERE cveid = ?";
    public static final String DELETE_VULNERABILITY = "DELETE FROM vulnerability WHERE cve = ?";
    public static final String CLEANUP_ORPHANS = "DELETE FROM CpeEntry WHERE id not in (SELECT CPEEntryId FROM Software); ";
    public static final String INSERT_REFERENCE = "INSERT INTO reference (cveid, name, url, source) VALUES (?, ?, ?, ?)";
    public static final String INSERT_SOFTWARE = "INSERT INTO software (cveid, cpeEntryId, previousVersion) VALUES (?, ?, ?)";
    public static final String INSERT_CPE = "INSERT INTO cpeEntry (cpe, vendor, product) VALUES (?, ?, ?)";
    public static final String SELECT_CPE_ID = "SELECT id FROM cpeEntry WHERE cpe = ?";
    public static final String INSERT_VULNERABILITY = "INSERT INTO vulnerability (cve, description, cwe, cvssScore, cvssAccessVector, cvssAccessComplexity, cvssAuthentication, cvssConfidentialityImpact, cvssIntegrityImpact, cvssAvailabilityImpact) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String UPDATE_VULNERABILITY = "UPDATE vulnerability SET description=?, cwe=?, cvssScore=?, cvssAccessVector=?, cvssAccessComplexity=?, cvssAuthentication=?, cvssConfidentialityImpact=?, cvssIntegrityImpact=?, cvssAvailabilityImpact=? WHERE id=?";
    public static final String SELECT_CVE_FROM_SOFTWARE = "SELECT cve, cpe, previousVersion FROM software INNER JOIN vulnerability ON vulnerability.id = software.cveId INNER JOIN cpeEntry ON cpeEntry.id = software.cpeEntryId WHERE vendor = ? AND product = ?";
    public static final String SELECT_CPE_ENTRIES = "SELECT cpe FROM cpeEntry WHERE vendor = ? AND product = ?";
    public static final String SELECT_REFERENCE = "SELECT source, name, url FROM reference WHERE cveid = ?";
    public static final String SELECT_SOFTWARE = "SELECT cpe, previousVersion FROM software INNER JOIN cpeEntry ON software.cpeEntryId = cpeEntry.id WHERE cveid = ?";
    public static final String SELECT_VULNERABILITY = "SELECT id, description, cwe, cvssScore, cvssAccessVector, cvssAccessComplexity, cvssAuthentication, cvssConfidentialityImpact, cvssIntegrityImpact, cvssAvailabilityImpact FROM vulnerability WHERE cve = ?";
    public static final String SELECT_VULNERABILITY_ID = "SELECT id FROM vulnerability WHERE cve = ?";

    @SuppressWarnings(value={"DMI_EMPTY_DB_PASSWORD"}, justification="Yes, I know... Blank password.")
    public void open() throws IOException, SQLException, DatabaseException, ClassNotFoundException {
        String fileName = CveDB.getDataDirectory().getCanonicalPath();
        File f = new File(fileName, "cve.2.5");
        File check = new File(f.getAbsolutePath() + ".h2.db");
        boolean createTables = !check.exists();
        String connStr = "jdbc:h2:file:" + f.getAbsolutePath();
        Class.forName("org.h2.Driver");
        this.conn = DriverManager.getConnection(connStr, "sa", "");
        if (createTables) {
            this.createTables();
        }
    }

    public void commit() throws SQLException {
        if (this.conn != null) {
            this.conn.commit();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException ex) {
                String msg = "There was an error attempting to close the CveDB, see the log for more details.";
                Logger.getLogger(CveDB.class.getName()).log(Level.SEVERE, "There was an error attempting to close the CveDB, see the log for more details.", ex);
                Logger.getLogger(CveDB.class.getName()).log(Level.FINE, null, ex);
            }
            this.conn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<VulnerableSoftware> getCPEs(String vendor, String product) {
        HashSet<VulnerableSoftware> cpe = new HashSet<VulnerableSoftware>();
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(SELECT_CPE_ENTRIES);
            ps.setString(1, vendor);
            ps.setString(2, product);
            rs = ps.executeQuery();
            while (rs.next()) {
                VulnerableSoftware vs = new VulnerableSoftware();
                vs.setCpe(rs.getString(1));
                cpe.add(vs);
            }
            this.closeResultSet(rs);
            this.closeStatement(ps);
        }
        catch (SQLException ex) {
            Logger.getLogger(CveDB.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.closeResultSet(rs);
            this.closeStatement(ps);
        }
        return cpe;
    }

    public List<Vulnerability> getVulnerabilities(String cpeStr) throws DatabaseException {
        ResultSet rs = null;
        VulnerableSoftware cpe = new VulnerableSoftware();
        try {
            cpe.parseName(cpeStr);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(CveDB.class.getName()).log(Level.FINEST, null, ex);
        }
        DependencyVersion detectedVersion = this.parseDependencyVersion(cpe);
        ArrayList<Vulnerability> vulnerabilities = new ArrayList<Vulnerability>();
        HashSet<String> cveEntries = new HashSet<String>();
        try {
            PreparedStatement ps = this.conn.prepareStatement(SELECT_CVE_FROM_SOFTWARE);
            ps.setString(1, cpe.getVendor());
            ps.setString(2, cpe.getProduct());
            rs = ps.executeQuery();
            while (rs.next()) {
                String cveId = rs.getString(1);
                String cpeId = rs.getString(2);
                String previous = rs.getString(3);
                if (cveEntries.contains(cveId) || !this.isAffected(cpe.getVendor(), cpe.getProduct(), detectedVersion, cpeId, previous)) continue;
                cveEntries.add(cveId);
            }
            this.closeResultSet(rs);
            this.closeStatement(ps);
            for (String cve : cveEntries) {
                Vulnerability v = this.getVulnerability(cve);
                vulnerabilities.add(v);
            }
            this.closeResultSet(rs);
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Exception retrieving vulnerability for " + cpeStr, ex);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
        return vulnerabilities;
    }

    private Vulnerability getVulnerability(String cve) throws DatabaseException {
        PreparedStatement psV = null;
        PreparedStatement psR = null;
        PreparedStatement psS = null;
        ResultSet rsV = null;
        ResultSet rsR = null;
        ResultSet rsS = null;
        Vulnerability vuln = null;
        try {
            psV = this.conn.prepareStatement(SELECT_VULNERABILITY);
            psV.setString(1, cve);
            rsV = psV.executeQuery();
            if (rsV.next()) {
                String name;
                vuln = new Vulnerability();
                vuln.setName(cve);
                vuln.setDescription(rsV.getString(2));
                String cwe = rsV.getString(3);
                if (cwe != null && (name = CweDB.getCweName(cwe)) != null) {
                    cwe = cwe + " " + name;
                }
                int cveId = rsV.getInt(1);
                vuln.setCwe(cwe);
                vuln.setCvssScore(rsV.getFloat(4));
                vuln.setCvssAccessVector(rsV.getString(5));
                vuln.setCvssAccessComplexity(rsV.getString(6));
                vuln.setCvssAuthentication(rsV.getString(7));
                vuln.setCvssConfidentialityImpact(rsV.getString(8));
                vuln.setCvssIntegrityImpact(rsV.getString(9));
                vuln.setCvssAvailabilityImpact(rsV.getString(10));
                psR = this.conn.prepareStatement(SELECT_REFERENCE);
                psR.setInt(1, cveId);
                rsR = psR.executeQuery();
                while (rsR.next()) {
                    vuln.addReference(rsR.getString(1), rsR.getString(2), rsR.getString(3));
                }
                psS = this.conn.prepareStatement(SELECT_SOFTWARE);
                psS.setInt(1, cveId);
                rsS = psS.executeQuery();
                while (rsS.next()) {
                    String cpe = rsS.getString(1);
                    String prevVersion = rsS.getString(2);
                    if (prevVersion == null) {
                        vuln.addVulnerableSoftware(cpe);
                        continue;
                    }
                    vuln.addVulnerableSoftware(cpe, prevVersion);
                }
            }
            this.closeResultSet(rsV);
            this.closeResultSet(rsR);
            this.closeResultSet(rsS);
            this.closeStatement(psV);
            this.closeStatement(psR);
            this.closeStatement(psS);
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Error retrieving " + cve, ex);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rsV);
                this.closeResultSet(rsR);
                this.closeResultSet(rsS);
                this.closeStatement(psV);
                this.closeStatement(psR);
                this.closeStatement(psS);
                throw throwable;
            }
        }
        return vuln;
    }

    public void updateVulnerability(Vulnerability vuln) throws DatabaseException {
        PreparedStatement selectVulnerabilityId = null;
        PreparedStatement deleteReferences = null;
        PreparedStatement deleteSoftware = null;
        PreparedStatement updateVulnerability = null;
        PreparedStatement insertVulnerability = null;
        PreparedStatement insertReference = null;
        PreparedStatement selectCpeId = null;
        PreparedStatement insertCpe = null;
        PreparedStatement insertSoftware = null;
        try {
            selectVulnerabilityId = this.conn.prepareStatement(SELECT_VULNERABILITY_ID);
            deleteReferences = this.conn.prepareStatement(DELETE_REFERENCE);
            deleteSoftware = this.conn.prepareStatement(DELETE_SOFTWARE);
            updateVulnerability = this.conn.prepareStatement(UPDATE_VULNERABILITY);
            insertVulnerability = this.conn.prepareStatement(INSERT_VULNERABILITY, 1);
            insertReference = this.conn.prepareStatement(INSERT_REFERENCE);
            selectCpeId = this.conn.prepareStatement(SELECT_CPE_ID);
            insertCpe = this.conn.prepareStatement(INSERT_CPE, 1);
            insertSoftware = this.conn.prepareStatement(INSERT_SOFTWARE);
            int vulnerabilityId = 0;
            selectVulnerabilityId.setString(1, vuln.getName());
            ResultSet rs = selectVulnerabilityId.executeQuery();
            if (rs.next()) {
                vulnerabilityId = rs.getInt(1);
                deleteReferences.setInt(1, vulnerabilityId);
                deleteReferences.execute();
                deleteSoftware.setInt(1, vulnerabilityId);
                deleteSoftware.execute();
            }
            this.closeResultSet(rs);
            rs = null;
            if (vulnerabilityId != 0) {
                updateVulnerability.setString(1, vuln.getDescription());
                updateVulnerability.setString(2, vuln.getCwe());
                updateVulnerability.setFloat(3, vuln.getCvssScore());
                updateVulnerability.setString(4, vuln.getCvssAccessVector());
                updateVulnerability.setString(5, vuln.getCvssAccessComplexity());
                updateVulnerability.setString(6, vuln.getCvssAuthentication());
                updateVulnerability.setString(7, vuln.getCvssConfidentialityImpact());
                updateVulnerability.setString(8, vuln.getCvssIntegrityImpact());
                updateVulnerability.setString(9, vuln.getCvssAvailabilityImpact());
                updateVulnerability.setInt(10, vulnerabilityId);
                updateVulnerability.executeUpdate();
            } else {
                insertVulnerability.setString(1, vuln.getName());
                insertVulnerability.setString(2, vuln.getDescription());
                insertVulnerability.setString(3, vuln.getCwe());
                insertVulnerability.setFloat(4, vuln.getCvssScore());
                insertVulnerability.setString(5, vuln.getCvssAccessVector());
                insertVulnerability.setString(6, vuln.getCvssAccessComplexity());
                insertVulnerability.setString(7, vuln.getCvssAuthentication());
                insertVulnerability.setString(8, vuln.getCvssConfidentialityImpact());
                insertVulnerability.setString(9, vuln.getCvssIntegrityImpact());
                insertVulnerability.setString(10, vuln.getCvssAvailabilityImpact());
                insertVulnerability.execute();
                try {
                    rs = insertVulnerability.getGeneratedKeys();
                    rs.next();
                    vulnerabilityId = rs.getInt(1);
                }
                catch (SQLException ex) {
                    String msg = String.format("Unable to retrieve id for new vulnerability for '%s'", vuln.getName());
                    throw new DatabaseException(msg, ex);
                }
                finally {
                    this.closeResultSet(rs);
                    rs = null;
                }
            }
            insertReference.setInt(1, vulnerabilityId);
            for (Reference r : vuln.getReferences()) {
                insertReference.setString(2, r.getName());
                insertReference.setString(3, r.getUrl());
                insertReference.setString(4, r.getSource());
                insertReference.execute();
            }
            for (VulnerableSoftware s : vuln.getVulnerableSoftware()) {
                int cpeProductId = 0;
                selectCpeId.setString(1, s.getName());
                try {
                    rs = selectCpeId.executeQuery();
                    if (rs.next()) {
                        cpeProductId = rs.getInt(1);
                    }
                }
                catch (SQLException ex) {
                    throw new DatabaseException("Unable to get primary key for new cpe: " + s.getName(), ex);
                }
                finally {
                    this.closeResultSet(rs);
                    rs = null;
                }
                if (cpeProductId == 0) {
                    insertCpe.setString(1, s.getName());
                    insertCpe.setString(2, s.getVendor());
                    insertCpe.setString(3, s.getProduct());
                    insertCpe.executeUpdate();
                    cpeProductId = this.getGeneratedKey(insertCpe);
                }
                if (cpeProductId == 0) {
                    throw new DatabaseException("Unable to retrieve cpeProductId - no data returned");
                }
                insertSoftware.setInt(1, vulnerabilityId);
                insertSoftware.setInt(2, cpeProductId);
                if (s.getPreviousVersion() == null) {
                    insertSoftware.setNull(3, 12);
                } else {
                    insertSoftware.setString(3, s.getPreviousVersion());
                }
                insertSoftware.execute();
            }
            this.closeStatement(selectVulnerabilityId);
            this.closeStatement(deleteReferences);
            this.closeStatement(deleteSoftware);
            this.closeStatement(updateVulnerability);
            this.closeStatement(insertVulnerability);
            this.closeStatement(insertReference);
            this.closeStatement(selectCpeId);
            this.closeStatement(insertCpe);
            this.closeStatement(insertSoftware);
        }
        catch (SQLException ex) {
            try {
                String msg = String.format("Error updating '%s'", vuln.getName());
                Logger.getLogger(CveDB.class.getName()).log(Level.FINE, null, ex);
                throw new DatabaseException(msg, ex);
            }
            catch (Throwable throwable) {
                this.closeStatement(selectVulnerabilityId);
                this.closeStatement(deleteReferences);
                this.closeStatement(deleteSoftware);
                this.closeStatement(updateVulnerability);
                this.closeStatement(insertVulnerability);
                this.closeStatement(insertReference);
                this.closeStatement(selectCpeId);
                this.closeStatement(insertCpe);
                this.closeStatement(insertSoftware);
                throw throwable;
            }
        }
    }

    public static File getDataDirectory() throws IOException {
        File path = Settings.getFile("data.cve");
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("Unable to create NVD CVE Data directory");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupDatabase() {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(CLEANUP_ORPHANS);
            if (ps != null) {
                ps.executeUpdate();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(CveDB.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.closeStatement(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTables() throws SQLException, DatabaseException {
        BufferedReader in = null;
        try {
            String tmp;
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(DB_STRUCTURE_RESOURCE);
            InputStreamReader reader = new InputStreamReader(is, "UTF-8");
            in = new BufferedReader(reader);
            StringBuilder sb = new StringBuilder(2110);
            while ((tmp = in.readLine()) != null) {
                sb.append(tmp);
            }
            Statement statement = null;
            try {
                statement = this.conn.createStatement();
                statement.execute(sb.toString());
            }
            finally {
                this.closeStatement(statement);
            }
        }
        catch (IOException ex) {
            throw new DatabaseException("Unable to create database schema", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(CveDB.class.getName()).log(Level.FINEST, null, ex);
                }
            }
        }
    }

    private void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(CveDB.class.getName()).log(Level.FINEST, statement.toString(), ex);
            }
        }
    }

    private void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(CveDB.class.getName()).log(Level.FINEST, rs.toString(), ex);
            }
        }
    }

    private int getGeneratedKey(PreparedStatement statement) throws DatabaseException {
        ResultSet rs = null;
        int id = 0;
        try {
            rs = statement.getGeneratedKeys();
            rs.next();
            id = rs.getInt(1);
        }
        catch (SQLException ex) {
            throw new DatabaseException("Unable to get primary key for inserted row");
        }
        finally {
            this.closeResultSet(rs);
        }
        return id;
    }

    private boolean isAffected(String vendor, String product, DependencyVersion identifiedVersion, String cpeId, String previous) {
        boolean prevAffected;
        boolean affected = false;
        boolean isStruts = "apache".equals(vendor) && "struts".equals(product);
        DependencyVersion v = this.parseDependencyVersion(cpeId);
        boolean bl = previous == null ? false : (prevAffected = !previous.isEmpty());
        if (identifiedVersion == null || "-".equals(identifiedVersion.toString())) {
            if (v == null || "-".equals(v.toString())) {
                affected = true;
            }
        } else if (identifiedVersion.equals(v) || prevAffected && identifiedVersion.compareTo(v) < 0) {
            if (isStruts) {
                if (identifiedVersion.getVersionParts().get(0).equals(v.getVersionParts().get(0))) {
                    affected = true;
                }
            } else {
                affected = true;
            }
        }
        return affected;
    }

    private DependencyVersion parseDependencyVersion(String cpeStr) {
        VulnerableSoftware cpe = new VulnerableSoftware();
        try {
            cpe.parseName(cpeStr);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(CveDB.class.getName()).log(Level.FINEST, null, ex);
        }
        return this.parseDependencyVersion(cpe);
    }

    private DependencyVersion parseDependencyVersion(VulnerableSoftware cpe) {
        DependencyVersion cpeVersion;
        if (cpe.getVersion() != null && cpe.getVersion().length() > 0) {
            String versionText = cpe.getRevision() != null && cpe.getRevision().length() > 0 ? String.format("%s.%s", cpe.getVersion(), cpe.getRevision()) : cpe.getVersion();
            cpeVersion = DependencyVersionUtil.parseVersion(versionText);
        } else {
            cpeVersion = new DependencyVersion("-");
        }
        return cpeVersion;
    }
}

