/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.cpe;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.owasp.dependencycheck.data.cpe.IndexEntry;
import org.owasp.dependencycheck.data.lucene.AbstractIndex;
import org.owasp.dependencycheck.data.lucene.FieldAnalyzer;
import org.owasp.dependencycheck.data.lucene.SearchFieldAnalyzer;
import org.owasp.dependencycheck.utils.Settings;

public class Index
extends AbstractIndex {
    private SearchFieldAnalyzer productSearchFieldAnalyzer;
    private SearchFieldAnalyzer vendorSearchFieldAnalyzer;

    @Override
    public Directory getDirectory() throws IOException {
        File path = this.getDataDirectory();
        return FSDirectory.open((File)path);
    }

    public File getDataDirectory() throws IOException {
        File path = Settings.getFile("data.cpe");
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("Unable to create CPE Data directory");
        }
        return path;
    }

    @Override
    public Analyzer createIndexingAnalyzer() {
        HashMap<String, KeywordAnalyzer> fieldAnalyzers = new HashMap<String, KeywordAnalyzer>();
        fieldAnalyzers.put("id", new KeywordAnalyzer());
        return new PerFieldAnalyzerWrapper((Analyzer)new FieldAnalyzer(Version.LUCENE_43), fieldAnalyzers);
    }

    @Override
    public Analyzer createSearchingAnalyzer() {
        HashMap<String, Object> fieldAnalyzers = new HashMap<String, Object>();
        fieldAnalyzers.put("id", new KeywordAnalyzer());
        this.productSearchFieldAnalyzer = new SearchFieldAnalyzer(Version.LUCENE_43);
        this.vendorSearchFieldAnalyzer = new SearchFieldAnalyzer(Version.LUCENE_43);
        fieldAnalyzers.put("product", (Object)this.productSearchFieldAnalyzer);
        fieldAnalyzers.put("vendor", (Object)this.vendorSearchFieldAnalyzer);
        return new PerFieldAnalyzerWrapper((Analyzer)new FieldAnalyzer(Version.LUCENE_43), fieldAnalyzers);
    }

    @Override
    public QueryParser createQueryParser() {
        return new QueryParser(Version.LUCENE_43, "id", this.getSearchingAnalyzer());
    }

    @Override
    protected void resetSearchingAnalyzer() {
        if (this.productSearchFieldAnalyzer != null) {
            this.productSearchFieldAnalyzer.clear();
        }
        if (this.vendorSearchFieldAnalyzer != null) {
            this.vendorSearchFieldAnalyzer.clear();
        }
    }

    public void saveEntry(IndexEntry entry) throws CorruptIndexException, IOException {
        Document doc = this.convertEntryToDoc(entry);
        Term term = new Term("id", entry.getDocumentId());
        this.getIndexWriter().updateDocument(term, (Iterable)doc);
    }

    protected Document convertEntryToDoc(IndexEntry entry) {
        Document doc = new Document();
        TextField vendor = new TextField("vendor", entry.getVendor(), Field.Store.YES);
        doc.add((IndexableField)vendor);
        TextField product = new TextField("product", entry.getProduct(), Field.Store.YES);
        doc.add((IndexableField)product);
        return doc;
    }
}

