/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.h2.store.fs.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisException;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.utils.Settings;

public class ArchiveAnalyzer
extends AbstractAnalyzer
implements Analyzer {
    private static final int BUFFER_SIZE = 4096;
    private static int dirCount = 0;
    private File tempFileLocation = null;
    private static final int MAX_SCAN_DEPTH = Settings.getInt("archive.scan.depth", 3);
    private int scanDepth = 0;
    private static final String ANALYZER_NAME = "Archive Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INITIAL;
    private static final Set<String> EXTENSIONS = ArchiveAnalyzer.newHashSet("zip", "ear", "war");

    @Override
    public Set<String> getSupportedExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return EXTENSIONS.contains(extension);
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    public void initialize() throws Exception {
        String tmpDir = Settings.getString("temp.directory", System.getProperty("java.io.tmpdir"));
        File baseDir = new File(tmpDir);
        this.tempFileLocation = File.createTempFile("check", "tmp", baseDir);
        if (!this.tempFileLocation.delete()) {
            throw new AnalysisException("Unable to delete temporary file '" + this.tempFileLocation.getAbsolutePath() + "'.");
        }
        if (!this.tempFileLocation.mkdirs()) {
            throw new AnalysisException("Unable to create directory '" + this.tempFileLocation.getAbsolutePath() + "'.");
        }
    }

    @Override
    public void close() throws Exception {
        if (this.tempFileLocation != null && this.tempFileLocation.exists()) {
            FileUtils.deleteRecursive((String)this.tempFileLocation.getAbsolutePath(), (boolean)true);
        }
    }

    @Override
    public void analyze(Dependency dependency, Engine engine) throws AnalysisException {
        File f = new File(dependency.getActualFilePath());
        File tmpDir = this.getNextTempDirectory();
        this.extractFiles(f, tmpDir, engine);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(engine.getDependencies());
        engine.scan(tmpDir);
        List<Dependency> newDependencies = engine.getDependencies();
        if (dependencies.size() != newDependencies.size()) {
            HashSet<Dependency> dependencySet = new HashSet<Dependency>();
            dependencySet.addAll(newDependencies);
            dependencySet.removeAll(dependencies);
            for (Dependency d : dependencySet) {
                String displayPath = String.format("%s%s", dependency.getFilePath(), d.getActualFilePath().substring(tmpDir.getAbsolutePath().length()));
                String displayName = String.format("%s%s%s", dependency.getFileName(), File.separator, d.getFileName());
                d.setFilePath(displayPath);
                d.setFileName(displayName);
                if (!this.supportsExtension(d.getFileExtension()) || this.scanDepth >= MAX_SCAN_DEPTH) continue;
                ++this.scanDepth;
                this.analyze(d, engine);
                --this.scanDepth;
            }
        }
        Collections.sort(engine.getDependencies());
    }

    private File getNextTempDirectory() throws AnalysisException {
        File directory;
        if (!(directory = new File(this.tempFileLocation, String.valueOf(++dirCount))).mkdirs()) {
            throw new AnalysisException("Unable to create temp directory '" + directory.getAbsolutePath() + "'.");
        }
        return directory;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractFiles(File archive, File extractTo, Engine engine) throws AnalysisException {
        if (archive == null) return;
        if (extractTo == null) {
            return;
        }
        FileInputStream fis = null;
        ZipInputStream zis = null;
        try {
            fis = new FileInputStream(archive);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.INFO, null, ex);
            throw new AnalysisException("Archive file was not found.", ex);
        }
        zis = new ZipInputStream(new BufferedInputStream(fis));
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    File d = new File(extractTo, entry.getName());
                    if (d.mkdirs()) continue;
                    throw new AnalysisException("Unable to create '" + d.getAbsolutePath() + "'.");
                }
                File file = new File(extractTo, entry.getName());
                String ext = org.owasp.dependencycheck.utils.FileUtils.getFileExtension(file.getName());
                if (!engine.supportsExtension(ext)) continue;
                FilterOutputStream bos = null;
                try {
                    int count;
                    FileOutputStream fos = new FileOutputStream(file);
                    bos = new BufferedOutputStream(fos, 4096);
                    byte[] data = new byte[4096];
                    while ((count = zis.read(data, 0, 4096)) != -1) {
                        ((BufferedOutputStream)bos).write(data, 0, count);
                    }
                    ((BufferedOutputStream)bos).flush();
                    if (bos == null) continue;
                }
                catch (FileNotFoundException ex) {
                    try {
                        Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINE, null, ex);
                        throw new AnalysisException("Unable to find file '" + file.getName() + "'.", ex);
                        catch (IOException ex2) {
                            Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINE, null, ex2);
                            throw new AnalysisException("IO Exception while parsing file '" + file.getName() + "'.", ex2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (bos == null) throw throwable;
                        try {
                            bos.close();
                            throw throwable;
                        }
                        catch (IOException ex3) {
                            Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINEST, null, ex3);
                        }
                        throw throwable;
                    }
                }
                try {
                    bos.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINEST, null, ex);
                }
            }
            return;
        }
        catch (IOException ex) {
            String msg = String.format("Exception reading archive '%s'.", archive.getName());
            Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINE, msg, ex);
            throw new AnalysisException(msg, ex);
        }
        finally {
            try {
                zis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINEST, null, ex);
            }
        }
    }
}

