/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.owasp.dependencycheck.data.CachedWebDataSource;
import org.owasp.dependencycheck.data.UpdateException;
import org.owasp.dependencycheck.data.cpe.Index;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.xml.InvalidDataException;
import org.owasp.dependencycheck.data.nvdcve.xml.NvdCve12Handler;
import org.owasp.dependencycheck.data.nvdcve.xml.NvdCve20Handler;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DatabaseUpdater
implements CachedWebDataSource {
    private static final String UPDATE_PROPERTIES_FILE = "lastupdated.prop";
    private static final String LAST_UPDATED_MODIFIED = "lastupdated.modified";
    private static final String LAST_UPDATED_BASE = "lastupdated.";
    public static final String MODIFIED = "modified";
    private CveDB cveDB = null;
    private Index cpeIndex = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws UpdateException {
        try {
            Map<String, NvdCveUrl> update = this.updateNeeded();
            int maxUpdates = 0;
            for (NvdCveUrl cve : update.values()) {
                if (!cve.getNeedsUpdate()) continue;
                ++maxUpdates;
            }
            if (maxUpdates > 3) {
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.INFO, "NVD CVE requires several updates; this could take a couple of minutes.");
            }
            if (maxUpdates > 0) {
                this.openDataStores();
            }
            int count = 0;
            for (NvdCveUrl cve : update.values()) {
                if (!cve.getNeedsUpdate()) continue;
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.INFO, "Updating NVD CVE ({0} of {1})", new Object[]{++count, maxUpdates});
                URL url = new URL(cve.getUrl());
                File outputPath = null;
                File outputPath12 = null;
                try {
                    Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.INFO, "Downloading {0}", cve.getUrl());
                    outputPath = File.createTempFile("cve" + cve.getId() + "_", ".xml");
                    Downloader.fetchFile(url, outputPath, false);
                    url = new URL(cve.getOldSchemaVersionUrl());
                    outputPath12 = File.createTempFile("cve_1_2_" + cve.getId() + "_", ".xml");
                    Downloader.fetchFile(url, outputPath12, false);
                    Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.INFO, "Processing {0}", cve.getUrl());
                    this.importXML(outputPath, outputPath12);
                    this.cveDB.commit();
                    this.cpeIndex.commit();
                    this.writeLastUpdatedPropertyFile(cve);
                    Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.INFO, "Completed update {0} of {1}", new Object[]{count, maxUpdates});
                }
                catch (FileNotFoundException ex) {
                    throw new UpdateException(ex);
                }
                catch (ParserConfigurationException ex) {
                    throw new UpdateException(ex);
                }
                catch (SAXException ex) {
                    throw new UpdateException(ex);
                }
                catch (IOException ex) {
                    throw new UpdateException(ex);
                }
                catch (SQLException ex) {
                    throw new UpdateException(ex);
                }
                catch (DatabaseException ex) {
                    throw new UpdateException(ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new UpdateException(ex);
                }
                finally {
                    boolean deleted = false;
                    try {
                        if (outputPath != null && outputPath.exists()) {
                            deleted = outputPath.delete();
                        }
                    }
                    finally {
                        if (outputPath != null && (outputPath.exists() || !deleted)) {
                            outputPath.deleteOnExit();
                        }
                    }
                    try {
                        deleted = false;
                        if (outputPath12 == null || !outputPath12.exists()) continue;
                        deleted = outputPath12.delete();
                    }
                    finally {
                        if (outputPath12 == null || !outputPath12.exists() && deleted) continue;
                        outputPath12.deleteOnExit();
                    }
                }
            }
            if (maxUpdates >= 1) {
                this.ensureModifiedIsInLastUpdatedProperties(update);
                this.cveDB.cleanupDatabase();
            }
        }
        catch (MalformedURLException ex) {
            throw new UpdateException(ex);
        }
        catch (DownloadFailedException ex) {
            throw new UpdateException(ex);
        }
        finally {
            this.closeDataStores();
        }
    }

    private void importXML(File file, File oldVersion) throws ParserConfigurationException, SAXException, IOException, SQLException, DatabaseException, ClassNotFoundException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        NvdCve12Handler cve12Handler = new NvdCve12Handler();
        saxParser.parse(oldVersion, (DefaultHandler)cve12Handler);
        Map<String, List<VulnerableSoftware>> prevVersionVulnMap = cve12Handler.getVulnerabilities();
        NvdCve20Handler cve20Handler = new NvdCve20Handler();
        cve20Handler.setCveDB(this.cveDB);
        cve20Handler.setPrevVersionVulnMap(prevVersionVulnMap);
        cve20Handler.setCpeIndex(this.cpeIndex);
        saxParser.parse(file, (DefaultHandler)cve20Handler);
    }

    private void closeDataStores() {
        if (this.cveDB != null) {
            try {
                this.cveDB.close();
            }
            catch (Exception ignore) {
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINEST, "Error closing the cveDB", ignore);
            }
        }
        if (this.cpeIndex != null) {
            try {
                this.cpeIndex.close();
            }
            catch (Exception ignore) {
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINEST, "Error closing the cpeIndex", ignore);
            }
        }
    }

    private void openDataStores() throws UpdateException {
        try {
            this.cveDB = new CveDB();
            this.cveDB.open();
            this.cpeIndex = new Index();
            this.cpeIndex.openIndexWriter();
        }
        catch (IOException ex) {
            this.closeDataStores();
            Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, "IO Error opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
        catch (SQLException ex) {
            this.closeDataStores();
            Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, "SQL Exception opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
        catch (DatabaseException ex) {
            this.closeDataStores();
            Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, "Database Exception opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
        catch (ClassNotFoundException ex) {
            this.closeDataStores();
            Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, "Class not found exception opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLastUpdatedPropertyFile(NvdCveUrl updatedValue) throws UpdateException {
        String dir;
        if (updatedValue == null) {
            return;
        }
        try {
            dir = CveDB.getDataDirectory().getCanonicalPath();
        }
        catch (IOException ex) {
            Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, "Error updating the databases propterty file.", ex);
            throw new UpdateException("Unable to locate last updated properties file.", ex);
        }
        File cveProp = new File(dir, UPDATE_PROPERTIES_FILE);
        Properties prop = new Properties();
        if (cveProp.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(cveProp);
                prop.load(in);
            }
            catch (Exception ignoreMe) {
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINEST, null, ignoreMe);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ignoreMeToo) {
                        Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINEST, null, ignoreMeToo);
                    }
                }
            }
        }
        prop.put("version", "2.5");
        prop.put(LAST_UPDATED_BASE + updatedValue.getId(), String.valueOf(updatedValue.getTimestamp()));
        FileOutputStream os = null;
        OutputStreamWriter out = null;
        try {
            os = new FileOutputStream(cveProp);
            out = new OutputStreamWriter((OutputStream)os, "UTF-8");
            prop.store(out, dir);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, null, ex);
            throw new UpdateException("Unable to find last updated properties file.", ex);
        }
        catch (IOException ex) {
            Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, null, ex);
            throw new UpdateException("Unable to update last updated properties file.", ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINEST, null, ex);
                }
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException ex) {
                    Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINEST, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, NvdCveUrl> updateNeeded() throws MalformedURLException, DownloadFailedException, UpdateException {
        Map<String, NvdCveUrl> currentlyPublished;
        block42: {
            File cveProp;
            String dir;
            try {
                currentlyPublished = this.retrieveCurrentTimestampsFromWeb();
            }
            catch (InvalidDataException ex) {
                String msg = "Unable to retrieve valid timestamp from nvd cve downloads page";
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, "Unable to retrieve valid timestamp from nvd cve downloads page", ex);
                throw new DownloadFailedException("Unable to retrieve valid timestamp from nvd cve downloads page", ex);
            }
            catch (InvalidSettingException ex) {
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, "Invalid setting found when retrieving timestamps", ex);
                throw new DownloadFailedException("Invalid settings", ex);
            }
            if (currentlyPublished == null) {
                throw new DownloadFailedException("Unable to retrieve valid timestamp from nvd cve downloads page");
            }
            try {
                dir = CveDB.getDataDirectory().getCanonicalPath();
            }
            catch (IOException ex) {
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, "CveDB data directory doesn't exist?", ex);
                throw new UpdateException("Unable to locate last updated properties file.", ex);
            }
            File f = new File(dir);
            if (f.exists() && (cveProp = new File(dir, UPDATE_PROPERTIES_FILE)).exists()) {
                Properties prop = new Properties();
                FileInputStream is = null;
                try {
                    is = new FileInputStream(cveProp);
                    prop.load(is);
                    boolean deleteAndRecreate = false;
                    if (prop.getProperty("version") == null) {
                        deleteAndRecreate = true;
                    } else {
                        try {
                            float version = Float.parseFloat(prop.getProperty("version"));
                            float currentVersion = Float.parseFloat("2.5");
                            if (currentVersion > version) {
                                deleteAndRecreate = true;
                            }
                        }
                        catch (NumberFormatException ex) {
                            deleteAndRecreate = true;
                        }
                    }
                    if (deleteAndRecreate) {
                        Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.INFO, "The database version is old. Rebuilding the database.");
                        ((InputStream)is).close();
                        FileUtils.delete(f);
                        Index cpeId = new Index();
                        File cpeDir = cpeId.getDataDirectory();
                        FileUtils.delete(cpeDir);
                        Map<String, NvdCveUrl> map = currentlyPublished;
                        return map;
                    }
                    long lastUpdated = Long.parseLong(prop.getProperty(LAST_UPDATED_MODIFIED, "0"));
                    Date now = new Date();
                    int days = Settings.getInt("cve.url.modified.validfordays", 7);
                    int start = Settings.getInt("cve.startyear", 2002);
                    int end = Calendar.getInstance().get(1);
                    if (lastUpdated == currentlyPublished.get(MODIFIED).timestamp) {
                        currentlyPublished.clear();
                        break block42;
                    }
                    if (this.withinRange(lastUpdated, now.getTime(), days)) {
                        currentlyPublished.get(MODIFIED).setNeedsUpdate(true);
                        for (int i = start; i <= end; ++i) {
                            currentlyPublished.get(String.valueOf(i)).setNeedsUpdate(false);
                        }
                        break block42;
                    }
                    currentlyPublished.get(MODIFIED).setNeedsUpdate(false);
                    for (int i = start; i <= end; ++i) {
                        NvdCveUrl cve = currentlyPublished.get(String.valueOf(i));
                        long currentTimestamp = 0L;
                        try {
                            currentTimestamp = Long.parseLong(prop.getProperty(LAST_UPDATED_BASE + String.valueOf(i), "0"));
                        }
                        catch (NumberFormatException ex) {
                            String msg = String.format("Error parsing '%s' '%s' from nvdcve.lastupdated", LAST_UPDATED_BASE, String.valueOf(i));
                            Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, msg, ex);
                        }
                        if (currentTimestamp != cve.getTimestamp()) continue;
                        cve.setNeedsUpdate(false);
                    }
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINEST, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINEST, null, ex);
                }
                catch (NumberFormatException ex) {
                    Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINEST, null, ex);
                }
                finally {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINEST, null, ex);
                        }
                    }
                }
            }
        }
        return currentlyPublished;
    }

    private boolean withinRange(long date, long compareTo, int range) {
        double differenceInDays = (double)(compareTo - date) / 1000.0 / 60.0 / 60.0 / 24.0;
        return differenceInDays < (double)range;
    }

    protected Map<String, NvdCveUrl> retrieveCurrentTimestampsFromWeb() throws MalformedURLException, DownloadFailedException, InvalidDataException, InvalidSettingException {
        HashMap<String, NvdCveUrl> map = new HashMap<String, NvdCveUrl>();
        String retrieveUrl = Settings.getString("cve.url-2.0.modified");
        NvdCveUrl item = new NvdCveUrl();
        item.setNeedsUpdate(false);
        item.setId(MODIFIED);
        item.setUrl(retrieveUrl);
        item.setOldSchemaVersionUrl(Settings.getString("cve.url-1.2.modified"));
        item.timestamp = Downloader.getLastModified(new URL(retrieveUrl));
        map.put(MODIFIED, item);
        int start = Settings.getInt("cve.startyear");
        int end = Calendar.getInstance().get(1);
        String baseUrl20 = Settings.getString("cve.url-2.0.base");
        String baseUrl12 = Settings.getString("cve.url-1.2.base");
        for (int i = start; i <= end; ++i) {
            retrieveUrl = String.format(baseUrl20, i);
            item = new NvdCveUrl();
            item.setId(Integer.toString(i));
            item.setUrl(retrieveUrl);
            item.setOldSchemaVersionUrl(String.format(baseUrl12, i));
            item.setTimestamp(Downloader.getLastModified(new URL(retrieveUrl)));
            map.put(item.id, item);
        }
        return map;
    }

    private void ensureModifiedIsInLastUpdatedProperties(Map<String, NvdCveUrl> update) {
        try {
            this.writeLastUpdatedPropertyFile(update.get(MODIFIED));
        }
        catch (UpdateException ex) {
            Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, null, ex);
        }
    }

    protected static class NvdCveUrl {
        private String id;
        private String url;
        private String oldSchemaVersionUrl;
        private long timestamp;
        private boolean needsUpdate = true;

        protected NvdCveUrl() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getOldSchemaVersionUrl() {
            return this.oldSchemaVersionUrl;
        }

        public void setOldSchemaVersionUrl(String oldSchemaVersionUrl) {
            this.oldSchemaVersionUrl = oldSchemaVersionUrl;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public boolean getNeedsUpdate() {
            return this.needsUpdate;
        }

        public void setNeedsUpdate(boolean needsUpdate) {
            this.needsUpdate = needsUpdate;
        }
    }
}

